/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.hardware.core;

import com.kwoksys.action.hardware.HardwareSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class HardwareSearch
extends BaseSearch {
    public static final String HARDWARE_ID_EQUALS = "hardwareIdEquals";
    public static final String HARDWARE_ID_NOT_EQUALS = "hardwareIdNotEquals";
    public static final String HARDWARE_NAME_EQUALS = "hardwareNameEquals";
    public static final String HARDWARE_NAME_BEGINS_WITH = "hardwareNameBeginsWith";
    public static final String HARDWARE_TYPE_CONTAINS = "hardwareTypeContains";
    public static final String HARDWARE_PURCHASED_BEFORE = "purchasedBefore";
    public static final String HARDWARE_PURCHASED_AFTER = "purchasedAfter";
    public static final String HARDWARE_MODEL_NAME_CONTAINS = "modelNameContains";
    public static final String HARDWARE_MODEL_NAME_EQUALS = "modelNameEquals";
    public static final String HARDWARE_MODEL_NUMBER_EQUALS = "modelNumberEquals";
    public static final String HARDWARE_SERIAL_NUMBER_CONTAINS = "serialNumberContains";
    public static final String HARDWARE_SERIAL_NUMBER_EQUALS = "serialNumberEquals";
    public static final String HARDWARE_WARRANTY_EXPIRED = "warrantyExpired";
    public static final String HARDWARE_WARRANTY_NOT_EXPIRED = "warrantyNotExpired";
    public static final String HARDWARE_WARRANTY_NOT_SET = "warrantyNotSet";
    public static final String HARDWARE_VENDOR_EQUALS = "vendorIdEquals";
    public static final String HARDWARE_MANUFACTURER_EQUALS = "manufacturerIdEquals";

    public HardwareSearch(RequestContext requestContext, String sessionKey) {
        super(requestContext, sessionKey);
    }

    public HardwareSearch() {
    }

    public void prepareMap(HardwareSearchForm hardwareSearchForm) {
        if (hardwareSearchForm.getCmd().equals("autoSuggestList")) {
            this.searchCriteriaMap = new HashMap();
            if (!StringUtils.isEmpty(hardwareSearchForm.getHardwareId())) {
                this.searchCriteriaMap.put(HARDWARE_ID_EQUALS, hardwareSearchForm.getHardwareId());
            }
            if (!StringUtils.isEmpty(hardwareSearchForm.getHardwareName())) {
                if (hardwareSearchForm.getHardwareNameCriteria().equals("equals")) {
                    this.searchCriteriaMap.put(HARDWARE_NAME_EQUALS, hardwareSearchForm.getHardwareName());
                } else if (hardwareSearchForm.getHardwareNameCriteria().equals("contains")) {
                    this.searchCriteriaMap.put("hardwareNameContains", hardwareSearchForm.getHardwareName());
                } else if (hardwareSearchForm.getHardwareNameCriteria().equals("begins")) {
                    this.searchCriteriaMap.put(HARDWARE_NAME_BEGINS_WITH, hardwareSearchForm.getHardwareName());
                }
            }
            return;
        }
        String cmd = this.requestContext.getParameterString("cmd");
        if (!cmd.isEmpty()) {
            this.reset();
            if (cmd.equals("filter")) {
                String hardwareTypeFilter = this.requestContext.getParameterString("hardwareTypeFilter");
                hardwareSearchForm.setHardwareTypeFilter(hardwareTypeFilter);
                if (!hardwareTypeFilter.isEmpty()) {
                    Integer hardwareType = NumberUtils.replaceNull(hardwareTypeFilter);
                    this.searchCriteriaMap.put(HARDWARE_TYPE_CONTAINS, Arrays.asList(hardwareType));
                }
            } else {
                hardwareSearchForm.setRequest(this.requestContext);
                if (cmd.equals("groupBy")) {
                    Integer hardwareLocation;
                    Integer hardwareStatus;
                    String warrantyExpire = this.requestContext.getParameterString("warrantyExpire");
                    if (!warrantyExpire.isEmpty()) {
                        String[] interval = warrantyExpire.split("_");
                        if (interval.length == 1) {
                            this.searchCriteriaMap.put("warrantyExpireBefore", interval[0]);
                        } else {
                            this.searchCriteriaMap.put("warrantyExpireAfter", interval[0]);
                            this.searchCriteriaMap.put("warrantyExpireBefore", interval[1]);
                        }
                    }
                    String hardwareTypeFilter = this.requestContext.getParameterString("hardwareType");
                    hardwareSearchForm.setHardwareTypeFilter(hardwareTypeFilter);
                    if (!hardwareTypeFilter.isEmpty()) {
                        Integer hardwareType = NumberUtils.replaceNull(hardwareTypeFilter);
                        hardwareSearchForm.setHardwareTypes(Arrays.asList(hardwareType));
                        this.searchCriteriaMap.put(HARDWARE_TYPE_CONTAINS, hardwareSearchForm.getHardwareTypes());
                    }
                    if ((hardwareStatus = this.requestContext.getParameterInteger("hardwareStatus")) != null) {
                        hardwareSearchForm.setHardwareStatus(Arrays.asList(hardwareStatus));
                        this.searchCriteriaMap.put("hardwareStatusContains", hardwareSearchForm.getHardwareStatus());
                    }
                    if ((hardwareLocation = this.requestContext.getParameterInteger("hardwareLocation")) != null) {
                        hardwareSearchForm.setHardwareLocation(Arrays.asList(hardwareLocation));
                        this.searchCriteriaMap.put("hardwareLocationContains", hardwareSearchForm.getHardwareLocation());
                    }
                } else if (cmd.equals("search")) {
                    List<Integer> locationList;
                    List<Integer> statusList;
                    List<Integer> typeList;
                    if (!hardwareSearchForm.getHardwareId().isEmpty()) {
                        this.searchCriteriaMap.put(HARDWARE_ID_EQUALS, hardwareSearchForm.getHardwareId());
                    }
                    if (!hardwareSearchForm.getHardwareName().isEmpty()) {
                        if (hardwareSearchForm.getHardwareNameCriteria().equals("equals")) {
                            this.searchCriteriaMap.put(HARDWARE_NAME_EQUALS, hardwareSearchForm.getHardwareName());
                        } else if (hardwareSearchForm.getHardwareNameCriteria().equals("contains")) {
                            this.searchCriteriaMap.put("hardwareNameContains", hardwareSearchForm.getHardwareName());
                        } else if (hardwareSearchForm.getHardwareNameCriteria().equals("begins")) {
                            this.searchCriteriaMap.put(HARDWARE_NAME_BEGINS_WITH, hardwareSearchForm.getHardwareName());
                        }
                    }
                    if (!hardwareSearchForm.getDescription().isEmpty()) {
                        this.searchCriteriaMap.put("hardwareDescription", hardwareSearchForm.getDescription());
                    }
                    if (!hardwareSearchForm.getHardwareModelName().isEmpty()) {
                        this.searchCriteriaMap.put(HARDWARE_MODEL_NAME_CONTAINS, hardwareSearchForm.getHardwareModelName());
                    }
                    if (!hardwareSearchForm.getHardwareModelNumber().isEmpty()) {
                        this.searchCriteriaMap.put("modelNumberContains", hardwareSearchForm.getHardwareModelNumber());
                    }
                    if (!hardwareSearchForm.getSerialNumber().isEmpty()) {
                        this.searchCriteriaMap.put(HARDWARE_SERIAL_NUMBER_CONTAINS, hardwareSearchForm.getSerialNumber());
                    }
                    if (!hardwareSearchForm.getHardwareOwner().isEmpty()) {
                        this.searchCriteriaMap.put("hardwareOwnerContains", hardwareSearchForm.getHardwareOwner());
                    }
                    if (!(typeList = hardwareSearchForm.getHardwareTypes()).isEmpty()) {
                        this.searchCriteriaMap.put(HARDWARE_TYPE_CONTAINS, typeList);
                    }
                    if (!(statusList = hardwareSearchForm.getHardwareStatus()).isEmpty()) {
                        this.searchCriteriaMap.put("hardwareStatusContains", statusList);
                    }
                    if (!(locationList = hardwareSearchForm.getHardwareLocation()).isEmpty()) {
                        this.searchCriteriaMap.put("hardwareLocationContains", locationList);
                    }
                    if (!hardwareSearchForm.getManufacturerId().equals(0)) {
                        this.searchCriteriaMap.put(HARDWARE_MANUFACTURER_EQUALS, hardwareSearchForm.getManufacturerId());
                    }
                    if (!hardwareSearchForm.getVendorId().equals(0)) {
                        this.searchCriteriaMap.put(HARDWARE_VENDOR_EQUALS, hardwareSearchForm.getVendorId());
                    }
                    String purchasedAfterDate = hardwareSearchForm.getPurchasedAfterDate();
                    String purchasedAfterMonth = hardwareSearchForm.getPurchasedAfterMonth();
                    String purchasedAfterYear = hardwareSearchForm.getPurchasedAfterYear();
                    if (DatetimeUtils.isValidDate(purchasedAfterYear, purchasedAfterMonth, purchasedAfterDate)) {
                        this.searchCriteriaMap.put(HARDWARE_PURCHASED_AFTER, purchasedAfterYear + "-" + purchasedAfterMonth + "-" + purchasedAfterDate);
                    }
                    String purchasedBeforeDate = hardwareSearchForm.getPurchasedBeforeDate();
                    String purchasedBeforeMonth = hardwareSearchForm.getPurchasedBeforeMonth();
                    String purchasedBeforeYear = hardwareSearchForm.getPurchasedBeforeYear();
                    if (DatetimeUtils.isValidDate(purchasedBeforeYear, purchasedBeforeMonth, purchasedBeforeDate)) {
                        this.searchCriteriaMap.put(HARDWARE_PURCHASED_BEFORE, purchasedBeforeYear + "-" + purchasedBeforeMonth + "-" + purchasedBeforeDate);
                    }
                    boolean warrantyExpired = this.requestContext.getParameterBoolean(HARDWARE_WARRANTY_EXPIRED);
                    boolean warrantyNotExpired = this.requestContext.getParameterBoolean(HARDWARE_WARRANTY_NOT_EXPIRED);
                    boolean warrantyNotSet = this.requestContext.getParameterBoolean(HARDWARE_WARRANTY_NOT_SET);
                    if (!(warrantyExpired && warrantyNotExpired && warrantyNotSet)) {
                        if (warrantyExpired) {
                            this.searchCriteriaMap.put(HARDWARE_WARRANTY_EXPIRED, true);
                        }
                        if (warrantyNotExpired) {
                            this.searchCriteriaMap.put(HARDWARE_WARRANTY_NOT_EXPIRED, true);
                        }
                        if (warrantyNotSet) {
                            this.searchCriteriaMap.put(HARDWARE_WARRANTY_NOT_SET, true);
                        }
                    }
                    if (!hardwareSearchForm.getAttrId().isEmpty() && !hardwareSearchForm.getAttrValue().isEmpty()) {
                        this.searchCriteriaMap.put("attrId", hardwareSearchForm.getAttrId());
                        this.searchCriteriaMap.put("attrValue", hardwareSearchForm.getAttrValue());
                    }
                    if (!hardwareSearchForm.getCompTypeId().isEmpty() && !hardwareSearchForm.getCompValue().isEmpty()) {
                        this.searchCriteriaMap.put("compTypeId", hardwareSearchForm.getCompTypeId());
                        this.searchCriteriaMap.put("compValue", hardwareSearchForm.getCompValue());
                    }
                }
            }
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_ID_EQUALS)) {
            query.appendWhereClause("ah.hardware_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(HARDWARE_ID_EQUALS)));
        }
        if (this.searchCriteriaMap.containsKey("attrId") && this.searchCriteriaMap.containsKey("attrValue")) {
            query.appendWhereClause("ah.hardware_id in (select object_id from object_attribute_value where attribute_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("attrId")) + " and lower(attr_value) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("attrValue")) + "%'))");
        }
        if (this.searchCriteriaMap.containsKey("compTypeId") && this.searchCriteriaMap.containsKey("compValue")) {
            query.appendWhereClause("ah.hardware_id in (select hardware_id from asset_hardware_component where hardware_component_type = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("compTypeId")) + " and lower(comp_description) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("compValue")) + "%'))");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_NAME_EQUALS)) {
            query.appendWhereClause("lower(ah.hardware_name) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_NAME_EQUALS)) + "')");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_ID_NOT_EQUALS)) {
            query.appendWhereClause("ah.hardware_id != " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(HARDWARE_ID_NOT_EQUALS)));
        }
        if (this.searchCriteriaMap.containsKey("hardwareNameContains")) {
            query.appendWhereClause("lower(ah.hardware_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("hardwareNameContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_NAME_BEGINS_WITH)) {
            query.appendWhereClause("lower(ah.hardware_name) like lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_NAME_BEGINS_WITH)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("hardwareDescription")) {
            query.appendWhereClause("lower(ah.hardware_description) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("hardwareDescription")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_MODEL_NAME_CONTAINS)) {
            query.appendWhereClause("lower(ah.hardware_model_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_MODEL_NAME_CONTAINS)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_MODEL_NAME_EQUALS)) {
            if (((String)this.searchCriteriaMap.get(HARDWARE_MODEL_NAME_EQUALS)).isEmpty()) {
                query.appendWhereClause("ah.hardware_model_name is null");
            } else {
                query.appendWhereClause("lower(ah.hardware_model_name) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_MODEL_NAME_EQUALS)) + "')");
            }
        }
        if (this.searchCriteriaMap.containsKey("modelNumberContains")) {
            query.appendWhereClause("lower(ah.hardware_model_number) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("modelNumberContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_MODEL_NUMBER_EQUALS)) {
            if (((String)this.searchCriteriaMap.get(HARDWARE_MODEL_NUMBER_EQUALS)).isEmpty()) {
                query.appendWhereClause("ah.hardware_model_number is null");
            } else {
                query.appendWhereClause("lower(ah.hardware_model_number) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_MODEL_NUMBER_EQUALS)) + "')");
            }
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_SERIAL_NUMBER_CONTAINS)) {
            query.appendWhereClause("lower(ah.hardware_serial_number) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_SERIAL_NUMBER_CONTAINS)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_SERIAL_NUMBER_EQUALS)) {
            query.appendWhereClause("lower(ah.hardware_serial_number) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_SERIAL_NUMBER_EQUALS)) + "')");
        }
        if (this.searchCriteriaMap.containsKey("hardwareOwnerContains")) {
            query.appendWhereClause(HardwareQueries.getOrderByColumn("hardware_owner_name") + " like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("hardwareOwnerContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("hardwareOwnerId")) {
            query.appendWhereClause("ah.hardware_owner_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("hardwareOwnerId")));
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_TYPE_CONTAINS)) {
            query.appendWhereClause("ah.hardware_type in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get(HARDWARE_TYPE_CONTAINS)) + ")");
        }
        if (this.searchCriteriaMap.containsKey("hardwareStatusContains")) {
            query.appendWhereClause("ah.hardware_status in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get("hardwareStatusContains")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("hardwareLocationContains")) {
            query.appendWhereClause("ah.hardware_location in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get("hardwareLocationContains")) + ")");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_MANUFACTURER_EQUALS)) {
            if (this.searchCriteriaMap.get(HARDWARE_MANUFACTURER_EQUALS).equals(0)) {
                query.appendWhereClause("mftr.company_id is null");
            } else {
                query.appendWhereClause("mftr.company_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(HARDWARE_MANUFACTURER_EQUALS)));
            }
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_VENDOR_EQUALS)) {
            if (this.searchCriteriaMap.get(HARDWARE_VENDOR_EQUALS).equals(0)) {
                query.appendWhereClause("vndr.company_id is null");
            } else {
                query.appendWhereClause("vndr.company_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(HARDWARE_VENDOR_EQUALS)));
            }
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_PURCHASED_AFTER)) {
            query.appendWhereClause("ah.hardware_purchase_date >= '" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_PURCHASED_AFTER)) + "'");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_PURCHASED_BEFORE)) {
            query.appendWhereClause("ah.hardware_purchase_date <= '" + SqlUtils.encodeString(this.searchCriteriaMap.get(HARDWARE_PURCHASED_BEFORE)) + "'");
        }
        HashSet<String> warranty = new HashSet<String>();
        if (this.searchCriteriaMap.containsKey(HARDWARE_WARRANTY_EXPIRED)) {
            warranty.add("ah.hardware_warranty_expire_date < now()");
        }
        if (this.searchCriteriaMap.containsKey(HARDWARE_WARRANTY_NOT_EXPIRED)) {
            warranty.add("ah.hardware_warranty_expire_date > now()");
        } else if (this.searchCriteriaMap.containsKey(HARDWARE_WARRANTY_NOT_SET)) {
            warranty.add("ah.hardware_warranty_expire_date is null");
        }
        String warrantyWhereClause = StringUtils.join(warranty, " or ");
        if (!warrantyWhereClause.isEmpty()) {
            query.appendWhereClause("(" + warrantyWhereClause + ")");
        }
        if (this.searchCriteriaMap.containsKey("warrantyExpireAfter")) {
            query.appendWhereClause("ah.hardware_warranty_expire_date > now()::timestamp + '+" + SqlUtils.encodeInteger(this.searchCriteriaMap.get("warrantyExpireAfter")) + " day'::interval");
        }
        if (this.searchCriteriaMap.containsKey("warrantyExpireBefore")) {
            query.appendWhereClause("ah.hardware_warranty_expire_date < now()::timestamp + '+" + SqlUtils.encodeInteger(this.searchCriteriaMap.get("warrantyExpireBefore")) + " day'::interval");
        }
    }
}

