/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.hardware.core;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.SystemUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class HardwareUtils {
    public static final String HARDWARE_LICENSE_TAB = "licenseTab";
    public static final String HARDWARE_COMP_TAB = "componentTab";
    public static final String HARDWARE_FILE_TAB = "fileTab";
    public static final String HARDWARE_ISSUE_TAB = "issueTab";
    public static final String HARDWARE_MEMBER_TAB = "memberTab";
    public static final String HARDWARE_CONTACT_TAB = "contactTab";
    public static final String[] HARDWARE_DEFAULT_COLUMNS = new String[]{"rownum", "hardware_id", "hardware_name", "hardware_description", "hardware_type", "hardware_status", "hardware_model_name", "hardware_model_number", "hardware_serial_number", "hardware_location", "hardware_purchase_date", "hardware_purchase_price", "hardware_warranty_expire_date", "hardware_last_service_date", "hardware_owner_name"};

    public static List<String> getSortableColumns() {
        return Arrays.asList("hardware_id", "hardware_name", "hardware_model_name", "hardware_model_number", "hardware_serial_number", "hardware_purchase_price", "hardware_purchase_date", "hardware_warranty_expire_date", "hardware_last_service_date", "hardware_owner_name", "hardware_location");
    }

    public static boolean isSortableColumn(String columnName) {
        return HardwareUtils.getSortableColumns().contains(columnName);
    }

    public static List<String> getColumnHeaderList() {
        return ConfigManager.app.getHardwareColumns();
    }

    public static void addHardwareHeaderCommands(RequestContext requestContext, HeaderTemplate headerTemplate, Integer hardwareId) throws DatabaseException {
        Link link;
        AccessUser accessUser = requestContext.getUser();
        if (Access.hasPermission(accessUser, AppPaths.HARDWARE_EDIT)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_EDIT + "?hardwareId=" + hardwareId);
            link.setTitleKey("itMgmt.cmd.hardwareEdit");
            headerTemplate.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.HARDWARE_ADD)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_ADD + "?copyHardwareId=" + hardwareId);
            link.setTitleKey("itMgmt.cmd.hardwareCopy");
            headerTemplate.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.HARDWARE_DELETE)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_DELETE + "?hardwareId=" + hardwareId);
            link.setTitleKey("itMgmt.cmd.hardwareDelete");
            headerTemplate.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.HARDWARE_LIST)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_LIST);
            link.setTitleKey("itMgmt.cmd.hardwareList");
            headerTemplate.addHeaderCmds(link);
        }
    }

    public static List<Link> hardwareTabList(Hardware hardware, RequestContext requestContext) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        ArrayList<Link> tabList = new ArrayList<Link>();
        if (Access.hasPermission(user, AppPaths.HARDWARE_DETAIL)) {
            tabList.add(new Link(requestContext).setName(HARDWARE_LICENSE_TAB).setAppPath(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardware.getId()).setTitle(Localizer.getText(requestContext, "itMgmt.tab.hardwareAssignedSoftware", new Object[]{hardware.getCountSoftware()})));
        }
        if (Access.hasPermission(user, AppPaths.HARDWARE_COMP)) {
            tabList.add(new Link(requestContext).setName(HARDWARE_COMP_TAB).setAppPath(AppPaths.HARDWARE_COMP + "?hardwareId=" + hardware.getId()).setTitle(Localizer.getText(requestContext, "itMgmt.tab.hardwareComponents", new Object[]{hardware.getCountComponent()})));
        }
        if (Access.hasPermission(user, AppPaths.HARDWARE_FILE)) {
            tabList.add(new Link(requestContext).setName(HARDWARE_FILE_TAB).setAjaxPath(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardware.getId()).setTitle(Localizer.getText(requestContext, "itMgmt.tab.hardwareFile", new Object[]{hardware.getCountFile()})));
        }
        if (Access.hasPermission(user, AppPaths.HARDWARE_MEMBER)) {
            tabList.add(new Link(requestContext).setName(HARDWARE_MEMBER_TAB).setAppPath(AppPaths.HARDWARE_MEMBER + "?hardwareId=" + hardware.getId()).setTitleKey("hardware.tab.hardwareMembers"));
        }
        if (Access.hasPermission(user, AppPaths.HARDWARE_ISSUE)) {
            tabList.add(new Link(requestContext).setName(HARDWARE_ISSUE_TAB).setAppPath(AppPaths.HARDWARE_ISSUE + "?hardwareId=" + hardware.getId()).setTitleKey("itMgmt.tab.hardwareIssues"));
        }
        if (Access.hasPermission(user, AppPaths.HARDWARE_CONTACTS)) {
            SystemService systemService = ServiceProvider.getSystemService(requestContext);
            List<Integer> linkedTypes = Arrays.asList(ObjectTypes.CONTACT);
            int relationshipCount = systemService.getLinkedObjectMapCount(linkedTypes, hardware.getId(), ObjectTypes.HARDWARE);
            tabList.add(new Link(requestContext).setName(HARDWARE_CONTACT_TAB).setAppPath(AppPaths.HARDWARE_CONTACTS + "?hardwareId=" + hardware.getId()).setTitle(Localizer.getText(requestContext, "common.linking.tab.linkedContacts", new Object[]{relationshipCount})));
        }
        return tabList;
    }

    public static List<DataRow> formatHardwareList(RequestContext requestContext, List<Hardware> hardwareDataset, Counter counter, String hardwarePath) throws Exception {
        return HardwareUtils.formatHardwareList(requestContext, hardwareDataset, HardwareUtils.getColumnHeaderList(), counter, hardwarePath);
    }

    public static List<DataRow> formatHardwareList(RequestContext requestContext, List<Hardware> hardwareDataset, List<String> columnHeaders, Counter counter, String hardwarePath) throws Exception {
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        if (hardwareDataset.isEmpty()) {
            return list;
        }
        AccessUser user = requestContext.getUser();
        Date unixTimestamp = requestContext.getSysdate();
        boolean hasHardwareAccess = Access.hasPermission(user, hardwarePath);
        boolean hasUserDetailAccess = Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL);
        boolean hasHwAjaxAccess = Access.hasPermission(user, AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL);
        AttributeManager attributeManager = new AttributeManager(requestContext);
        for (Hardware hardware : hardwareDataset) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnHeaders) {
                AttributeField attrField;
                if (column.equals("rownum")) {
                    columns.add(counter.incr() + ".");
                    continue;
                }
                if (column.equals("hardware_id")) {
                    columns.add(String.valueOf(hardware.getId()));
                    continue;
                }
                if (column.equals("hardware_name")) {
                    if (hasHardwareAccess) {
                        Link link = new Link(requestContext);
                        link.setTitle(hardware.getName());
                        link.setAjaxPath(hardwarePath + "?hardwareId=" + hardware.getId());
                        String tempHardwareName = link.getString();
                        if (hasHwAjaxAccess) {
                            link = new Link(requestContext).setInlineImage(Image.getInstance().getMagGlassIcon("hardwarePopupAjax.show(this," + hardware.getId() + ")"));
                            tempHardwareName = tempHardwareName + "&nbsp;" + link.getString();
                        }
                        columns.add(tempHardwareName);
                        continue;
                    }
                    columns.add(HtmlUtils.encode(hardware.getName()));
                    continue;
                }
                if (column.equals("hardware_description")) {
                    columns.add(HtmlUtils.formatMultiLineDisplay(hardware.getDescription()));
                    continue;
                }
                if (column.equals("hardware_owner_name")) {
                    AccessUser hardwareOwner = new CacheManager(requestContext).getUserCache(hardware.getOwnerId());
                    columns.add(Links.getUserIconLink(requestContext, hardwareOwner, hasUserDetailAccess, true).getString());
                    continue;
                }
                if (column.equals("hardware_model_name")) {
                    columns.add(HtmlUtils.encode(hardware.getModelName()));
                    continue;
                }
                if (column.equals("hardware_model_number")) {
                    columns.add(HtmlUtils.encode(hardware.getModelNumber()));
                    continue;
                }
                if (column.equals("hardware_serial_number")) {
                    columns.add(HtmlUtils.encode(hardware.getSerialNumber()));
                    continue;
                }
                if (column.equals("hardware_purchase_price")) {
                    columns.add(CurrencyUtils.formatCurrency(hardware.getPurchasePriceRaw(), ConfigManager.system.getCurrencySymbol()));
                    continue;
                }
                if (column.equals("hardware_purchase_date")) {
                    columns.add(DatetimeUtils.toShortDate(hardware.getHardwarePurchaseDate()));
                    continue;
                }
                if (column.equals("hardware_warranty_expire_date")) {
                    columns.add(HardwareUtils.formatWarrantyExpirationDate(requestContext, unixTimestamp, hardware.getWarrantyExpireDate()));
                    continue;
                }
                if (column.equals("hardware_last_service_date")) {
                    columns.add(hardware.getLastServicedOn());
                    continue;
                }
                if (column.equals("hardware_status")) {
                    attrField = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_STATUS).get(hardware.getStatus());
                    columns.add(Links.getAttrFieldIcon(requestContext, attrField).getString());
                    continue;
                }
                if (column.equals("hardware_type")) {
                    attrField = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_TYPE).get(hardware.getType());
                    columns.add(Links.getAttrFieldIcon(requestContext, attrField).getString());
                    continue;
                }
                if (!column.equals("hardware_location")) continue;
                columns.add(HtmlUtils.encode(attributeManager.getAttrFieldNameCache(Attributes.HARDWARE_LOCATION, hardware.getLocation())));
            }
            DataRow dataRow = new DataRow();
            dataRow.setRowId(String.valueOf(hardware.getId()));
            dataRow.setColumns(columns);
            list.add(dataRow);
        }
        return list;
    }

    public static String formatWarrantyExpirationDate(RequestContext requestContext, Date currentDate, Date expirationDate) {
        return SystemUtils.formatExpirationDateHtml(requestContext, currentDate, expirationDate, ConfigManager.app.getHardwareWarrantyExpireCountdown());
    }
}

