/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.hardware.dao;

import com.kwoksys.biz.admin.dao.AttributeDao;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.hardware.dto.HardwareComponent;
import com.kwoksys.biz.hardware.dto.HardwareSoftwareMap;
import com.kwoksys.biz.software.dto.SoftwareLicense;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HardwareDao
extends BaseDao {
    public HardwareDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Hardware> getHardwareList(QueryCriteria queryCriteria) throws DatabaseException {
        return this.getHardwareList(queryCriteria, null);
    }

    private List<Hardware> getHardwareList(QueryCriteria queryCriteria, ObjectLink objectLink) throws DatabaseException {
        final ArrayList<Hardware> list = new ArrayList<Hardware>();
        QueryHelper queryHelper = new QueryHelper(){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Hardware hardware = HardwareDao.this.newHardware(rs);
                list.add(hardware);
            }
        };
        if (objectLink != null) {
            if (objectLink.getLinkedObjectId() == null || objectLink.getLinkedObjectId() == 0) {
                queryHelper.setSqlStatement(HardwareQueries.selectLinkedHardwareListQuery(queryCriteria));
                queryHelper.addInputInt(objectLink.getObjectId());
                queryHelper.addInputInt(objectLink.getObjectTypeId());
                queryHelper.addInputInt(objectLink.getLinkedObjectTypeId());
            } else {
                queryHelper.setSqlStatement(HardwareQueries.selectObjectHardwareListQuery(queryCriteria));
                queryHelper.addInputInt(objectLink.getLinkedObjectId());
                queryHelper.addInputInt(objectLink.getLinkedObjectTypeId());
                queryHelper.addInputInt(objectLink.getObjectTypeId());
            }
        } else {
            queryHelper.setSqlStatement(HardwareQueries.selectHardwareListQuery(queryCriteria));
        }
        this.executeQuery(queryHelper);
        return list;
    }

    public Hardware getHardware(Integer hardwareId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList list = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Hardware hardware = HardwareDao.this.newHardware(rs);
                hardware.setCountSoftware(rs.getInt("software_count"));
                hardware.setCountFile(rs.getInt("file_count"));
                hardware.setCountComponent(rs.getInt("component_count"));
                list.add(hardware);
            }
        };
        queryHelper.addInputInt(hardwareId);
        this.executeSingleRecordQuery(queryHelper);
        if (!list.isEmpty()) {
            return (Hardware)list.get(0);
        }
        throw new ObjectNotFoundException("Hardware ID: " + hardwareId);
    }

    public int getCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(HardwareQueries.getHardwareCountQuery(query));
    }

    public List<Hardware> getLinkedHardwareList(QueryCriteria queryCriteria, ObjectLink objectLink) throws DatabaseException {
        return this.getHardwareList(queryCriteria, objectLink);
    }

    public Map<String, String> getWarrantyExpirationCounts() throws DatabaseException {
        final TreeMap<String, String> map = new TreeMap<String, String>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectWarrantyExpirationCountQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                map.put(rs.getString("interval"), rs.getString("count"));
            }
        };
        this.executeQuery(queryHelper);
        return map;
    }

    public List<AttributeFieldCount> getHardwareTypeCount(QueryCriteria query) throws DatabaseException {
        final ArrayList<AttributeFieldCount> list = new ArrayList<AttributeFieldCount>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareTypeCountQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeFieldCount count = new AttributeFieldCount();
                count.setAttrFieldId(rs.getInt("hardware_type"));
                count.setObjectCount(rs.getInt("hardware_count"));
                list.add(count);
            }
        };
        this.executeQuery(queryHelper);
        return list;
    }

    public List<AttributeFieldCount> getHardwareStatusCount(QueryCriteria query) throws DatabaseException {
        final ArrayList<AttributeFieldCount> list = new ArrayList<AttributeFieldCount>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareCountByStatusQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeFieldCount count = new AttributeFieldCount();
                count.setAttrFieldId(rs.getInt("hardware_status"));
                count.setObjectCount(rs.getInt("hardware_count"));
                list.add(count);
            }
        };
        this.executeQuery(queryHelper);
        return list;
    }

    public List<AttributeFieldCount> getHardwareLocationCount(QueryCriteria query) throws DatabaseException {
        final ArrayList<AttributeFieldCount> list = new ArrayList<AttributeFieldCount>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareCountByLocationQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeFieldCount count = new AttributeFieldCount();
                count.setAttrFieldId(rs.getInt("hardware_location"));
                count.setObjectCount(rs.getInt("hardware_count"));
                list.add(count);
            }
        };
        this.executeQuery(queryHelper);
        return list;
    }

    public List<Map<String, String>> getAvailableSoftware(QueryCriteria query) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareAvailableSoftwareQuery(query));
        return this.executeQueryReturnList(queryHelper);
    }

    public List<SoftwareLicense> getAvailableLicense(QueryCriteria query, Integer softwareId) throws DatabaseException {
        final ArrayList<SoftwareLicense> licenses = new ArrayList<SoftwareLicense>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareAvailableLicensesQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                SoftwareLicense license = new SoftwareLicense();
                license.setId(rs.getInt("license_id"));
                license.setKey(rs.getString("license_key"));
                license.setNote(StringUtils.replaceNull(rs.getString("license_note")));
                licenses.add(license);
            }
        };
        queryHelper.addInputInt(softwareId);
        this.executeQuery(queryHelper);
        return licenses;
    }

    public List<HardwareSoftwareMap> getInstalledLicense(QueryCriteria queryCriteria, Integer hardwareId) throws DatabaseException {
        final ArrayList<HardwareSoftwareMap> list = new ArrayList<HardwareSoftwareMap>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectInstalledLicenseQuery(queryCriteria)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                HardwareSoftwareMap map = new HardwareSoftwareMap();
                map.setMapId(rs.getInt("map_id"));
                map.setSoftwareId(rs.getInt("software_id"));
                map.getSoftware().setName(rs.getString("software_name"));
                map.setLicenseId(rs.getInt("license_id"));
                map.getLicense().setKey(rs.getString("license_key"));
                map.getLicense().setNote(StringUtils.replaceNull(rs.getString("license_note")));
                list.add(map);
            }
        };
        queryHelper.addInputInt(hardwareId);
        this.executeQuery(queryHelper);
        return list;
    }

    public List<HardwareComponent> getHardwareComponents(QueryCriteria query, Integer hardwareId) throws DatabaseException {
        final ArrayList<HardwareComponent> list = new ArrayList<HardwareComponent>();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareComponentsQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                HardwareComponent component = new HardwareComponent();
                component.setId(rs.getInt("comp_id"));
                component.setTypeName(rs.getString("comp_name"));
                component.setDescription(StringUtils.replaceNull(rs.getString("comp_description")));
                list.add(component);
            }
        };
        queryHelper.addInputInt(hardwareId);
        this.executeQuery(queryHelper);
        return list;
    }

    public HardwareComponent getHardwareComponentDetail(Integer hardwareId, Integer componentId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList list = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.selectHardwareComponentDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                HardwareComponent component = new HardwareComponent();
                component.setHardwareId(rs.getInt("hardware_id"));
                component.setId(rs.getInt("comp_id"));
                component.setType(rs.getInt("hardware_component_type"));
                component.setDescription(StringUtils.replaceNull(rs.getString("comp_description")));
                list.add(component);
            }
        };
        queryHelper.addInputInt(hardwareId);
        queryHelper.addInputInt(componentId);
        this.executeSingleRecordQuery(queryHelper);
        if (!list.isEmpty()) {
            return (HardwareComponent)list.get(0);
        }
        throw new ObjectNotFoundException("Component ID: " + componentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages addHardware(Hardware hardware) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.insertHardwareQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(hardware.getName());
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull(hardware.getDescription());
        queryHelper.addInputIntegerConvertNull(hardware.getManufacturerId());
        queryHelper.addInputIntegerConvertNull(hardware.getVendorId());
        queryHelper.addInputInt(hardware.getType());
        queryHelper.addInputInt(hardware.getStatus());
        queryHelper.addInputIntegerConvertNull(hardware.getOwnerId());
        queryHelper.addInputInt(hardware.getLocation());
        queryHelper.addInputStringConvertNull(hardware.getModelName());
        queryHelper.addInputStringConvertNull(hardware.getModelNumber());
        queryHelper.addInputStringConvertNull(hardware.getSerialNumber());
        if (hardware.getPurchasePriceRaw() == 0.0) {
            queryHelper.addInputDoubleConvertNull(null);
        } else {
            queryHelper.addInputDouble(hardware.getPurchasePriceRaw());
        }
        queryHelper.addInputInt(hardware.getResetLastServiceDate());
        queryHelper.addInputStringConvertNull(hardware.getHardwarePurchaseDateString());
        queryHelper.addInputStringConvertNull(hardware.getWarrantyExpireDateString());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            hardware.setId((Integer)queryHelper.getSqlOutputs().get(0));
            if (!hardware.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(this.requestContext);
                attributeDao.updateAttributeValue(conn, hardware.getId(), hardware.getCustomValues());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages update(Hardware hardware) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.updateHardwareQuery());
        queryHelper.addInputInt(hardware.getId());
        queryHelper.addInputStringConvertNull(hardware.getName());
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputStringConvertNull(hardware.getDescription());
        queryHelper.addInputIntegerConvertNull(hardware.getManufacturerId());
        queryHelper.addInputIntegerConvertNull(hardware.getVendorId());
        queryHelper.addInputInt(hardware.getType());
        queryHelper.addInputInt(hardware.getStatus());
        queryHelper.addInputIntegerConvertNull(hardware.getOwnerId());
        queryHelper.addInputInt(hardware.getLocation());
        queryHelper.addInputStringConvertNull(hardware.getModelName());
        queryHelper.addInputStringConvertNull(hardware.getModelNumber());
        queryHelper.addInputStringConvertNull(hardware.getSerialNumber());
        if (hardware.getPurchasePriceRaw() == 0.0) {
            queryHelper.addInputDoubleConvertNull(null);
        } else {
            queryHelper.addInputDouble(hardware.getPurchasePriceRaw());
        }
        queryHelper.addInputInt(hardware.getResetLastServiceDate());
        queryHelper.addInputStringConvertNull(hardware.hasHardwarePurchaseDate() ? hardware.getHardwarePurchaseDateString() : null);
        queryHelper.addInputStringConvertNull(hardware.hasHardwareWarrantyExpireDate() ? hardware.getWarrantyExpireDateString() : null);
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            if (!hardware.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(this.requestContext);
                attributeDao.updateAttributeValue(conn, hardware.getId(), hardware.getCustomValues());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages delete(Hardware hardware) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.deleteHardwareQuery());
        queryHelper.addInputInt(ObjectTypes.HARDWARE);
        queryHelper.addInputInt(hardware.getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages assignSoftwareLicense(HardwareSoftwareMap hsm) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.insertAssignLicenseQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(hsm.getHardwareId());
        queryHelper.addInputInt(hsm.getSoftwareId());
        queryHelper.addInputInt(hsm.getLicenseId());
        queryHelper.addInputInt(hsm.getLicenseEntitlement());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            hsm.setMapId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages unassignSoftwareLicense(HardwareSoftwareMap hsm) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.deleteAssignedLicenseQuery());
        queryHelper.addInputInt(hsm.getMapId());
        return this.executeProcedure(queryHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages addHardwareComponent(HardwareComponent component) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.insertHardwareComponentQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(component.getHardwareId());
        queryHelper.addInputStringConvertNull(component.getDescription());
        queryHelper.addInputInt(component.getType());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            component.setId((Integer)queryHelper.getSqlOutputs().get(0));
            if (!component.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(this.requestContext);
                attributeDao.updateAttributeValue(conn, component.getId(), component.getCustomValues());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages updateHardwareComponent(HardwareComponent component) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.updateHardwareComponentQuery());
        queryHelper.addInputInt(component.getHardwareId());
        queryHelper.addInputInt(component.getId());
        queryHelper.addInputStringConvertNull(component.getDescription());
        queryHelper.addInputInt(component.getType());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            if (!component.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(this.requestContext);
                attributeDao.updateAttributeValue(conn, component.getId(), component.getCustomValues());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages deleteHardwareComponent(HardwareComponent component) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.deleteHardwareComponentQuery());
        queryHelper.addInputInt(ObjectTypes.HARDWARE_COMPONENT);
        queryHelper.addInputInt(component.getHardwareId());
        queryHelper.addInputInt(component.getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages resetHardwareSoftwareCount(Integer hardwareId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.updateHardwareSoftwareCountQuery());
        queryHelper.addInputInt(hardwareId);
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages resetFileCount(Integer hardwareId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.updateHardwareFileCountQuery());
        queryHelper.addInputInt(ObjectTypes.HARDWARE);
        queryHelper.addInputInt(hardwareId);
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages resetComponentCount(Integer hardwareId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(HardwareQueries.updateHardwareComponentCountQuery());
        queryHelper.addInputInt(hardwareId);
        return this.executeProcedure(queryHelper);
    }

    private Hardware newHardware(ResultSet rs) throws SQLException, DatabaseException {
        Hardware hardware = new Hardware();
        hardware.setId(rs.getInt("hardware_id"));
        hardware.setName(rs.getString("hardware_name"));
        hardware.setDescription(StringUtils.replaceNull(rs.getString("hardware_description")));
        hardware.setSerialNumber(StringUtils.replaceNull(rs.getString("hardware_serial_number")));
        hardware.setModelName(StringUtils.replaceNull(rs.getString("hardware_model_name")));
        hardware.setModelNumber(StringUtils.replaceNull(rs.getString("hardware_model_number")));
        hardware.setManufacturerId(rs.getInt("manufacturer_company_id"));
        hardware.setManufacturerName(StringUtils.replaceNull(rs.getString("hardware_manufacturer_name")));
        hardware.setVendorId(rs.getInt("vendor_company_id"));
        hardware.setVendorName(StringUtils.replaceNull(rs.getString("hardware_vendor_name")));
        hardware.setLocation(rs.getInt("hardware_location"));
        hardware.setType(rs.getInt("hardware_type"));
        hardware.setStatus(rs.getInt("hardware_status"));
        hardware.setPurchasePrice(CurrencyUtils.formatCurrency(rs.getDouble("hardware_purchase_price"), ""));
        hardware.setLastServicedOn(DatetimeUtils.getDate(rs, "hardware_last_service_date"));
        hardware.setHardwarePurchaseDate(DatetimeUtils.getDate(rs, "hardware_purchase_date"));
        if (hardware.getHardwarePurchaseDate() != null) {
            hardware.setHardwarePurchaseDate(DatetimeUtils.toYearString(hardware.getHardwarePurchaseDate()), DatetimeUtils.toMonthString(hardware.getHardwarePurchaseDate()), DatetimeUtils.toDateString(hardware.getHardwarePurchaseDate()));
        }
        hardware.setWarrantyExpireDate(DatetimeUtils.getDate(rs, "hardware_warranty_expire_date"));
        if (hardware.getWarrantyExpireDate() != null) {
            hardware.setHardwareWarrantyExpireDate(DatetimeUtils.toYearString(hardware.getWarrantyExpireDate()), DatetimeUtils.toMonthString(hardware.getWarrantyExpireDate()), DatetimeUtils.toDateString(hardware.getWarrantyExpireDate()));
        }
        hardware.setOwnerId(rs.getInt("hardware_owner_id"));
        hardware.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
        hardware.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
        hardware.setCreator(new AccessUser());
        hardware.getCreator().setId(rs.getInt("creator"));
        hardware.getCreator().setUsername(rs.getString("creator_username"));
        hardware.getCreator().setDisplayName(rs.getString("creator_display_name"));
        hardware.setModifier(new AccessUser());
        hardware.getModifier().setId(rs.getInt("modifier"));
        hardware.getModifier().setUsername(rs.getString("modifier_username"));
        hardware.getModifier().setDisplayName(rs.getString("modifier_display_name"));
        return hardware;
    }
}

