/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.hardware.dao;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;

public class HardwareQueries {
    public static String getOrderByColumn(String column) {
        if (column.equals("hardware_name")) {
            return "lower(hardware_name)";
        }
        if (column.equals("hardware_location")) {
            return "lower(hwloc.attribute_field_name)";
        }
        if (column.equals("software_name")) {
            return "lower(software_name)";
        }
        if (column.equals("license_key")) {
            return "lower(asl.license_key)";
        }
        if (column.equals("hardware_serial_number")) {
            return "lower(hardware_serial_number)";
        }
        if (column.equals("hardware_model_name")) {
            return "lower(hardware_model_name)";
        }
        if (column.equals("hardware_model_number")) {
            return "lower(hardware_model_number)";
        }
        if (column.equals("hardware_owner_name")) {
            return ConfigManager.system.getUsernameDisplay().equals("username") ? "lower(hardware_owner_username)" : "lower(hardware_owner_display_name)";
        }
        if (column.equals("attribute_field_name")) {
            return "lower(af.attribute_field_name)";
        }
        if (column.equals("comp_name")) {
            return "lower(af.attribute_field_name)";
        }
        return column;
    }

    public static String selectHardwareListQuery(QueryCriteria query) {
        return "select ah.hardware_id, ah.hardware_number, ah.hardware_name, ah.hardware_description, ah.hardware_owner_id, ah.hardware_type, ah.hardware_status, ah.hardware_model_name, ah.hardware_model_number, ah.hardware_serial_number, ah.hardware_cost as hardware_purchase_price, ah.hardware_last_service_date, ah.hardware_purchase_date, ah.hardware_warranty_expire_date, ah.hardware_location, ah.software_count, ah.file_count, ah.component_count,ah.manufacturer_company_id, mftr.company_name as hardware_manufacturer_name, ah.vendor_company_id, vndr.company_name as hardware_vendor_name, ah.creator, ah.creation_date, ah.creator_username, ah.creator_display_name, ah.modifier, ah.modification_date, ah.modifier_username, ah.modifier_display_name from asset_hardware_view ah left outer join company mftr on ah.manufacturer_company_id = mftr.company_id left outer join company vndr on ah.vendor_company_id = vndr.company_id left outer join attribute_field_view hwloc on hwloc.attribute_field_id = ah.hardware_location " + query.createWhereClause();
    }

    public static String selectLinkedHardwareListQuery(QueryCriteria query) {
        return HardwareQueries.selectHardwareListQuery(new QueryCriteria()) + "where ah.hardware_id in (select om.linked_object_id from object_map om where om.object_id=? and om.object_type_id=? and om.linked_object_type_id=?) " + query.createWhereClause();
    }

    public static String selectObjectHardwareListQuery(QueryCriteria query) {
        return HardwareQueries.selectHardwareListQuery(new QueryCriteria()) + "where ah.hardware_id in (select om.object_id from object_map om where om.linked_object_id=? and om.linked_object_type_id=? and om.object_type_id=?) " + query.createAndClause();
    }

    public static String getHardwareCountQuery(QueryCriteria query) {
        return "select count(ah.hardware_id) as row_count from asset_hardware_view ah left outer join company mftr on ah.manufacturer_company_id = mftr.company_id left outer join company vndr on ah.vendor_company_id = vndr.company_id " + query.createWhereCountClause();
    }

    public static String selectHardwareDetailQuery() {
        return HardwareQueries.selectHardwareListQuery(new QueryCriteria()) + "where ah.hardware_id = ?";
    }

    public static String selectWarrantyExpirationCountQuery() {
        return "select '0_30' as interval, count(hardware_id) as count from asset_hardware h where h.hardware_warranty_expire_date > now()::timestamp + '+0 day'::interval and h.hardware_warranty_expire_date < now()::timestamp + '+30 day'::interval union select '30_60' as interval, count(hardware_id) from asset_hardware h where h.hardware_warranty_expire_date > now()::timestamp + '+30 day'::interval and h.hardware_warranty_expire_date < now()::timestamp + '+60 day'::interval union select '60_90' as interval, count(hardware_id) from asset_hardware h where h.hardware_warranty_expire_date > now()::timestamp + '+60 day'::interval and h.hardware_warranty_expire_date < now()::timestamp + '+90 day'::interval union select '0' as interval, count(hardware_id) from asset_hardware h where h.hardware_warranty_expire_date < now()::timestamp + '+0 day'::interval";
    }

    public static String selectHardwareTypeCountQuery(QueryCriteria query) {
        return "select h.hardware_type, count(h.hardware_id) as hardware_count from asset_hardware h left outer join (select af.attribute_field_id, af.attribute_field_name from attribute_view an, attribute_field_view af where an.object_key='hardware' and an.attribute_name='hardware_type' and an.attribute_id = af.attribute_id) af on h.hardware_type = af.attribute_field_id group by hardware_type, af.attribute_field_name " + query.createClause();
    }

    public static String selectHardwareCountByStatusQuery(QueryCriteria query) {
        return "select h.hardware_status, count(h.hardware_id) as hardware_count from asset_hardware h left outer join (select af.attribute_field_id, af.attribute_field_name from attribute_view an, attribute_field_view af where an.object_key='hardware' and an.attribute_name='hardware_status' and an.attribute_id = af.attribute_id) af on h.hardware_status = af.attribute_field_id group by hardware_status, af.attribute_field_name " + query.createClause();
    }

    public static String selectHardwareCountByLocationQuery(QueryCriteria query) {
        return "select h.hardware_location, count(h.hardware_id) as hardware_count from asset_hardware h left outer join (select af.attribute_field_id, af.attribute_field_name from attribute_view an, attribute_field_view af where an.object_key='hardware' and an.attribute_name='hardware_location' and an.attribute_id = af.attribute_id) af on h.hardware_location = af.attribute_field_id group by hardware_location, af.attribute_field_name " + query.createClause();
    }

    public static String selectHardwareAvailableSoftwareQuery(QueryCriteria query) {
        return "select software_id, software_name from asset_software " + query.createWhereClause();
    }

    public static String selectHardwareAvailableLicensesQuery(QueryCriteria query) {
        return "select asl.software_id, asl.license_id, asl.license_key, asl.license_note, asl.license_entitlement from asset_software_licenses asl left outer join asset_map am on asl.license_id = am.license_id where asl.software_id = ? group by asl.software_id, asl.license_id, asl.license_key, asl.license_note, asl.license_entitlement having count(am.license_entitlement) < asl.license_entitlement " + query.createClause();
    }

    public static String selectInstalledLicenseQuery(QueryCriteria query) {
        return "select am.map_id, am.software_id, am.license_id, s.software_name, asl.license_key, asl.license_note from asset_map am left outer join asset_software s on am.software_id = s.software_id left outer join asset_software_licenses asl on am.license_id = asl.license_id where am.hardware_id  =?" + query.createAndClause();
    }

    public static String selectHardwareComponentsQuery(QueryCriteria query) {
        return "select hc.comp_id, af.attribute_field_name as comp_name, comp_description from asset_hardware_component hc left outer join attribute_field_view af on hc.hardware_component_type = af.attribute_field_id where hc.hardware_id = ?" + query.createAndClause();
    }

    public static String selectHardwareComponentDetailQuery() {
        return "select hc.comp_id, hc.hardware_id, hc.hardware_component_type, hc.comp_description from asset_hardware_component hc where hc.hardware_id = ? and hc.comp_id = ?";
    }

    public static String insertHardwareQuery() {
        return "{call sp_hardware_add(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    }

    public static String updateHardwareQuery() {
        return "{call sp_hardware_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    }

    public static String deleteHardwareQuery() {
        return "{call sp_hardware_delete(?,?)}";
    }

    public static String insertAssignLicenseQuery() {
        return "{call sp_software_license_assign(?,?,?,?,?)}";
    }

    public static String deleteAssignedLicenseQuery() {
        return "{call sp_asset_map_delete(?)}";
    }

    public static String insertHardwareComponentQuery() {
        return "{call sp_hardware_component_add(?,?,?,?,?)}";
    }

    public static String updateHardwareComponentQuery() {
        return "{call sp_hardware_component_update(?,?,?,?,?)}";
    }

    public static String deleteHardwareComponentQuery() {
        return "{call sp_hardware_component_delete(?,?,?)}";
    }

    public static String updateHardwareSoftwareCountQuery() {
        return "{call sp_hardware_count_software_update(?)}";
    }

    public static String updateHardwareFileCountQuery() {
        return "{call sp_hardware_count_file_update(?,?)}";
    }

    public static String updateHardwareComponentCountQuery() {
        return "{call sp_hardware_count_component_update(?)}";
    }
}

