/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.hardware.dto;

import com.kwoksys.action.hardware.HardwareForm;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.Date;

public class Hardware
extends BaseObject {
    public static final String ID = "hardware_id";
    public static final String HARDWARE_NAME = "hardware_name";
    public static final String HARDWARE_DESCRIPTION = "hardware_description";
    public static final String MODEL_NAME = "hardware_model_name";
    public static final String MODEL_NUMBER = "hardware_model_number";
    public static final String SERIAL_NUMBER = "hardware_serial_number";
    public static final String SERVICE_DATE = "hardware_last_service_date";
    public static final String TYPE = "hardware_type";
    public static final String STATUS = "hardware_status";
    public static final String LOCATION = "hardware_location";
    public static final String PURCHASE_PRICE = "hardware_purchase_price";
    public static final String PURCHASE_DATE = "hardware_purchase_date";
    public static final String WARRANTY_EXPIRATION = "hardware_warranty_expire_date";
    public static final String MANUFACTURER_NAME = "hardware_manufacturer_name";
    public static final String VENDOR_NAME = "hardware_vendor_name";
    public static final String OWNER_NAME = "hardware_owner_name";
    public static final String OWNER_USERNAME = "hardware_owner_username";
    public static final String OWNER_DISPLAY_NAME = "hardware_owner_display_name";
    public static final String OWNER_ID = "hardware_owner_id";
    private String name = "";
    private String serialNumber = "";
    private String modelName = "";
    private String modelNumber = "";
    private String description;
    private Integer ownerId;
    private Integer manufacturerId = 0;
    private String manufacturerName;
    private Integer vendorId = 0;
    private String vendorName;
    private Date hardwarePurchaseDate;
    private String purchaseDate = "";
    private String purchaseMonth = "";
    private String purchaseYear = "";
    private Date warrantyExpireDate;
    private String warrantyDate = "";
    private String warrantyMonth = "";
    private String warrantyYear = "";
    private Date lastServicedOn;
    private int resetLastServiceDate = 0;
    private String purchasePrice;
    private double purchasePriceRaw;
    private Integer location = 0;
    private Integer type = new CacheManager().getSystemAttrCache(Attributes.HARDWARE_TYPE).getDefaultAttrFieldId();
    private Integer status = 0;
    private int countSoftware = 0;
    private int countComponent = 0;
    private int countFile = 0;
    private Integer fileId = 0;
    private boolean validHardwareCost = true;

    public Hardware() throws DatabaseException {
        super(ObjectTypes.HARDWARE);
    }

    public void setForm(HardwareForm actionForm) {
        this.setName(actionForm.getHardwareName());
        this.setDescription(actionForm.getHardwareDescription());
        this.setOwnerId(actionForm.getHardwareOwner());
        this.setManufacturerId(actionForm.getManufacturerId());
        this.setVendorId(actionForm.getVendorId());
        this.setType(actionForm.getHardwareType());
        this.setStatus(actionForm.getHardwareStatus());
        this.setModelName(actionForm.getHardwareModelName());
        this.setModelNumber(actionForm.getHardwareModelNumber());
        this.setSerialNumber(actionForm.getSerialNumber());
        this.setPurchasePrice(actionForm.getHardwareCost());
        this.setResetLastServiceDate(actionForm.getLastServicedOn());
        this.setHardwarePurchaseDate(actionForm.getPurchaseYear(), actionForm.getPurchaseMonth(), actionForm.getPurchaseDate());
        this.setHardwareWarrantyExpireDate(actionForm.getWarrantyYear(), actionForm.getWarrantyMonth(), actionForm.getWarrantyDate());
        this.setLocation(actionForm.getHardwareLocation());
    }

    public void setHardwarePurchaseDate(String fullDate) {
        if (!fullDate.isEmpty()) {
            String[] dateArray = fullDate.split("-");
            this.purchaseYear = dateArray[0];
            this.purchaseMonth = dateArray[1];
            this.purchaseDate = dateArray[2];
        } else {
            this.purchaseYear = "";
            this.purchaseMonth = "";
            this.purchaseDate = "";
        }
    }

    public void setHardwarePurchaseDate(String year, String month, String date) {
        this.purchaseYear = year;
        this.purchaseMonth = month;
        this.purchaseDate = date;
    }

    public boolean hasHardwarePurchaseDate() {
        return !this.purchaseYear.isEmpty() || !this.purchaseMonth.isEmpty() || !this.purchaseDate.isEmpty();
    }

    public boolean isValidPurchaseDate() {
        return DatetimeUtils.isValidDate(this.purchaseYear, this.purchaseMonth, this.purchaseDate);
    }

    public void setHardwareWarrantyExpireDate(String fullDate) {
        if (!fullDate.isEmpty()) {
            String[] dateArray = fullDate.split("-");
            this.warrantyYear = dateArray[0];
            this.warrantyMonth = dateArray[1];
            this.warrantyDate = dateArray[2];
        } else {
            this.warrantyYear = "";
            this.warrantyMonth = "";
            this.warrantyDate = "";
        }
    }

    public void setHardwareWarrantyExpireDate(String year, String month, String date) {
        this.warrantyYear = year;
        this.warrantyMonth = month;
        this.warrantyDate = date;
    }

    public boolean hasHardwareWarrantyExpireDate() {
        return !this.warrantyYear.isEmpty() || !this.warrantyMonth.isEmpty() || !this.warrantyDate.isEmpty();
    }

    public boolean isValidWarrantyExpireDate() {
        return DatetimeUtils.isValidDate(this.warrantyYear, this.warrantyMonth, this.warrantyDate);
    }

    @Override
    public boolean isAttrEmpty(String attrName) {
        if (attrName.equals(STATUS)) {
            return this.status == 0;
        }
        if (attrName.equals(LOCATION)) {
            return this.location == 0;
        }
        if (attrName.equals(TYPE)) {
            return this.type == 0;
        }
        return false;
    }

    public String getWarrantyExpireDateString() {
        return DatetimeUtils.createDatetimeString(this.warrantyYear, this.warrantyMonth, this.warrantyDate);
    }

    public String getHardwarePurchaseDateString() {
        return DatetimeUtils.createDatetimeString(this.purchaseYear, this.purchaseMonth, this.purchaseDate);
    }

    public boolean isValidHardwareCost() {
        return this.validHardwareCost;
    }

    public void setPurchasePrice(String purchasePrice) {
        if (!purchasePrice.isEmpty()) {
            if (CurrencyUtils.isValidFormat(purchasePrice = purchasePrice.replace(",", ""))) {
                this.purchasePriceRaw = Double.parseDouble(purchasePrice);
            } else {
                this.validHardwareCost = false;
            }
            this.purchasePrice = purchasePrice;
        } else {
            this.purchasePriceRaw = 0.0;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLastServicedOn() {
        return DatetimeUtils.toLocalDate(this.lastServicedOn);
    }

    public void setLastServicedOn(Date lastServicedOn) {
        this.lastServicedOn = lastServicedOn;
    }

    public Date getHardwarePurchaseDate() {
        return this.hardwarePurchaseDate;
    }

    public String getPurchaseDate() {
        return this.purchaseDate;
    }

    public String getPurchaseMonth() {
        return this.purchaseMonth;
    }

    public String getPurchaseYear() {
        return this.purchaseYear;
    }

    public String getWarrantyDate() {
        return this.warrantyDate;
    }

    public String getWarrantyYear() {
        return this.warrantyYear;
    }

    public String getWarrantyMonth() {
        return this.warrantyMonth;
    }

    public double getPurchasePriceRaw() {
        return this.purchasePriceRaw;
    }

    public String getPurchasePrice() {
        return this.purchasePrice;
    }

    public Integer getLocation() {
        return this.location;
    }

    public void setLocation(Integer location) {
        this.location = location;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getManufacturerId() {
        return this.manufacturerId;
    }

    public void setManufacturerId(Integer manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public Integer getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(Integer vendorId) {
        this.vendorId = vendorId;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public int getResetLastServiceDate() {
        return this.resetLastServiceDate;
    }

    public void setResetLastServiceDate(int resetLastServiceDate) {
        this.resetLastServiceDate = resetLastServiceDate;
    }

    public int getCountSoftware() {
        return this.countSoftware;
    }

    public int getCountFile() {
        return this.countFile;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public void setHardwarePurchaseDate(Date hardwarePurchaseDate) {
        this.hardwarePurchaseDate = hardwarePurchaseDate;
    }

    public void setCountSoftware(int countSoftware) {
        this.countSoftware = countSoftware;
    }

    public void setCountFile(int countFile) {
        this.countFile = countFile;
    }

    public int getCountComponent() {
        return this.countComponent;
    }

    public void setCountComponent(int countComponent) {
        this.countComponent = countComponent;
    }

    public Date getWarrantyExpireDate() {
        return this.warrantyExpireDate;
    }

    public void setWarrantyExpireDate(Date warrantyExpireDate) {
        this.warrantyExpireDate = warrantyExpireDate;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }
}

