/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.issues;

import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.dao.CompanyDao;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dao.IssueDao;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.issues.dto.IssueFile;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.dto.linking.CompanyIssueLink;
import com.kwoksys.biz.system.dto.linking.HardwareIssueLink;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.biz.system.dto.linking.SoftwareIssueLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.mail.EmailMessage;
import com.kwoksys.framework.connections.mail.Pop3;
import com.kwoksys.framework.connections.mail.PopConnection;
import com.kwoksys.framework.connections.mail.SmtpService;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.parsers.email.IssueEmailParser;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IssueService {
    private static final Logger LOGGER = Logger.getLogger(IssueService.class.getName());
    private RequestContext requestContext;

    public IssueService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public Map<String, String> getGroupByRecentCreatedIssues(RequestContext requestContext, QueryCriteria query, int numDays) throws DatabaseException {
        double offsetHours = DatetimeUtils.getTimeOffsetHours(requestContext.getSysdate());
        Map<String, String> recentlyCreatedIssues = new IssueDao(requestContext).getGroupByRecentCreatedIssues(query, numDays, offsetHours);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Calendar cal = DatetimeUtils.newLocalCalendar(requestContext);
        cal.add(5, -numDays);
        for (int i = 0; i < numDays; ++i) {
            cal.add(5, 1);
            String dateString = DatetimeUtils.toShortDate(cal.getTime());
            resultMap.put(dateString, recentlyCreatedIssues.containsKey(dateString) ? recentlyCreatedIssues.get(dateString) : "0");
        }
        return resultMap;
    }

    public List<AttributeFieldCount> getGoupByStatusCount(QueryCriteria queryCriteria) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getGroupByStatusCount(queryCriteria);
    }

    public List<AttributeFieldCount> getGoupByPriorityCount(QueryCriteria queryCriteria) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getGroupByPriorityCount(queryCriteria);
    }

    public List<AttributeFieldCount> getGoupByTypeCount(QueryCriteria queryCriteria) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getGroupByTypeCount(queryCriteria);
    }

    public List<Map<String, String>> getGoupByAssigneeCount(QueryCriteria queryCriteria) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getGroupByAssigneeCount(queryCriteria);
    }

    public List<Issue> getIssues(QueryCriteria queryCriteria) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getIssues(queryCriteria, null);
    }

    public List<Issue> getLinkedIssues(QueryCriteria query, ObjectLink objectMap) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getLinkedIssueList(query, objectMap);
    }

    public Set<Integer> getIssueIds(QueryCriteria queryCriteria) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getIssueIds(queryCriteria);
    }

    public int getCount(QueryCriteria queryCriteria) throws DatabaseException {
        return new IssueDao(this.requestContext).getCount(queryCriteria);
    }

    public Issue getPublicIssue(Integer issueId) throws DatabaseException, ObjectNotFoundException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getIssue(issueId);
    }

    public Issue getIssue(Integer issueId) throws DatabaseException, ObjectNotFoundException, AccessDeniedException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        AccessUser accessUser = this.requestContext.getUser();
        if (!accessUser.hasPermission(1)) {
            IssueSearch issueSearch = new IssueSearch();
            issueSearch.put("issuePermittedUserId", accessUser.getId());
            issueSearch.put("issueIdEquals", issueId);
            int count = this.getCount(new QueryCriteria(issueSearch));
            if (count < 1) {
                throw new AccessDeniedException();
            }
        }
        return issueDao.getIssue(issueId);
    }

    public List<AccessUser> getAvailableSubscribers(Integer issueId) throws DatabaseException {
        UserSearch userSearch = new UserSearch();
        userSearch.put("userStatus", AttributeFieldIds.USER_STATUS_ENABLED);
        userSearch.put("issueAvailableSubscribers", issueId);
        QueryCriteria queryCriteria = new QueryCriteria(userSearch);
        queryCriteria.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        return adminService.getUsers(queryCriteria);
    }

    public List<AccessUser> getSelectedSubscribers(Integer issueId) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getSelectedSubscribers(issueId);
    }

    public List<Map<String, String>> getHistory(QueryCriteria queryCriteria, Integer issueId) throws DatabaseException {
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.getHistory(queryCriteria, issueId);
    }

    public List<Hardware> getIssueHardwareList(QueryCriteria queryCriteria, Integer issueId) throws DatabaseException {
        HardwareIssueLink map = new HardwareIssueLink();
        map.setIssueId(issueId);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        return hardwareService.getLinkedHardwareList(queryCriteria, map.createObjectMap());
    }

    public List<Software> getIssueSoftwareList(QueryCriteria queryCriteria, Integer issueId) throws DatabaseException {
        SoftwareIssueLink link = new SoftwareIssueLink();
        link.setIssueId(issueId);
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        return softwareService.getLinkedSoftwareList(queryCriteria, link.createObjectMap());
    }

    public List<Company> getIssueCompanyList(QueryCriteria queryCriteria, Integer issueId) throws DatabaseException {
        CompanyIssueLink map = new CompanyIssueLink();
        map.setIssueId(issueId);
        CompanyDao companyDao = new CompanyDao(this.requestContext);
        return companyDao.getLinkedCompanies(queryCriteria, map.createObjectMap());
    }

    public List<File> getIssueFiles(QueryCriteria query, Integer issueId) throws DatabaseException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        return fileService.getFiles(query, ObjectTypes.ISSUE, issueId);
    }

    public File getIssueFile(Integer issueId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        File file = fileService.getFile(ObjectTypes.ISSUE, issueId, fileId);
        file.setConfigRepositoryPath(ConfigManager.file.getIssueFileRepositoryLocation());
        file.setConfigUploadedFilePrefix(ConfigManager.file.getIssueUploadedFilePrefix());
        return file;
    }

    public ActionMessages addIssueSimple(Issue issue) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("issueName").setTitleKey("common.column.issue_name").setColumnName("issue.issue_name").calculateLength(issue.getSubject()).setNullable(false));
        validator.validate(new ColumnField().setName("description").setTitleKey("common.column.issue_description").setColumnName("issue.issue_description").calculateLength(issue.getDescription()).setNullable(false));
        if (!errors.isEmpty()) {
            return errors;
        }
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.addIssueSimple(issue);
    }

    public ActionMessages retrieveIssueEmails(PopConnection conn) throws Exception {
        ActionMessages errors = new ActionMessages();
        Pop3 pop3 = new Pop3();
        List<EmailMessage> emailMessages = pop3.receive(conn);
        errors.add(pop3.getErrors());
        conn.setMessagesRetrieved(emailMessages.size());
        for (EmailMessage emailMessage : emailMessages) {
            errors.add(this.retrieveIssueEmail(emailMessage));
        }
        return errors;
    }

    public ActionMessages retrieveIssueEmail(EmailMessage message) throws Exception {
        ActionMessages errors = new ActionMessages();
        Integer issueId = IssueEmailParser.parseEmailIssueId(message.getSubjectField());
        RequestContext requestContext = new RequestContext();
        AdminService adminService = ServiceProvider.getAdminService(requestContext);
        Integer userId = adminService.getUserIdByEmail(message.getFromField());
        if (userId != null) {
            requestContext.setUser(new AccessUser(userId));
        }
        if (issueId == null) {
            Issue issue = new Issue();
            issue.setSubject(message.getSubjectField().isEmpty() ? Localizer.getText(requestContext, "issues.email.emptySubject") : message.getSubjectField());
            issue.setDescription(message.getBodyField());
            issue.setFromEmail(message.getFromField());
            LinkedHashSet<String> subscriberEmails = new LinkedHashSet<String>();
            for (String ccAddress : message.getCcField()) {
                userId = adminService.getUserIdByEmail(ccAddress);
                if (userId == null) continue;
                issue.getSelectedSubscribers().add(userId);
                subscriberEmails.add(ccAddress);
            }
            IssueDao issueDao = new IssueDao(requestContext);
            errors = issueDao.addIssueSimple(issue);
            if (errors.isEmpty() && ConfigManager.email.isIssueNotificationFromEmailEnabled()) {
                if (ConfigManager.email.getSmtpFrom().equals(message.getFromField())) {
                    LOGGER.log(Level.INFO, "Skip sending of issue email notification. SMTP From Address same as message From Address.");
                } else {
                    this.sendSimpleIssueNotification(issue, subscriberEmails);
                }
            }
        } else {
            Issue issue = this.getPublicIssue(issueId);
            issue.setFollowup(message.getBodyField());
            issue.setFromEmail(message.getFromField());
            if (ConfigManager.email.isIssueNotificationFromEmailEnabled() && SmtpService.isMessageOriginatedFromApp(ConfigManager.email.getSmtpFrom(), message.getFromField())) {
                LOGGER.log(Level.INFO, LogConfigManager.EMAIL_PREFIX + " Skip updating Issue " + issue.getId() + " from email. SMTP From Address same as message's From Address.");
            } else {
                Integer prevAssigneeId = issue.getAssignee().getId();
                IssueDao issueDao = new IssueDao(requestContext);
                boolean updateSubscribers = false;
                issueDao.update(requestContext, issue, updateSubscribers);
                if (errors.isEmpty() && ConfigManager.email.isIssueNotificationFromEmailEnabled()) {
                    this.sendUpdateIssueNotification(issue, prevAssigneeId);
                }
            }
        }
        return errors;
    }

    public ActionMessages addIssue(Issue issue, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("issueName").setTitleKey("common.column.issue_name").setColumnName("issue.issue_name").calculateLength(issue.getSubject()).setNullable(false));
        if (issue.getDescription().isEmpty()) {
            errors.add("description", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.issue_description")));
        }
        if (issue.isHasDueDate() && !issue.isValidDueDate()) {
            errors.add("invalidDueDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.issue_due_date")));
        }
        validator.validateAttrs(issue, issue.getType(), customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.add(this.requestContext, issue);
    }

    public ActionMessages updateIssue(Issue issue, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("issueName").setTitleKey("common.column.issue_name").setColumnName("issue.issue_name").calculateLength(issue.getSubject()).setNullable(false));
        if (issue.getFollowup().isEmpty()) {
            errors.add("followup", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "issueMgmt.colName.comment")));
        }
        if (issue.isHasDueDate() && !issue.isValidDueDate()) {
            errors.add("invalidDueDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.issue_due_date")));
        }
        validator.validateAttrs(issue, issue.getType(), customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        IssueDao issueDao = new IssueDao(this.requestContext);
        boolean updateSubscribers = true;
        return issueDao.update(this.requestContext, issue, updateSubscribers);
    }

    public ActionMessages deleteIssue(Integer issueId) throws DatabaseException {
        List<File> deleteFileList = this.getIssueFiles(new QueryCriteria(), issueId);
        IssueDao issueDao = new IssueDao(this.requestContext);
        ActionMessages errors = issueDao.delete(issueId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (errors.isEmpty()) {
            fileService.bulkDelete(ConfigManager.file.getIssueFileRepositoryLocation(), deleteFileList);
        }
        return errors;
    }

    public ActionMessages addIssueFile(Issue issue, FileUploadForm actionForm) throws DatabaseException {
        IssueFile file;
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.addFile(file = new IssueFile(issue.getId()), actionForm);
        if (!errors.isEmpty()) {
            return errors;
        }
        issue.setFileId(file.getId());
        IssueDao issueDao = new IssueDao(this.requestContext);
        return issueDao.addIssueFile(issue);
    }

    public void sendSimpleIssueNotification(Issue issue, Set<String> subscriberEmails) throws Exception {
        final EmailMessage message = new EmailMessage();
        message.setFromField(ConfigManager.email.getSmtpFrom());
        message.getToField().add(ConfigManager.email.getSmtpTo());
        if (subscriberEmails != null && !subscriberEmails.isEmpty()) {
            for (String subscriberEmail : subscriberEmails) {
                message.getCcField().add(subscriberEmail);
            }
        }
        issue = this.getPublicIssue(issue.getId());
        message.setSubjectField(IssueUtils.formatEmailSubject(this.requestContext, issue));
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        String emailBody = ConfigManager.email.getIssueReportEmailTemplate().isEmpty() ? Localizer.getText(this.requestContext, "issuePlugin.issueAdd2.emailBody") : ConfigManager.email.getIssueReportEmailTemplate();
        emailBody = emailBody.replace("%ISSUE_ID%", String.valueOf(issue.getId())).replace("%ISSUE_REPORTED_BY%", AdminUtils.getSystemUsername(this.requestContext, issue.getCreator())).replace("%ISSUE_REPORTED_DATE%", issue.getCreationDate()).replace("%ISSUE_STATUS%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_STATUS, issue.getStatus())).replace("%ISSUE_PRIORITY%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_PRIORITY, issue.getPriority())).replace("%ISSUE_TYPE%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_TYPE, issue.getType())).replace("%ISSUE_DESCRIPTION%", issue.getDescription()).replace("%ISSUE_URL%", ConfigManager.system.getAppUrl() + AppPaths.ROOT + AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
        message.setBodyField(IssueUtils.formatEmailBody(this.requestContext, emailBody));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    new SmtpService().send(message);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Problem sending issue notification", e);
                }
            }
        };
        new Thread(run).start();
    }

    public void sendUpdateIssueNotification(Issue issue, Integer prevAssigneeId) {
        try {
            AttributeManager attributeManager = new AttributeManager(this.requestContext);
            Issue modifiedIssue = this.getPublicIssue(issue.getId());
            String emailBody = ConfigManager.email.getIssueUpdateEmailTemplate().isEmpty() ? Localizer.getText(this.requestContext, "issues.issueEdit2.emailBody") : ConfigManager.email.getIssueUpdateEmailTemplate();
            emailBody = emailBody.replace("%ISSUE_ASSIGNEE%", AdminUtils.getSystemUsername(this.requestContext, modifiedIssue.getAssignee())).replace("%ISSUE_ID%", String.valueOf(issue.getId())).replace("%ISSUE_REPORTED_BY%", AdminUtils.getSystemUsername(this.requestContext, issue.getCreator())).replace("%ISSUE_REPORTED_DATE%", issue.getCreationDate()).replace("%ISSUE_STATUS%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_STATUS, issue.getStatus())).replace("%ISSUE_PRIORITY%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_PRIORITY, issue.getPriority())).replace("%ISSUE_TYPE%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_TYPE, issue.getType())).replace("%ISSUE_DESCRIPTION%", issue.getDescription()).replace("%ISSUE_COMMENT%", issue.getFollowup()).replace("%ISSUE_COMMENTED_BY%", AdminUtils.getSystemUsername(this.requestContext, modifiedIssue.getModifier())).replace("%ISSUE_COMMENTED_DATE%", modifiedIssue.getModificationDate()).replace("%ISSUE_URL%", ConfigManager.system.getAppUrl() + AppPaths.ROOT + AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
            this.sendMail(modifiedIssue, prevAssigneeId, emailBody);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problem sending issue notification", e);
        }
    }

    public void sendMail(Issue issue, Integer prevAssigneeId, String bodyField) throws DatabaseException {
        List<AccessUser> selectedSubscribers;
        AccessUser creator;
        final EmailMessage message = new EmailMessage();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        message.setFromField(ConfigManager.email.getSmtpFrom());
        if (issue.hasAssignee()) {
            try {
                AccessUser assignee = new CacheManager(this.requestContext).getUserCache(issue.getAssignee().getId());
                if (!assignee.isRemoved()) {
                    message.getToField().add(assignee.getEmail());
                }
            }
            catch (Exception assignee) {
                // empty catch block
            }
        }
        if (prevAssigneeId != null) {
            try {
                AccessUser prevAssignee = adminService.getUser(prevAssigneeId);
                message.addCcField(prevAssignee.getEmail());
            }
            catch (Exception prevAssignee) {
                // empty catch block
            }
        }
        if (!(creator = issue.getCreator()).getId().equals(Access.GUEST_USER_ID)) {
            try {
                creator = adminService.getUser(creator.getId());
                message.getToField().add(creator.getEmail());
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        if (!(selectedSubscribers = this.getSelectedSubscribers(issue.getId())).isEmpty()) {
            for (AccessUser subscriber : selectedSubscribers) {
                message.addCcField(subscriber.getEmail());
            }
        }
        if (message.getToField().isEmpty() && !message.getCcField().isEmpty()) {
            message.getToField().addAll(message.getCcField());
            message.getCcField().clear();
        }
        message.setSubjectField(IssueUtils.formatEmailSubject(this.requestContext, issue));
        message.setBodyField(IssueUtils.formatEmailBody(this.requestContext, bodyField));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    new SmtpService().send(message);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Problem sending email", e);
                }
            }
        };
        new Thread(run).start();
    }
}

