/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.issues.core;

import com.kwoksys.action.issues.IssueSearchForm;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.List;

public class IssueSearch
extends BaseSearch {
    public static final String ISSUE_PERMITTED_USER_ID = "issuePermittedUserId";
    public static final String ISSUE_ID_EQUALS = "issueIdEquals";
    public static final String ISSUE_COMMENT_CONTAINS = "issueCommentContains";

    public IssueSearch(RequestContext requestContext, String sessionKey) {
        super(requestContext, sessionKey);
    }

    public IssueSearch() {
    }

    public void prepareMap(IssueSearchForm issueSearchForm) {
        String cmd = this.requestContext.getParameterString("cmd");
        AccessUser accessUser = this.requestContext.getUser();
        if (!cmd.isEmpty()) {
            this.reset();
            issueSearchForm.setCmd(cmd);
            if (cmd.equals("showNonClosed")) {
                this.searchCriteriaMap.put("statusNotEquals", "closed");
            } else if (cmd.equals("showOpenUnassigned")) {
                this.searchCriteriaMap.put("unassigned", "");
                this.searchCriteriaMap.put("statusNotEquals", "closed");
            } else if (cmd.equals("showMyIssues")) {
                this.searchCriteriaMap.put("assignedToId", accessUser.getId());
                this.searchCriteriaMap.put("statusNotEquals", "closed");
            } else if (cmd.equals("showMyReportedIssues")) {
                this.searchCriteriaMap.put("reportedById", accessUser.getId());
                this.searchCriteriaMap.put("statusNotEquals", "closed");
            } else {
                issueSearchForm.setRequest(this.requestContext);
                if (cmd.equals("search")) {
                    String dueIn;
                    String submissionDate;
                    List<Integer> resolutionList;
                    List<Integer> typeList;
                    List<Integer> priorityList;
                    List<Integer> statusList;
                    String statusNotEquals;
                    if (!issueSearchForm.getIssueId().isEmpty()) {
                        this.searchCriteriaMap.put(ISSUE_ID_EQUALS, issueSearchForm.getIssueId());
                    }
                    if (!issueSearchForm.getSubject().isEmpty()) {
                        this.searchCriteriaMap.put("subjectContains", issueSearchForm.getSubject());
                    }
                    if (!issueSearchForm.getDescription().isEmpty()) {
                        this.searchCriteriaMap.put("descriptionContains", issueSearchForm.getDescription());
                    }
                    if (!issueSearchForm.getComment().isEmpty()) {
                        this.searchCriteriaMap.put(ISSUE_COMMENT_CONTAINS, issueSearchForm.getComment());
                    }
                    if (!issueSearchForm.getUrl().isEmpty()) {
                        this.searchCriteriaMap.put("urlContains", issueSearchForm.getUrl());
                    }
                    if (!(statusNotEquals = this.requestContext.getParameterString("statusNotEquals")).isEmpty()) {
                        this.searchCriteriaMap.put("statusNotEquals", statusNotEquals);
                    }
                    if (!(statusList = issueSearchForm.getStatus()).isEmpty()) {
                        this.searchCriteriaMap.put("statusContains", statusList);
                    }
                    if (!(priorityList = issueSearchForm.getPriority()).isEmpty()) {
                        this.searchCriteriaMap.put("priorityContains", priorityList);
                    }
                    if (!(typeList = issueSearchForm.getType()).isEmpty()) {
                        this.searchCriteriaMap.put("typeContains", typeList);
                    }
                    if (!(resolutionList = issueSearchForm.getResolution()).isEmpty()) {
                        this.searchCriteriaMap.put("resolutionContains", resolutionList);
                    }
                    if (!issueSearchForm.getAssignedTo().isEmpty()) {
                        this.searchCriteriaMap.put("assignedToId", issueSearchForm.getAssignedTo());
                    }
                    if (!issueSearchForm.getSubmitter().isEmpty()) {
                        this.searchCriteriaMap.put("reportedById", issueSearchForm.getSubmitter());
                    }
                    if (!(submissionDate = issueSearchForm.getSubmissionDate()).isEmpty()) {
                        if (submissionDate.equals("last1days")) {
                            this.searchCriteriaMap.put("submittedWithinLast", 1);
                        } else if (submissionDate.equals("last7days")) {
                            this.searchCriteriaMap.put("submittedWithinLast", 7);
                        } else if (submissionDate.equals("last14days")) {
                            this.searchCriteriaMap.put("submittedWithinLast", 14);
                        } else if (submissionDate.equals("last30days")) {
                            this.searchCriteriaMap.put("submittedWithinLast", 30);
                        }
                    }
                    String submittedAfterDate = issueSearchForm.getSubmittedAfterDate();
                    String submittedAfterMonth = issueSearchForm.getSubmittedAfterMonth();
                    String submittedAfterYear = issueSearchForm.getSubmittedAfterYear();
                    if (DatetimeUtils.isValidDate(submittedAfterYear, submittedAfterMonth, submittedAfterDate)) {
                        this.searchCriteriaMap.put("submittedAfter", submittedAfterYear + "-" + submittedAfterMonth + "-" + submittedAfterDate);
                    }
                    String submittedBeforeDate = issueSearchForm.getSubmittedBeforeDate();
                    String submittedBeforeMonth = issueSearchForm.getSubmittedBeforeMonth();
                    String submittedBeforeYear = issueSearchForm.getSubmittedBeforeYear();
                    if (DatetimeUtils.isValidDate(submittedBeforeYear, submittedBeforeMonth, submittedBeforeDate)) {
                        this.searchCriteriaMap.put("submittedBefore", submittedBeforeYear + "-" + submittedBeforeMonth + "-" + submittedBeforeDate);
                    }
                    if (!(dueIn = issueSearchForm.getDueWithin()).isEmpty()) {
                        if (dueIn.equals("1day")) {
                            this.searchCriteriaMap.put("dueIn", 1);
                        } else if (dueIn.equals("7days")) {
                            this.searchCriteriaMap.put("dueIn", 7);
                        } else if (dueIn.equals("30days")) {
                            this.searchCriteriaMap.put("dueIn", 30);
                        }
                    }
                    if (!issueSearchForm.getAttrId().isEmpty() && !issueSearchForm.getAttrValue().isEmpty()) {
                        this.searchCriteriaMap.put("attrId", issueSearchForm.getAttrId());
                        this.searchCriteriaMap.put("attrValue", issueSearchForm.getAttrValue());
                    }
                }
            }
        }
    }

    @Override
    public void applyMap(QueryCriteria queryCriteria) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey(ISSUE_PERMITTED_USER_ID)) {
            Integer userId = (Integer)this.searchCriteriaMap.get(ISSUE_PERMITTED_USER_ID);
            queryCriteria.appendWhereClause("(i.assignee_id=" + userId + " or i.creator=" + userId + " or i.issue_id in (select issue_id from issue_subscription where user_id=" + userId + "))");
        }
        if (this.searchCriteriaMap.containsKey(ISSUE_ID_EQUALS)) {
            queryCriteria.appendWhereClause("i.issue_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(ISSUE_ID_EQUALS)));
        }
        if (this.searchCriteriaMap.containsKey("subjectContains")) {
            queryCriteria.appendWhereClause("lower(i.issue_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("subjectContains")) + "%')");
        } else if (this.searchCriteriaMap.containsKey("subjectEquals")) {
            queryCriteria.appendWhereClause("lower(i.issue_name) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get("subjectEquals")) + "')");
        }
        if (this.searchCriteriaMap.containsKey("descriptionContains")) {
            queryCriteria.appendWhereClause("lower(i.issue_description) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("descriptionContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("urlContains")) {
            queryCriteria.appendWhereClause("lower(i.issue_url) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("urlContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("statusNotEquals")) {
            queryCriteria.appendWhereClause("i.issue_status not in (select attribute_field_id from attribute_field where field_key='" + SqlUtils.encodeString(this.searchCriteriaMap.get("statusNotEquals")) + "')");
        }
        if (this.searchCriteriaMap.containsKey("statusContains")) {
            queryCriteria.appendWhereClause("i.issue_status in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get("statusContains")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("priorityContains")) {
            queryCriteria.appendWhereClause("i.issue_priority in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get("priorityContains")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("typeContains")) {
            queryCriteria.appendWhereClause("i.issue_type in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get("typeContains")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("resolutionContains")) {
            queryCriteria.appendWhereClause("i.issue_resolution in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get("resolutionContains")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("assignedToId")) {
            queryCriteria.appendWhereClause("i.assignee_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("assignedToId")));
        }
        if (this.searchCriteriaMap.containsKey("unassigned")) {
            queryCriteria.appendWhereClause("i.assignee_id is null");
        }
        if (this.searchCriteriaMap.containsKey("reportedById")) {
            queryCriteria.appendWhereClause("i.creator = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("reportedById")));
        }
        if (this.searchCriteriaMap.containsKey("submittedWithinLast")) {
            queryCriteria.appendWhereClause("i.creation_date > now()::timestamp + '-" + SqlUtils.encodeInteger(this.searchCriteriaMap.get("submittedWithinLast")) + " day'::interval");
        }
        if (this.searchCriteriaMap.containsKey("submittedAfter")) {
            queryCriteria.appendWhereClause("i.creation_date > '" + SqlUtils.encodeString(this.searchCriteriaMap.get("submittedAfter")) + "'");
        }
        if (this.searchCriteriaMap.containsKey("submittedBefore")) {
            queryCriteria.appendWhereClause("i.creation_date < '" + SqlUtils.encodeString(this.searchCriteriaMap.get("submittedBefore")) + "'");
        }
        if (this.searchCriteriaMap.containsKey("dueIn")) {
            queryCriteria.appendWhereClause("i.issue_due_date < now()::timestamp + '" + SqlUtils.encodeInteger(this.searchCriteriaMap.get("dueIn")) + " day'::interval");
        }
        if (this.searchCriteriaMap.containsKey("attrId") && this.searchCriteriaMap.containsKey("attrValue")) {
            queryCriteria.appendWhereClause("i.issue_id in (select object_id from object_attribute_value where attribute_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("attrId")) + " and lower(attr_value) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("attrValue")) + "%'))");
        }
        if (this.searchCriteriaMap.containsKey(ISSUE_COMMENT_CONTAINS)) {
            queryCriteria.appendWhereClause("i.issue_id in (select issue_id from issue_comment where lower(issue_comment_description) like lower('%" + this.searchCriteriaMap.get(ISSUE_COMMENT_CONTAINS) + "%'))");
        }
    }
}

