/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.issues.core;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.IssueAccess;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class IssueUtils {
    public static final String ISSUE_TAB_HISTORY = "history";
    public static final String ISSUE_TAB_RELATIONSHIP = "rel";

    public static String[] getIssuesDefaultColumns() {
        return new String[]{"rownum", "issue_id", "issue_name", "issue_type", "issue_status", "issue_priority", "assignee_name", "creator_name", "creation_date", "modification_date", "issue_due_date"};
    }

    public static List<String> getIssueColumnHeaders() {
        return ConfigManager.app.getIssuesColumns();
    }

    public static List<String> getSortableColumns() {
        return Arrays.asList("issue_id", "assignee_name", "issue_name", "issue_status", "issue_priority", "creator_name", "creation_date", "modification_date", "issue_due_date");
    }

    public static boolean isSortableColumn(String columnName) {
        return IssueUtils.getSortableColumns().contains(columnName);
    }

    public static List<DataRow> formatIssues(RequestContext requestContext, List<Issue> issueList, IssueAccess access, Counter counter) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        boolean hasUserDetailAccess = Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL);
        boolean hasIssueDetailAccess = Access.hasPermission(user, AppPaths.ISSUES_DETAIL);
        for (Issue issue : issueList) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : IssueUtils.getIssueColumnHeaders()) {
                if (column.equals("rownum")) {
                    columns.add(counter.incr() + ".");
                    continue;
                }
                if (column.equals("issue_id")) {
                    columns.add(String.valueOf(issue.getId()));
                    continue;
                }
                if (column.equals("issue_name")) {
                    Link issueLink = new Link(requestContext);
                    issueLink.setTitle(issue.getSubject());
                    if (hasIssueDetailAccess && access.hasPermission(issue.getId())) {
                        issueLink.setAjaxPath(AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
                    }
                    columns.add(issueLink.getString());
                    continue;
                }
                if (column.equals("assignee_name")) {
                    String assigneeName = IssueUtils.getAssigneeIconLink(requestContext, hasUserDetailAccess, issue.getAssignee());
                    columns.add(assigneeName);
                    continue;
                }
                if (column.equals("creator_name")) {
                    columns.add(Links.getUserIconLink(requestContext, issue.getCreator(), hasUserDetailAccess, true).getString());
                    continue;
                }
                if (column.equals("creation_date")) {
                    columns.add(issue.getCreationDate());
                    continue;
                }
                if (column.equals("modifier_name")) {
                    columns.add(Links.getUserIconLink(requestContext, issue.getModifier(), hasUserDetailAccess, true).getString());
                    continue;
                }
                if (column.equals("modification_date")) {
                    columns.add(issue.getModificationDate());
                    continue;
                }
                if (column.equals("issue_due_date")) {
                    columns.add(issue.getDueDateShort());
                    continue;
                }
                if (column.equals("issue_status")) {
                    columns.add(HtmlUtils.encode(issue.getStatusName()));
                    continue;
                }
                if (column.equals("issue_type")) {
                    columns.add(HtmlUtils.encode(issue.getTypeName()));
                    continue;
                }
                if (!column.equals("issue_priority")) continue;
                columns.add(HtmlUtils.encode(issue.getPriorityName()));
            }
            DataRow dataRow = new DataRow();
            dataRow.setRowId(String.valueOf(issue.getId()));
            dataRow.setColumns(columns);
            list.add(dataRow);
        }
        return list;
    }

    public static List<Link> getIssueTabs(RequestContext requestContext, Issue issue, Integer relationshipCount) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        ArrayList<Link> links = new ArrayList<Link>();
        if (Access.hasPermission(user, AppPaths.ISSUES_DETAIL)) {
            links.add(new Link(requestContext).setName(ISSUE_TAB_HISTORY).setAjaxPath(AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId()).setTitleKey("issues.tab.history"));
        }
        if (relationshipCount == null) {
            SystemService systemService = ServiceProvider.getSystemService(requestContext);
            List<Integer> types = Arrays.asList(ObjectTypes.COMPANY, ObjectTypes.HARDWARE, ObjectTypes.SOFTWARE);
            List<Integer> linkedTypes = Arrays.asList(ObjectTypes.ISSUE);
            relationshipCount = systemService.getObjectMapCount(types, issue.getId(), linkedTypes);
        }
        if (Access.hasPermission(user, AppPaths.ISSUES_RELATIONSHIP)) {
            links.add(new Link(requestContext).setName(ISSUE_TAB_RELATIONSHIP).setAppPath(AppPaths.ISSUES_RELATIONSHIP + "?issueId=" + issue.getId()).setTitle(Localizer.getText(requestContext, "common.tab.relationships", (Object[])new Integer[]{relationshipCount})));
        }
        return links;
    }

    public static String formatAssigneeName(RequestContext requestContext, AccessUser assignee) {
        if (assignee == null || assignee.getId() == 0) {
            return Localizer.getText(requestContext, "issueMgmt.colName.unassigned");
        }
        return AdminUtils.getSystemUsername(requestContext, assignee);
    }

    public static String getAssigneeIconLink(RequestContext requestContext, boolean hasPermission, AccessUser assignee) {
        if (assignee != null && assignee.getId() != 0) {
            return Links.getUserIconLink(requestContext, assignee, hasPermission, true).getString();
        }
        return IssueUtils.formatAssigneeName(requestContext, assignee);
    }

    public static String formatEmailSubject(RequestContext requestContext, Issue issue) {
        return Localizer.getText(requestContext, "issues.issueAdd.emailSubject", (Object[])new String[]{String.valueOf(issue.getId()), issue.getSubject()});
    }

    public static String formatEmailBody(RequestContext requestContext, String bodyField) {
        return "----------------------------------------\n" + Localizer.getText(requestContext, "issues.email.bodySeparatorMessage") + "\n\n" + bodyField;
    }

    public static boolean isHtmlEmail(String content) {
        return ((content = content.toLowerCase()).startsWith("<html") || content.startsWith("<!doctype html")) && content.endsWith("</html>");
    }

    public static void setDefaultDueDate(RequestContext requestContext, Issue issue) {
        int diff = ConfigManager.app.getIssueDueDateDiff();
        if (diff != 0) {
            Calendar cal = DatetimeUtils.newLocalCalendar(requestContext);
            cal.add(5, diff);
            issue.setDueDate(cal.getTime());
            issue.setHasDueDate(true);
        }
    }
}

