/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.issues.dao;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dao.AttributeDao;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.issues.dao.IssueQueries;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IssueDao
extends BaseDao {
    private static final Logger LOGGER = Logger.getLogger(IssueDao.class.getName());

    public IssueDao(RequestContext requestContext) {
        super(requestContext);
    }

    public Map<String, String> getGroupByRecentCreatedIssues(QueryCriteria query, int numDays, double offsetHours) throws DatabaseException {
        final HashMap<String, String> map = new HashMap<String, String>();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectGroupByRecentCreatedIssues(query, numDays, offsetHours)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                map.put(DatetimeUtils.toShortDate(DatetimeUtils.getDate(rs, "created_date")), rs.getString("issue_count"));
            }
        };
        this.executeQuery(queryHelper);
        return map;
    }

    public List<AttributeFieldCount> getGroupByStatusCount(QueryCriteria query) throws DatabaseException {
        final ArrayList<AttributeFieldCount> counts = new ArrayList<AttributeFieldCount>();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueCountGoupByStatusQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeFieldCount count = new AttributeFieldCount();
                count.setAttrFieldId(rs.getInt("attribute_field_id"));
                count.setObjectCount(rs.getInt("status_count"));
                counts.add(count);
            }
        };
        this.executeQuery(queryHelper);
        return counts;
    }

    public List<AttributeFieldCount> getGroupByPriorityCount(QueryCriteria queryCriteria) throws DatabaseException {
        final ArrayList<AttributeFieldCount> counts = new ArrayList<AttributeFieldCount>();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueCountByPriorityQuery(queryCriteria)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeFieldCount count = new AttributeFieldCount();
                count.setAttrFieldId(rs.getInt("attribute_field_id"));
                count.setObjectCount(rs.getInt("priority_count"));
                counts.add(count);
            }
        };
        this.executeQuery(queryHelper);
        return counts;
    }

    public List<AttributeFieldCount> getGroupByTypeCount(QueryCriteria query) throws DatabaseException {
        final ArrayList<AttributeFieldCount> counts = new ArrayList<AttributeFieldCount>();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueCountByTypeQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeFieldCount count = new AttributeFieldCount();
                count.setAttrFieldId(rs.getInt("attribute_field_id"));
                count.setObjectCount(rs.getInt("type_count"));
                counts.add(count);
            }
        };
        this.executeQuery(queryHelper);
        return counts;
    }

    public List<Map<String, String>> getGroupByAssigneeCount(QueryCriteria query) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueCountGoupByAssigneeQuery(query));
        return this.executeQueryReturnList(queryHelper);
    }

    public List<Issue> getIssues(QueryCriteria queryCriteria, ObjectLink objectMap) throws DatabaseException {
        final ArrayList<Issue> issues = new ArrayList<Issue>();
        QueryHelper queryHelper = new QueryHelper(){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Issue issue = new Issue();
                issue.setId(rs.getInt("issue_id"));
                issue.setSubject(StringUtils.replaceNull(rs.getString("issue_name")));
                issue.setDescription(StringUtils.replaceNull(rs.getString("issue_description")));
                issue.setTypeName(StringUtils.replaceNull(rs.getString("issue_type_name")));
                issue.setStatusName(StringUtils.replaceNull(rs.getString("issue_status_name")));
                issue.setPriorityName(StringUtils.replaceNull(rs.getString("issue_priority_name")));
                issue.setUrl(StringUtils.replaceNull(rs.getString("issue_url")));
                issue.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                issue.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                issue.setDueDate(DatetimeUtils.getDate(rs, "issue_due_date"));
                issue.setAssignee(new AccessUser());
                issue.getAssignee().setId(rs.getInt("assignee_id"));
                issue.getAssignee().setUsername(rs.getString("assignee_username"));
                issue.getAssignee().setDisplayName(rs.getString("assignee_display_name"));
                issue.setCreator(new AccessUser());
                issue.getCreator().setId(rs.getInt("creator"));
                issue.getCreator().setUsername(rs.getString("creator_username"));
                issue.getCreator().setDisplayName(rs.getString("creator_display_name"));
                issue.setModifier(new AccessUser());
                issue.getModifier().setId(rs.getInt("modifier"));
                issue.getModifier().setUsername(rs.getString("modifier_username"));
                issue.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                issues.add(issue);
            }
        };
        if (objectMap != null) {
            queryHelper.setSqlStatement(IssueQueries.selectLinkedIssuesQuery(queryCriteria));
            queryHelper.addInputInt(objectMap.getObjectId());
            queryHelper.addInputInt(objectMap.getObjectTypeId());
            queryHelper.addInputInt(objectMap.getLinkedObjectTypeId());
        } else {
            queryHelper.setSqlStatement(IssueQueries.selectIssueListQuery(queryCriteria));
        }
        this.executeQuery(queryHelper);
        return issues;
    }

    public List<Issue> getLinkedIssueList(QueryCriteria query, ObjectLink objectMap) throws DatabaseException {
        return this.getIssues(query, objectMap);
    }

    public int getCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(IssueQueries.selectIssueCountQuery(query));
    }

    public Set<Integer> getIssueIds(QueryCriteria query) throws DatabaseException {
        final HashSet<Integer> set = new HashSet<Integer>();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueIdsQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                set.add(rs.getInt("issue_id"));
            }
        };
        this.executeSingleRecordQuery(queryHelper);
        return set;
    }

    public Issue getIssue(Integer issueId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList issues = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Issue issue = new Issue();
                issue.setId(rs.getInt("issue_id"));
                issue.setSubject(StringUtils.replaceNull(rs.getString("issue_name")));
                issue.setDescription(StringUtils.replaceNull(rs.getString("issue_description")));
                issue.setStatus(rs.getInt("issue_status"));
                issue.setType(rs.getInt("issue_type"));
                issue.setPriority(rs.getInt("issue_priority"));
                issue.setResolution(rs.getInt("issue_resolution"));
                issue.setUrl(StringUtils.replaceNull(rs.getString("issue_url")));
                issue.setDueDate(DatetimeUtils.getDate(rs, "issue_due_date"));
                issue.setHasDueDate(issue.getDueDate() != null);
                issue.setFromEmail(StringUtils.replaceNull(rs.getString("issue_created_from_email")));
                issue.setCreatorIP(StringUtils.replaceNull(rs.getString("creator_ip")));
                issue.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                issue.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                issue.setAssignee(new AccessUser());
                issue.getAssignee().setId(rs.getInt("assignee_id"));
                issue.getAssignee().setUsername(rs.getString("assignee_username"));
                issue.getAssignee().setDisplayName(rs.getString("assignee_display_name"));
                issue.setCreator(new AccessUser());
                issue.getCreator().setId(rs.getInt("creator"));
                issue.getCreator().setUsername(rs.getString("creator_username"));
                issue.getCreator().setDisplayName(rs.getString("creator_display_name"));
                issue.setModifier(new AccessUser());
                issue.getModifier().setId(rs.getInt("modifier"));
                issue.getModifier().setUsername(rs.getString("modifier_username"));
                issue.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                issues.add(issue);
            }
        };
        queryHelper.addInputInt(issueId);
        this.executeSingleRecordQuery(queryHelper);
        if (!issues.isEmpty()) {
            return (Issue)issues.get(0);
        }
        throw new ObjectNotFoundException("Issue ID: " + issueId);
    }

    public List<Map<String, String>> getHistory(QueryCriteria query, Integer issueId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(IssueQueries.selectIssueHistoryQuery(query));
        queryHelper.addInputInt(ObjectTypes.ISSUE);
        queryHelper.addInputInt(issueId);
        queryHelper.addInputInt(issueId);
        queryHelper.addInputInt(issueId);
        return this.executeQueryReturnList(queryHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages addIssueSimple(Issue issue) throws DatabaseException {
        LOGGER.log(Level.INFO, "Add new issue from Report Issue/Email");
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.insertIssueQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(issue.getSubject());
        queryHelper.addInputStringConvertNull(issue.getDescription());
        queryHelper.addInputStringConvertNull(issue.getUrl());
        queryHelper.addInputIntegerConvertNull(issue.getType());
        queryHelper.addInputIntegerConvertNull(issue.getStatus());
        queryHelper.addInputIntegerConvertNull(issue.getPriority());
        queryHelper.addInputIntegerConvertNull(issue.getResolution());
        queryHelper.addInputIntegerConvertNull(issue.getAssignee().getId());
        queryHelper.addInputStringConvertNull(issue.isHasDueDate() ? DatetimeUtils.createDatetimeString(issue.getDueDateYear(), issue.getDueDateMonth(), issue.getDueDateDate()) : null);
        queryHelper.addInputStringConvertNull(issue.getCreatorIP());
        queryHelper.addInputStringConvertNull(issue.getFromEmail());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        queryHelper.addInputIntegerConvertNull(null);
        try {
            queryHelper.executeProcedure(conn);
            issue.setId((Integer)queryHelper.getSqlOutputs().get(0));
            if (!issue.getSelectedSubscribers().isEmpty()) {
                this.updateSubscribers(this.requestContext, conn, issue);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        if (this.errors.isEmpty()) {
            issue.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages add(RequestContext requestContext, Issue issue) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.insertIssueQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(issue.getSubject());
        queryHelper.addInputStringConvertNull(issue.getDescription());
        queryHelper.addInputStringConvertNull(issue.getUrl());
        queryHelper.addInputIntegerConvertNull(issue.getType());
        queryHelper.addInputIntegerConvertNull(issue.getStatus());
        queryHelper.addInputIntegerConvertNull(issue.getPriority());
        queryHelper.addInputIntegerConvertNull(issue.getResolution());
        queryHelper.addInputIntegerConvertNull(issue.getAssignee().getId());
        queryHelper.addInputStringConvertNull(issue.isHasDueDate() ? DatetimeUtils.createDatetimeString(issue.getDueDateYear(), issue.getDueDateMonth(), issue.getDueDateDate()) : null);
        queryHelper.addInputStringConvertNull(issue.getCreatorIP());
        queryHelper.addInputStringConvertNull(issue.getFromEmail());
        Integer creator = requestContext.getUser().getId();
        Integer proxyCreator = null;
        if (issue.getProxyUserId() != null && issue.getProxyUserId() != 0) {
            creator = issue.getProxyUserId();
            proxyCreator = requestContext.getUser().getId();
        }
        queryHelper.addInputInt(creator);
        queryHelper.addInputIntegerConvertNull(proxyCreator);
        try {
            queryHelper.executeProcedure(conn);
            issue.setId((Integer)queryHelper.getSqlOutputs().get(0));
            this.addSubscribers(requestContext, conn, issue);
            if (!issue.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(requestContext);
                attributeDao.updateAttributeValue(conn, issue.getId(), issue.getCustomValues());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages update(RequestContext requestContext, Issue issue, boolean updateSubscribers) throws DatabaseException {
        LOGGER.log(Level.INFO, "Update issue ID " + issue.getId() + " from Report Issue/Email");
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(IssueQueries.updateIssueQuery());
        queryHelper.addInputInt(issue.getId());
        queryHelper.addInputStringConvertNull(issue.getSubject());
        queryHelper.addInputStringConvertNull(issue.getFollowup());
        queryHelper.addInputIntegerConvertNull(issue.getType());
        queryHelper.addInputIntegerConvertNull(issue.getStatus());
        queryHelper.addInputIntegerConvertNull(issue.getPriority());
        queryHelper.addInputIntegerConvertNull(issue.getResolution());
        queryHelper.addInputIntegerConvertNull(issue.getAssignee().getId());
        queryHelper.addInputStringConvertNull(issue.isHasDueDate() ? DatetimeUtils.createDatetimeString(issue.getDueDateYear(), issue.getDueDateMonth(), issue.getDueDateDate()) : null);
        queryHelper.addInputStringConvertNull(issue.getFromEmail());
        queryHelper.addInputInt(requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            if (updateSubscribers) {
                this.updateSubscribers(requestContext, conn, issue);
            }
            if (issue.getCustomValues() != null && !issue.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(requestContext);
                attributeDao.updateAttributeValue(conn, issue.getId(), issue.getCustomValues());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages delete(Integer issueId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(IssueQueries.deleteIssueQuery());
        queryHelper.addInputInt(ObjectTypes.ISSUE);
        queryHelper.addInputInt(issueId);
        return this.executeProcedure(queryHelper);
    }

    public List<AccessUser> getSelectedSubscribers(Integer issueId) throws DatabaseException {
        UserSearch userSearch = new UserSearch();
        userSearch.put("issueSelectedSubscribers", issueId);
        QueryCriteria query = new QueryCriteria(userSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        return adminService.getUsers(query);
    }

    private void updateSubscribers(RequestContext requestContext, Connection conn, Issue issue) throws DatabaseException {
        ArrayList<Integer> selectedSubscribers = new ArrayList<Integer>();
        selectedSubscribers.addAll(issue.getSelectedSubscribers());
        for (AccessUser user : this.getSelectedSubscribers(issue.getId())) {
            if (selectedSubscribers.contains(user.getId())) {
                selectedSubscribers.remove(user.getId());
                continue;
            }
            this.deleteSubscriber(conn, issue, user.getId());
        }
        for (Integer userId : selectedSubscribers) {
            this.addSubscriber(requestContext, conn, issue, userId);
        }
    }

    private void addSubscribers(RequestContext requestContext, Connection conn, Issue issue) throws DatabaseException {
        for (Integer subscriberUserId : issue.getSelectedSubscribers()) {
            this.addSubscriber(requestContext, conn, issue, subscriberUserId);
        }
    }

    private void addSubscriber(RequestContext requestContext, Connection conn, Issue issue, Integer subscriberUserId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(IssueQueries.addSubscriberQuery());
        queryHelper.addInputInt(issue.getId());
        queryHelper.addInputInt(subscriberUserId);
        queryHelper.addInputInt(requestContext.getUser().getId());
        queryHelper.executeProcedure(conn);
    }

    private void deleteSubscriber(Connection conn, Issue issue, Integer subscriberUserId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(IssueQueries.deleteSubscriberQuery());
        queryHelper.addInputInt(issue.getId());
        queryHelper.addInputInt(subscriberUserId);
        queryHelper.executeProcedure(conn);
    }

    public ActionMessages addIssueFile(Issue issue) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(IssueQueries.insertIssueFileQuery());
        queryHelper.addInputInt(issue.getId());
        queryHelper.addInputIntegerConvertNull(issue.getFileId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }
}

