/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.issues.dto;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Issue
extends BaseObject {
    public static final String ID = "issue_id";
    public static final String TITLE = "issue_name";
    public static final String DESCRIPTION = "issue_description";
    public static final String TYPE = "issue_type";
    public static final String STATUS = "issue_status";
    public static final String PRIORITY = "issue_priority";
    public static final String ASSIGNEE = "issue_assignee";
    public static final String ASSIGNEE_NAME = "assignee_name";
    public static final String HISTORY_CREATION_DATE = "creation_date";
    public static final String DUE_DATE = "issue_due_date";
    private Integer id;
    private String subject;
    private String description;
    private Integer status;
    private String statusName;
    private Integer type;
    private String typeName;
    private Integer priority;
    private String priorityName;
    private Integer resolution;
    private String resolutionName;
    private String url;
    private String followup;
    private AccessUser assignee = new AccessUser();
    private boolean hasDueDate = false;
    private Date dueDate;
    private String dueDateDate = "";
    private String dueDateMonth = "";
    private String dueDateYear = "";
    private String fromEmail;
    private String creatorIP;
    private Integer fileId;
    private List<Integer> selectedSubscribers = new ArrayList<Integer>();
    private Integer proxyUserId;

    public Issue() throws DatabaseException {
        super(ObjectTypes.ISSUE);
        this.status = new CacheManager().getSystemAttrCache(Attributes.ISSUE_STATUS).getDefaultAttrFieldId();
        this.type = new CacheManager().getSystemAttrCache(Attributes.ISSUE_TYPE).getDefaultAttrFieldId();
        this.priority = new CacheManager().getSystemAttrCache(Attributes.ISSUE_PRIORITY).getDefaultAttrFieldId();
        this.resolution = new CacheManager().getSystemAttrCache(Attributes.ISSUE_RESOLUTION).getDefaultAttrFieldId();
    }

    @Override
    public boolean isAttrEmpty(String attrName) {
        if (attrName.equals(ASSIGNEE)) {
            return !this.hasAssignee();
        }
        return false;
    }

    public void setDueDate(String year, String month, String date) {
        this.dueDateYear = year;
        this.dueDateMonth = month;
        this.dueDateDate = date;
    }

    public boolean hasAssignee() {
        return this.assignee != null && this.assignee.getId() != 0;
    }

    public boolean isValidDueDate() {
        return DatetimeUtils.isValidDate(this.dueDateYear, this.dueDateMonth, this.dueDateDate);
    }

    public static List<String> getSortableHistoryColumns() {
        return Arrays.asList(HISTORY_CREATION_DATE);
    }

    public static boolean isSortableHistoryColumn(String columnName) {
        return Issue.getSortableHistoryColumns().contains(columnName);
    }

    private static List<String> getIssueRequiredFields() {
        return Arrays.asList(TITLE, DESCRIPTION);
    }

    public static boolean isIssueRequiredField(String columnName) {
        return Issue.getIssueRequiredFields().contains(columnName);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getResolution() {
        return this.resolution;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFollowup() {
        return this.followup;
    }

    public void setFollowup(String followup) {
        this.followup = followup;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCreatorIP() {
        return this.creatorIP;
    }

    public void setCreatorIP(String creatorIP) {
        this.creatorIP = creatorIP;
    }

    public void setFileId(Integer fileId) {
        this.fileId = fileId;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public List<Integer> getSelectedSubscribers() {
        return this.selectedSubscribers;
    }

    public boolean isHasDueDate() {
        return this.hasDueDate;
    }

    public void setHasDueDate(boolean hasDueDate) {
        this.hasDueDate = hasDueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getDueDateShort() {
        return DatetimeUtils.toShortDate(this.dueDate);
    }

    public String getDueDateDate() {
        return this.dueDateDate;
    }

    public String getDueDateMonth() {
        return this.dueDateMonth;
    }

    public String getDueDateYear() {
        return this.dueDateYear;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public String getPriorityName() {
        return this.priorityName;
    }

    public void setPriorityName(String priorityName) {
        this.priorityName = priorityName;
    }

    public String getResolutionName() {
        return this.resolutionName;
    }

    public void setResolutionName(String resolutionName) {
        this.resolutionName = resolutionName;
    }

    public void setDueDateDate(String dueDateDate) {
        this.dueDateDate = dueDateDate;
    }

    public void setDueDateMonth(String dueDateMonth) {
        this.dueDateMonth = dueDateMonth;
    }

    public void setDueDateYear(String dueDateYear) {
        this.dueDateYear = dueDateYear;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public AccessUser getAssignee() {
        return this.assignee;
    }

    public void setAssignee(AccessUser assignee) {
        this.assignee = assignee;
    }

    public Integer getProxyUserId() {
        return this.proxyUserId;
    }

    public void setProxyUserId(Integer proxyUserId) {
        this.proxyUserId = proxyUserId;
    }
}

