/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.kb;

import com.kwoksys.action.kb.ArticleSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;

public class KbSearch
extends BaseSearch {
    public static final String CATEGORY_ID = "categoryId";
    public static final String ARTICLE_ID = "articleId";
    public static final String ARTICLE_ID_EQUALS = "articleIdEquals";
    public static final String ARTICLE_ID_NOT_EQUALS = "articleIdNotEquals";
    public static final String ARTICLE_TEXT = "articleText";
    public static final String ARTICLE_WIKI_NAMESPACE = "articleWikiNamespace";

    public void prepareMap(ArticleSearchForm articleSearchForm) {
        Integer categoryId = articleSearchForm.getCategoryId();
        String articleText = articleSearchForm.getArticleText();
        String articleWikiNamespace = articleSearchForm.getNamespace();
        if (categoryId != null) {
            this.searchCriteriaMap.put(CATEGORY_ID, categoryId);
        }
        if (!articleText.isEmpty()) {
            this.searchCriteriaMap.put(ARTICLE_TEXT, articleText);
        }
        if (!articleWikiNamespace.isEmpty()) {
            this.searchCriteriaMap.put(ARTICLE_WIKI_NAMESPACE, articleWikiNamespace);
        }
    }

    @Override
    public void applyMap(QueryCriteria queryCriteria) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey(CATEGORY_ID)) {
            queryCriteria.appendWhereClause("a.category_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CATEGORY_ID)));
        }
        if (this.searchCriteriaMap.containsKey(ARTICLE_ID_NOT_EQUALS)) {
            queryCriteria.appendWhereClause("a.article_id != " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(ARTICLE_ID_NOT_EQUALS)));
        }
        if (this.searchCriteriaMap.containsKey(ARTICLE_ID_EQUALS)) {
            queryCriteria.appendWhereClause("a.article_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(ARTICLE_ID_EQUALS)));
        }
        if (this.searchCriteriaMap.containsKey(ARTICLE_TEXT)) {
            queryCriteria.appendWhereClause("lower(a.article_text) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get(ARTICLE_TEXT)) + "%') or lower(a.article_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get(ARTICLE_TEXT)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(ARTICLE_WIKI_NAMESPACE)) {
            queryCriteria.appendWhereClause("lower(a.article_wiki_namespace) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(ARTICLE_WIKI_NAMESPACE)) + "')");
        }
    }
}

