/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.kb;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.kb.KbSearch;
import com.kwoksys.biz.kb.dao.KbDao;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dao.CategoryDao;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.List;

public class KbService {
    private RequestContext requestContext;

    public KbService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Category> getCategories(QueryCriteria query) throws DatabaseException {
        CategoryDao categoryDao = new CategoryDao(this.requestContext);
        return categoryDao.getCategoryList(query, ObjectTypes.KB_ARTICLE);
    }

    public Category getCategory(Integer categoryId) throws DatabaseException, ObjectNotFoundException {
        CategoryDao categoryDao = new CategoryDao(this.requestContext);
        return categoryDao.getCategory(categoryId, ObjectTypes.KB_ARTICLE);
    }

    public ActionMessages addCategory(Category category) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (category.getName().isEmpty()) {
            errors.add("categoryName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.category_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        CategoryDao categoryDao = new CategoryDao(this.requestContext);
        return categoryDao.addCategory(category);
    }

    public ActionMessages updateCategory(Category category) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (category.getName().isEmpty()) {
            errors.add("categoryName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.category_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        CategoryDao categoryDao = new CategoryDao(this.requestContext);
        return categoryDao.editCategory(category);
    }

    public List<Article> getArticles(QueryCriteria query) throws DatabaseException {
        KbDao kbDao = new KbDao(this.requestContext);
        return kbDao.getArticles(query);
    }

    public int getArticlesCount(QueryCriteria query) throws DatabaseException {
        return new KbDao(this.requestContext).getArticlesCount(query);
    }

    public Article getArticle(Integer articleId) throws DatabaseException, ObjectNotFoundException {
        KbSearch kbSearch = new KbSearch();
        kbSearch.put("articleIdEquals", articleId);
        QueryCriteria query = new QueryCriteria(kbSearch);
        KbDao kbDao = new KbDao(this.requestContext);
        return kbDao.getArticle(query);
    }

    public Article getArticle(String articleWikiNamespace) throws DatabaseException, ObjectNotFoundException {
        KbSearch kbSearch = new KbSearch();
        kbSearch.put("articleWikiNamespace", articleWikiNamespace);
        QueryCriteria queryCriteria = new QueryCriteria(kbSearch);
        KbDao kbDao = new KbDao(this.requestContext);
        return kbDao.getArticle(queryCriteria);
    }

    public List<File> getArticleFiles(QueryCriteria queryCriteria, Integer articleId) throws DatabaseException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        return fileService.getFiles(queryCriteria, ObjectTypes.KB_ARTICLE, articleId);
    }

    public File getArticleFile(Integer articleId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        File file = fileService.getFile(ObjectTypes.KB_ARTICLE, articleId, fileId);
        file.setConfigRepositoryPath(ConfigManager.file.getKbFileRepositoryLocation());
        file.setConfigUploadedFilePrefix(ConfigManager.file.getKbUploadedFilePrefix());
        return file;
    }

    public boolean isWikiNamespaceInUse(Article article) throws DatabaseException {
        QueryCriteria queryCriteria;
        if (article.getWikiNamespace() == null) {
            return false;
        }
        KbSearch kbSearch = new KbSearch();
        kbSearch.put("articleWikiNamespace", article.getWikiNamespace());
        if (article.getId() != null && article.getId() != 0) {
            kbSearch.put("articleIdNotEquals", article.getId());
        }
        return this.getArticlesCount(queryCriteria = new QueryCriteria(kbSearch)) > 0;
    }

    public ActionMessages addArticle(Article article) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("articleName").setTitleKey("common.column.article_name").setNullable(false).calculateLength(article.getName()).setColumnName("kb_article.article_name"));
        if (article.getContent().replace("\n", "").replace("\r", "").length() > ConfigManager.app.getKbArticleCharLimit()) {
            String fieldName = Localizer.getText(this.requestContext, "common.column.article_text");
            errors.add("articleText", new ActionMessage("common.form.fieldExceededMaxLen", new Object[]{fieldName, ConfigManager.app.getKbArticleCharLimit()}));
        }
        if (this.isWikiNamespaceInUse(article)) {
            errors.add("namespaceInUse", new ActionMessage("kb.articleAdd.error.namespaceInUse", new Object[]{article.getWikiNamespace()}));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        KbDao kbDao = new KbDao(this.requestContext);
        return kbDao.addArticle(article);
    }

    public ActionMessages updateArticle(Article article) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("articleName").setTitleKey("common.column.article_name").setNullable(false).calculateLength(article.getName()).setColumnName("kb_article.article_name"));
        if (article.getContent().replace("\n", "").replace("\r", "").length() > ConfigManager.app.getKbArticleCharLimit()) {
            String fieldName = Localizer.getText(this.requestContext, "common.column.article_text");
            errors.add("articleText", new ActionMessage("common.form.fieldExceededMaxLen", new Object[]{fieldName, ConfigManager.app.getKbArticleCharLimit()}));
        }
        if (this.isWikiNamespaceInUse(article)) {
            errors.add("namespaceInUse", new ActionMessage("kb.articleAdd.error.namespaceInUse", new Object[]{article.getWikiNamespace()}));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new KbDao(this.requestContext).updateArticle(article);
    }

    public ActionMessages deleteArticle(Article article) throws DatabaseException {
        List<File> deleteFileList = this.getArticleFiles(new QueryCriteria(), article.getId());
        KbDao kbDao = new KbDao(this.requestContext);
        ActionMessages errors = kbDao.deleteArticle(article);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (errors.isEmpty()) {
            fileService.bulkDelete(ConfigManager.file.getKbFileRepositoryLocation(), deleteFileList);
        }
        return errors;
    }

    public void updateArticleViewCount(Article article) throws DatabaseException {
        KbDao kbDao = new KbDao(this.requestContext);
        kbDao.updateArticleViewCount(article);
    }
}

