/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.kb;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.parsers.wiki.Parser;
import com.kwoksys.framework.parsers.wiki.WikiParserFactory;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KbUtils {
    public static List<String> getCategoryColumnHeaderList() {
        return Arrays.asList("rownum", "category_name", "category_description", "article_object_count", "category_actions");
    }

    public static List<String> getCategorySortableColumnList() {
        return Arrays.asList("category_name");
    }

    public static String[] getArticleColumnsDefault() {
        return new String[]{"article_name", "article_view_count"};
    }

    public static List<String> getArticleColumnHeaderList() {
        return Arrays.asList(ConfigManager.app.getKbArticleColumns());
    }

    public static boolean isSortableCategoryColumn(String columnName) {
        return KbUtils.getCategorySortableColumnList().contains(columnName);
    }

    public static void generatePath(HeaderTemplate header, RequestContext requestContext, Category category) {
        Link link = new Link(requestContext);
        link.setAjaxPath(AppPaths.KB_INDEX);
        link.setTitleKey("kb.articleDetail.home");
        header.addNavLink(link);
        link = new Link(requestContext);
        link.setAjaxPath(AppPaths.KB_ARTICLE_LIST + "?categoryId=" + category.getId());
        link.setTitle(category.getName());
        header.addNavLink(link);
    }

    public static String truncateBodyText(String input) {
        int limit = 300;
        if (input.length() > limit) {
            input = input.substring(0, limit) + "...";
        }
        return input;
    }

    public static String formatContent(RequestContext requestContext, Article article) throws Exception {
        if (article.getSyntaxType().equals(AttributeFieldIds.KB_ARTICLE_SYNTAX_MEDIAWIKI)) {
            Parser parser = WikiParserFactory.getParser("mediawiki");
            return parser.parseHtml(requestContext, article.getContent());
        }
        if (article.getSyntaxType().equals(AttributeFieldIds.KB_ARTICLE_SYNTAX_TWIKI)) {
            Parser parser = WikiParserFactory.getParser("twiki");
            return parser.parseHtml(requestContext, article.getContent());
        }
        return article.getContent();
    }

    public static boolean isWikiType(int syntaxType) {
        return syntaxType == AttributeFieldIds.KB_ARTICLE_SYNTAX_MEDIAWIKI || syntaxType == AttributeFieldIds.KB_ARTICLE_SYNTAX_TWIKI;
    }

    public static List<LabelValueBean> getArticleSyntaxOptions(RequestContext requestContext, Article article) throws DatabaseException {
        AttributeManager attributeManager = new AttributeManager(requestContext);
        ArrayList<LabelValueBean> options = new ArrayList<LabelValueBean>();
        for (Integer syntax : KbUtils.getArticleSyntaxes(article)) {
            String syntaxName = attributeManager.getAttrFieldNameCache(Attributes.KB_ARTICLE_SYNTAX_TYPE, syntax);
            options.add(new LabelValueBean(syntaxName, syntax.toString()));
        }
        return options;
    }

    public static List<Integer> getArticleSyntaxes(Article article) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(AttributeFieldIds.KB_ARTICLE_SYNTAX_HTML);
        if (ConfigManager.app.isKbArticleMediaWikiSyntaxEnabled() || AttributeFieldIds.KB_ARTICLE_SYNTAX_MEDIAWIKI.equals(article.getSyntaxType())) {
            list.add(AttributeFieldIds.KB_ARTICLE_SYNTAX_MEDIAWIKI);
        }
        return list;
    }

    public static String formatWikiNamespace(Integer wikiSyntaxType, String namespace) {
        if (wikiSyntaxType.equals(AttributeFieldIds.KB_ARTICLE_SYNTAX_MEDIAWIKI)) {
            return namespace.replace(" ", "_");
        }
        return null;
    }
}

