/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.kb.dao;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.EventTypes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class KbDao
extends BaseDao {
    public KbDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Article> getArticles(QueryCriteria query) throws DatabaseException {
        final ArrayList<Article> articles = new ArrayList<Article>();
        QueryHelper queryHelper = new QueryHelper(KbQueries.selectArticleListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Article article = new Article();
                article.setId(rs.getInt("article_id"));
                article.setName(rs.getString("article_name"));
                article.setContent(StringUtils.replaceNull(rs.getString("article_text")));
                article.setCategoryId(rs.getInt("category_id"));
                article.setCategoryName(StringUtils.replaceNull(rs.getString("category_name")));
                article.setSyntaxType(rs.getInt("article_syntax_type"));
                article.setViewCount(rs.getLong("view_count"));
                article.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                article.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                article.setCreator(new AccessUser());
                article.getCreator().setId(rs.getInt("creator"));
                article.getCreator().setUsername(rs.getString("creator_username"));
                article.getCreator().setDisplayName(rs.getString("creator_display_name"));
                article.setModifier(new AccessUser());
                article.getModifier().setId(rs.getInt("modifier"));
                article.getModifier().setUsername(rs.getString("modifier_username"));
                article.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                articles.add(article);
            }
        };
        this.executeQuery(queryHelper);
        return articles;
    }

    public int getArticlesCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(KbQueries.getArticlesCountQuery(query));
    }

    public Article getArticle(QueryCriteria query) throws DatabaseException, ObjectNotFoundException {
        final ArrayList articles = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(KbQueries.selectArticleDetailQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Article article = new Article();
                article.setId(rs.getInt("article_id"));
                article.setName(rs.getString("article_name"));
                article.setContent(StringUtils.replaceNull(rs.getString("article_text")));
                article.setCategoryId(rs.getInt("category_id"));
                article.setCategoryName(StringUtils.replaceNull(rs.getString("category_name")));
                article.setSyntaxType(rs.getInt("article_syntax_type"));
                article.setViewCount(rs.getLong("view_count"));
                article.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                article.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                article.setCreator(new AccessUser());
                article.getCreator().setId(rs.getInt("creator"));
                article.getCreator().setUsername(rs.getString("creator_username"));
                article.getCreator().setDisplayName(rs.getString("creator_display_name"));
                article.setModifier(new AccessUser());
                article.getModifier().setId(rs.getInt("modifier"));
                article.getModifier().setUsername(rs.getString("modifier_username"));
                article.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                articles.add(article);
            }
        };
        this.executeSingleRecordQuery(queryHelper);
        if (!articles.isEmpty()) {
            return (Article)articles.get(0);
        }
        throw new ObjectNotFoundException();
    }

    public ActionMessages addArticle(Article article) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(KbQueries.addArticleQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(article.getName());
        queryHelper.addInputStringConvertNull(article.getContent());
        queryHelper.addInputInt(article.getSyntaxType());
        queryHelper.addInputStringConvertNull(article.getWikiNamespace());
        queryHelper.addInputInt(article.getCategoryId());
        queryHelper.addInputInt(EventTypes.KB_ARTICLE_ADD);
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            article.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages updateArticle(Article article) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(KbQueries.updateArticleQuery());
        queryHelper.addInputInt(article.getId());
        queryHelper.addInputStringConvertNull(article.getName());
        queryHelper.addInputStringConvertNull(article.getContent());
        queryHelper.addInputInt(article.getSyntaxType());
        queryHelper.addInputStringConvertNull(article.getWikiNamespace());
        queryHelper.addInputInt(article.getCategoryId());
        queryHelper.addInputInt(EventTypes.KB_ARTICLE_UPDATE);
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages deleteArticle(Article article) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(KbQueries.deleteArticleQuery());
        queryHelper.addInputInt(ObjectTypes.KB_ARTICLE);
        queryHelper.addInputInt(article.getId());
        queryHelper.addInputInt(EventTypes.KB_ARTICLE_DELETE);
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages updateArticleViewCount(Article article) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(KbQueries.updateArticleViewCountQuery());
        queryHelper.addInputInt(article.getId());
        return this.executeProcedure(queryHelper);
    }
}

