/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.portal;

import com.kwoksys.biz.portal.dao.SiteDao;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.dao.CategoryDao;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.List;

public class PortalService {
    private RequestContext requestContext;

    public PortalService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Site> getSites(QueryCriteria query) throws DatabaseException {
        return new SiteDao(this.requestContext).getSiteList(query);
    }

    public int getSiteCount(QueryCriteria query) throws DatabaseException {
        return new SiteDao(this.requestContext).getCount(query);
    }

    public Site getSite(Integer siteId) throws DatabaseException, ObjectNotFoundException {
        return new SiteDao(this.requestContext).getSite(siteId);
    }

    public ActionMessages addSite(Site site) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (site.getName().isEmpty()) {
            errors.add("siteName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.site_name")));
        }
        if (site.getPath().isEmpty()) {
            errors.add("sitePath", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.site_path")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        errors = new SiteDao(this.requestContext).add(site);
        if (errors.isEmpty()) {
            new CacheManager(this.requestContext).removeModuleTabsCache();
        }
        return errors;
    }

    public ActionMessages updateSite(Site site) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (site.getName().isEmpty()) {
            errors.add("siteName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.site_name")));
        }
        if (site.getPath().isEmpty()) {
            errors.add("sitePath", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.site_path")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        errors = new SiteDao(this.requestContext).update(site);
        if (errors.isEmpty()) {
            new CacheManager(this.requestContext).removeModuleTabsCache();
        }
        return errors;
    }

    public ActionMessages deleteSite(Integer siteId) throws DatabaseException {
        ActionMessages errors = new SiteDao(this.requestContext).delete(siteId);
        if (errors.isEmpty()) {
            new CacheManager(this.requestContext).removeModuleTabsCache();
        }
        return errors;
    }

    public List<Category> getCategories(QueryCriteria query) throws DatabaseException {
        return new CategoryDao(this.requestContext).getCategoryList(query, ObjectTypes.PORTAL_SITE);
    }

    public Category getCategory(Integer categoryId) throws DatabaseException, ObjectNotFoundException {
        return new CategoryDao(this.requestContext).getCategory(categoryId, ObjectTypes.PORTAL_SITE);
    }

    public ActionMessages addCategory(Category category) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (category.getName().isEmpty()) {
            errors.add("categoryName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.category_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CategoryDao(this.requestContext).addCategory(category);
    }

    public ActionMessages editCategory(Category category) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (category.getName().isEmpty()) {
            errors.add("categoryName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.category_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CategoryDao(this.requestContext).editCategory(category);
    }
}

