/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.portal;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class PortalUtils {
    public static List<String> getCategoryColumnHeaderList() {
        return Arrays.asList("rownum", "category_name", "category_description", "category_actions");
    }

    public static List<String> getCategorySortableColumnList() {
        return Arrays.asList("category_name");
    }

    public static boolean isSortableCategoryColumn(String columnName) {
        return PortalUtils.getCategorySortableColumnList().contains(columnName);
    }

    public static String truncateBodyTextOnList(String input) {
        int limit = ConfigManager.app.getBlogsNumberOfPostCharacters();
        input = limit != 0 && input.length() > limit ? HtmlUtils.formatMultiLineDisplay(input.substring(0, limit)) + "..." : HtmlUtils.formatMultiLineDisplay(input);
        return input;
    }

    public static String formatRssItem(String input) {
        if (StringUtils.isEmpty(input)) {
            return "";
        }
        input = input.replaceAll("\\<object.*?object\\>", "");
        return input.replaceAll("\\<a href", "<a target=\"_blank\" href");
    }
}

