/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.portal.dao;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class SiteDao
extends BaseDao {
    public SiteDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Site> getSiteList(QueryCriteria query) throws DatabaseException {
        final ArrayList<Site> sites = new ArrayList<Site>();
        QueryHelper queryHelper = new QueryHelper(PortalQueries.selectSiteListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Site site = new Site();
                site.setId(rs.getInt("site_id"));
                site.setName(StringUtils.replaceNull(rs.getString("site_name")));
                site.setPath(StringUtils.replaceNull(rs.getString("site_path")));
                site.setPlacement(rs.getInt("site_placement"));
                site.setSupportIframe(rs.getInt("site_support_iframe"));
                site.setCategoryId(rs.getInt("category_id"));
                site.setCategoryName(StringUtils.replaceNull(rs.getString("category_name")));
                sites.add(site);
            }
        };
        this.executeQuery(queryHelper);
        return sites;
    }

    public int getCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(PortalQueries.selectSiteCountQuery(query));
    }

    public Site getSite(Integer siteId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList sites = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(PortalQueries.selectSiteDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Site site = new Site();
                site.setId(rs.getInt("site_id"));
                site.setName(StringUtils.replaceNull(rs.getString("site_name")));
                site.setPath(StringUtils.replaceNull(rs.getString("site_path")));
                site.setDescription(StringUtils.replaceNull(rs.getString("site_description")));
                site.setPlacement(rs.getInt("site_placement"));
                site.setSupportIframe(rs.getInt("site_support_iframe"));
                site.setCategoryId(rs.getInt("category_id"));
                site.setCategoryName(StringUtils.replaceNull(rs.getString("category_name")));
                site.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                site.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                site.setCreator(new AccessUser());
                site.getCreator().setId(rs.getInt("creator"));
                site.getCreator().setUsername(rs.getString("creator_username"));
                site.getCreator().setDisplayName(rs.getString("creator_display_name"));
                site.setModifier(new AccessUser());
                site.getModifier().setId(rs.getInt("modifier"));
                site.getModifier().setUsername(rs.getString("modifier_username"));
                site.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                sites.add(site);
            }
        };
        queryHelper.addInputInt(siteId);
        this.executeSingleRecordQuery(queryHelper);
        if (!sites.isEmpty()) {
            return (Site)sites.get(0);
        }
        throw new ObjectNotFoundException("Site ID: " + siteId);
    }

    public ActionMessages add(Site site) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(PortalQueries.insertSiteQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(site.getName());
        queryHelper.addInputStringConvertNull(site.getPath());
        queryHelper.addInputStringConvertNull(site.getDescription());
        queryHelper.addInputInt(site.getPlacement());
        queryHelper.addInputInt(site.getSupportIframe());
        queryHelper.addInputInt(site.getCategoryId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            site.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages update(Site site) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(PortalQueries.updateSiteQuery());
        queryHelper.addInputInt(site.getId());
        queryHelper.addInputStringConvertNull(site.getName());
        queryHelper.addInputStringConvertNull(site.getPath());
        queryHelper.addInputStringConvertNull(site.getDescription());
        queryHelper.addInputInt(site.getPlacement());
        queryHelper.addInputInt(site.getSupportIframe());
        queryHelper.addInputInt(site.getCategoryId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages delete(Integer siteId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(PortalQueries.deleteSiteQuery());
        queryHelper.addInputInt(siteId);
        return this.executeProcedure(queryHelper);
    }
}

