/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.portal.dto;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Site
extends BaseObject {
    public static final String SITE_NAME = "site_name";
    public static final String SITE_PATH = "site_path";
    public static final String PLACEMENT = "site_placement";
    public static final String SUPPORT_IFRAME = "site_support_iframe";
    public static final String CATEGORY_NAME = "category_name";
    public static final int PLACEMENT_HIDDEN = 0;
    public static final int PLACEMENT_LIST = 1;
    public static final int PLACEMENT_TAB = 2;
    public static final int PLACEMENT_LIST_AND_TAB = 3;
    private Integer id;
    private String name;
    private String path;
    private String description;
    private int placement = 1;
    private int isSupportIframe = 0;
    private Integer categoryId = 0;
    private String categoryName;

    public static List<String> getColumnHeader() {
        return Arrays.asList(ConfigManager.app.getPortalColumns());
    }

    public static List<String> getSortableColumnList() {
        return Arrays.asList(SITE_NAME, SITE_PATH, PLACEMENT, SUPPORT_IFRAME);
    }

    public static boolean isSortableColumn(String columnName) {
        return Site.getSortableColumnList().contains(columnName);
    }

    public static int getColumnHeaderCount() {
        return Site.getColumnHeader().size();
    }

    public static String getSitePlacementMessageKey(int input) {
        switch (input) {
            case 0: {
                return "portalSite.placementHidden";
            }
            case 1: {
                return "portalSite.placementList";
            }
            case 2: {
                return "portalSite.placementTab";
            }
            case 3: {
                return "portalSite.placementListAndTab";
            }
        }
        return null;
    }

    public static List<LabelValueBean> getSitePlacementList(RequestContext requestContext) {
        return Arrays.asList(new LabelValueBean(Localizer.getText(requestContext, "portalSite.placementHidden"), "0"), new LabelValueBean(Localizer.getText(requestContext, "portalSite.placementList"), "1"), new LabelValueBean(Localizer.getText(requestContext, "portalSite.placementTab"), "2"), new LabelValueBean(Localizer.getText(requestContext, "portalSite.placementListAndTab"), "3"));
    }

    public static List<LabelValueBean> getSiteCategories(RequestContext requestContext) throws DatabaseException {
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(PortalQueries.getOrderByColumn(CATEGORY_NAME));
        ArrayList<LabelValueBean> categoryOptions = new ArrayList<LabelValueBean>();
        PortalService portalService = ServiceProvider.getPortalService(requestContext);
        for (Category category : portalService.getCategories(query)) {
            categoryOptions.add(new LabelValueBean(category.getName(), String.valueOf(category.getId())));
        }
        return categoryOptions;
    }

    public static String getSupportIframe(int input) {
        if (input == 0) {
            return "common.boolean.yes_no.false";
        }
        return "common.boolean.yes_no.true";
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setPlacement(int placement) {
        this.placement = placement;
    }

    public int getSupportIframe() {
        return this.isSupportIframe;
    }

    public void setSupportIframe(int supportIframe) {
        this.isSupportIframe = supportIframe;
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
}

