/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports;

import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.CustomFieldFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class Report {
    protected RequestContext requestContext;
    private List<String> columnHeaders = new ArrayList<String>();
    private List<String> reportColumns;
    private String reportColumnOrder;
    private String reportColumnOrderBy;
    private String title;

    public abstract void populateData(ReportWriter var1) throws Exception;

    public String getCsvFilename() {
        return this.getFilename() + ".csv";
    }

    public String getPdfFilename() {
        return this.getFilename() + ".pdf";
    }

    public abstract String getFilename();

    public abstract String getReportFormName();

    public abstract String getReportPath();

    public List<String> computeColumns(List<String> defaultColumns) {
        if (this.getReportColumns() != null) {
            List<String> formColumns = this.getReportColumns();
            ArrayList<String> returnColumns = new ArrayList<String>(defaultColumns);
            returnColumns.retainAll(formColumns);
            return returnColumns;
        }
        return defaultColumns;
    }

    public Collection<Attribute> computeCustFieldColumns(RequestContext requestContext, Integer objectTypeId) throws Exception {
        Collection<Attribute> attrs = new AttributeManager(requestContext).getCustomFieldMap(objectTypeId).values();
        if (this.getReportColumns() != null) {
            List<String> formCustFields = this.getReportColumns();
            ArrayList<Attribute> returnCustFields = new ArrayList<Attribute>();
            for (Attribute attr : attrs) {
                if (!formCustFields.contains(String.valueOf(attr.getId()))) continue;
                returnCustFields.add(attr);
            }
            return returnCustFields;
        }
        return attrs;
    }

    protected void addCustomFieldValues(AdminService adminService, Collection<Attribute> attrs, List<String> columns, BaseObject object) throws DatabaseException {
        if (!attrs.isEmpty()) {
            Map<Integer, Object> valueMap = adminService.getCustomAttributeValueMap(object.getObjectTypeId(), object.getId());
            for (Attribute attr : attrs) {
                columns.add(new CustomFieldFormatter(this.requestContext, attr, valueMap.get(attr.getId())).getAttributeTextValue());
            }
        }
    }

    public List<String> getColumnHeaders() {
        return this.columnHeaders;
    }

    public List<String> getReportColumns() {
        return this.reportColumns;
    }

    public void setReportColumns(List<String> reportColumns) {
        this.reportColumns = reportColumns;
    }

    public String getReportColumnOrder() {
        return this.reportColumnOrder;
    }

    public void setReportColumnOrder(String reportColumnOrder) {
        this.reportColumnOrder = reportColumnOrder;
    }

    public String getReportColumnOrderBy() {
        return this.reportColumnOrderBy;
    }

    public void setReportColumnOrderBy(String reportColumnOrderBy) {
        this.reportColumnOrderBy = reportColumnOrderBy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

