/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports;

import com.kwoksys.action.reports.ReportForm;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.types.ContactReport;
import com.kwoksys.biz.reports.types.ContractReport;
import com.kwoksys.biz.reports.types.HardwareComponentReport;
import com.kwoksys.biz.reports.types.HardwareLicenseReport;
import com.kwoksys.biz.reports.types.HardwareMembersReport;
import com.kwoksys.biz.reports.types.HardwareReport;
import com.kwoksys.biz.reports.types.IssueReport;
import com.kwoksys.biz.reports.types.SoftwareReport;
import com.kwoksys.biz.reports.types.SoftwareUsageReport;
import com.kwoksys.framework.http.RequestContext;

public class ReportFactory {
    public static Report getReport(RequestContext requestContext, ReportForm reportForm) throws Exception {
        return ReportFactory.getReport(requestContext, reportForm.getReportType());
    }

    public static Report getReport(RequestContext requestContext, String reportType) throws Exception {
        if (reportType.equals("issue_report")) {
            return new IssueReport(requestContext, "ISSUE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("hardware_report")) {
            return new HardwareReport(requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("hardware_member_report")) {
            return new HardwareMembersReport(requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("hardware_license_report")) {
            return new HardwareLicenseReport(requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("hardware_component_report")) {
            return new HardwareComponentReport(requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("software_report")) {
            return new SoftwareReport(requestContext, "SOFTWARE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("software_usage_report")) {
            return new SoftwareUsageReport(requestContext, "SOFTWARE_USAGE_REPORT_CRITERIA_MAP");
        }
        if (reportType.equals("contact_report")) {
            return new ContactReport(requestContext, "COMPANY_SEARCH_CRITERIA_MAP");
        }
        if (reportType.equals("contract_report")) {
            return new ContractReport(requestContext, "CONTRACT_REPORT_CRITERIA_MAP");
        }
        throw new Exception("Unsupported report type");
    }
}

