/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReportUtils {
    public static final String ISSUE_REPORT_TYPE = "issue_report";
    public static final String HARDWARE_REPORT_TYPE = "hardware_report";
    public static final String HARDWARE_MEMBER_REPORT_TYPE = "hardware_member_report";
    public static final String HARDWARE_LICENSE_REPORT_TYPE = "hardware_license_report";
    public static final String HARDWARE_COMPONENT_REPORT_TYPE = "hardware_component_report";
    public static final String SOFTWARE_REPORT_TYPE = "software_report";
    public static final String SOFTWARE_USAGE_REPORT_TYPE = "software_usage_report";
    public static final String CONTACT_REPORT_TYPE = "contact_report";
    public static final String CONTRACT_REPORT_TYPE = "contract_report";
    public static final String OUTPUT_FORMAT_CSV_TABLE = "csv_table";
    public static final String OUTPUT_FORMAT_HTML_TABLE = "html_table";
    public static final String OUTPUT_FORMAT_HTML_LIST = "html_list";
    public static final String OUTPUT_FORMAT_PDF_LIST = "pdf_list";

    public static List<LabelValueBean> getTypeOptions(RequestContext requestContext) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        String[] reportTypes = new String[]{HARDWARE_REPORT_TYPE, HARDWARE_LICENSE_REPORT_TYPE, HARDWARE_MEMBER_REPORT_TYPE, SOFTWARE_REPORT_TYPE, SOFTWARE_USAGE_REPORT_TYPE, ISSUE_REPORT_TYPE, CONTRACT_REPORT_TYPE};
        ArrayList<LabelValueBean> options = new ArrayList<LabelValueBean>();
        options.add(new SelectOneLabelValueBean(requestContext));
        for (String reportType : reportTypes) {
            if (!ReportAccess.hasPermission(user, reportType)) continue;
            options.add(new LabelValueBean(Localizer.getText(requestContext, "reports.workflow.type." + reportType), reportType));
        }
        return options;
    }

    public static List<String> getOutputOptions() {
        return Arrays.asList(OUTPUT_FORMAT_CSV_TABLE, OUTPUT_FORMAT_HTML_TABLE, OUTPUT_FORMAT_HTML_LIST, OUTPUT_FORMAT_PDF_LIST);
    }

    public static List<LabelValueBean> getReportSortOrderOptions(RequestContext requestContext) {
        ArrayList<LabelValueBean> options = new ArrayList<LabelValueBean>();
        options.add(new LabelValueBean(Localizer.getText(requestContext, "core.sort.asc"), "asc"));
        options.add(new LabelValueBean(Localizer.getText(requestContext, "core.sort.desc"), "desc"));
        return options;
    }

    public static List<String> getSoftwareUsageColumns() {
        return Arrays.asList("rownum", "software_name", "software_type", "hardware_name", "hardware_owner_name");
    }

    public static List<String> getSoftwareUsageSortableColumns() {
        return Arrays.asList("software_name", "hardware_name", "hardware_owner_name");
    }

    public static boolean isSoftwareUsageSortableColumn(String columnName) {
        return ReportUtils.getSoftwareUsageSortableColumns().contains(columnName);
    }

    public static List<String> getSoftwareUsageExportColumns() {
        return Arrays.asList("software_name", "software_description", "software_type", "hardware_name", "hardware_owner_name");
    }

    public static List<String> getHardwareMembersExportColumns() {
        return Arrays.asList("hardware_name", "hardware_member_name");
    }

    public static List<String> getHardwareLicenseColumns() {
        return Arrays.asList("hardware_name", "software_name", "license_key");
    }
}

