/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.reports.dao.ReportQueries;
import com.kwoksys.biz.reports.dto.SoftwareUsage;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReportDao
extends BaseDao {
    public ReportDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<SoftwareUsage> getSoftwareUsage(QueryCriteria query) throws DatabaseException {
        final ArrayList<SoftwareUsage> list = new ArrayList<SoftwareUsage>();
        QueryHelper queryHelper = new QueryHelper(ReportQueries.selectSoftwareUsageQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                SoftwareUsage softwareUsage = new SoftwareUsage();
                softwareUsage.setId(rs.getInt("software_id"));
                softwareUsage.setName(rs.getString("software_name"));
                softwareUsage.setDescription(StringUtils.replaceNull(rs.getString("software_description")));
                softwareUsage.setTypeName(StringUtils.replaceNull(rs.getString("software_type_name")));
                softwareUsage.setHardwareId(rs.getInt("hardware_id"));
                softwareUsage.setHardwareName(StringUtils.replaceNull(rs.getString("hardware_name")));
                softwareUsage.setHardwareOwnerId(rs.getInt("hardware_owner_id"));
                softwareUsage.setHardwareOwnerName(StringUtils.replaceNull(rs.getString("hardware_owner_display_name")));
                list.add(softwareUsage);
            }
        };
        this.executeQuery(queryHelper);
        return list;
    }

    public int getSoftwareUsageCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(ReportQueries.selectSoftwareUsageCountQuery(query));
    }

    public List<Map<String, String>> getHardwareMembers(QueryCriteria searchQuery, QueryCriteria query) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ReportQueries.selectHardwareMembersQuery(searchQuery, query));
        return this.executeQueryReturnList(queryHelper);
    }

    public int getHardwareMembersCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(ReportQueries.selectHardwareMembersCountQuery(query));
    }

    public int getHardwareLicenseCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(ReportQueries.getHardwareLicenseCountQuery(query));
    }

    public List<Map<String, String>> getHardwareLicenses(QueryCriteria query) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ReportQueries.getHardwareLicensesQuery(query));
        return this.executeQueryReturnList(queryHelper);
    }
}

