/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.core.ContactSearch;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.StringUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ContactReport
extends Report {
    private String reportCriteriaMapAttr;

    public ContactReport(RequestContext requestContext, String reportCriteriaMapAttr) {
        this.requestContext = requestContext;
        this.reportCriteriaMapAttr = reportCriteriaMapAttr;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getContactsReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.contact_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "ContactSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_CONTRACT_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        String order;
        String orderBy;
        HttpSession session = this.requestContext.getSession();
        List<String> columnKeys = this.computeColumns(ConfigManager.app.getContactsExportColumns());
        for (String string : columnKeys) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        Collection<Attribute> attrs = this.computeCustFieldColumns(this.requestContext, ObjectTypes.CONTACT);
        for (Attribute attr : attrs) {
            this.getColumnHeaders().add(attr.getName());
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        ContactSearch contactSearch = new ContactSearch();
        if (session.getAttribute(this.reportCriteriaMapAttr) != null) {
            contactSearch.setSearchCriteriaMap((Map)session.getAttribute(this.reportCriteriaMapAttr));
        }
        if ((orderBy = this.getReportColumnOrderBy()) == null) {
            orderBy = SessionManager.getAttribute(this.requestContext.getRequest(), "CONTACTS_ORDER_BY", "company_name");
        }
        if ((order = this.getReportColumnOrder()) == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "CONTACTS_ORDER", "asc");
        }
        QueryCriteria query = new QueryCriteria(contactSearch);
        if (CompanyUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        List<Contact> contacts = contactService.getCompanyContacts(query, null, ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
        for (Contact contact : contacts) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("contact_first_name")) {
                    columns.add(contact.getFirstName());
                    continue;
                }
                if (column.equals("contact_last_name")) {
                    columns.add(contact.getLastName());
                    continue;
                }
                if (column.equals("contact_title")) {
                    columns.add(contact.getTitle());
                    continue;
                }
                if (column.equals("contact_email_primary")) {
                    columns.add(contact.getEmailPrimary());
                    continue;
                }
                if (column.equals("contact_phone_work")) {
                    columns.add(contact.getPhoneWork());
                    continue;
                }
                if (!column.equals("company_name")) continue;
                columns.add(contact.getCompanyName());
            }
            reportWriter.addRow(columns);
        }
    }
}

