/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractSearch;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dao.ContractQueries;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.Callback;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContractReport
extends Report {
    private String reportCriteriaMapKey;

    public ContractReport(RequestContext requestContext, String reportCriteriaMapKey) {
        this.requestContext = requestContext;
        this.reportCriteriaMapKey = reportCriteriaMapKey;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getContractsReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.contract_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "ContractSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_CONTRACT_SEARCH;
    }

    @Override
    public void populateData(final ReportWriter reportWriter) throws Exception {
        String order;
        final List<String> columnKeys = this.computeColumns(ConfigManager.app.getContractsExportColumns());
        for (String string : columnKeys) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        final Collection<Attribute> attrs = this.computeCustFieldColumns(this.requestContext, ObjectTypes.CONTRACT);
        for (Attribute attr : attrs) {
            this.getColumnHeaders().add(attr.getName());
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        ContractSearch contractSearch = new ContractSearch(this.requestContext, this.reportCriteriaMapKey);
        String orderBy = this.getReportColumnOrderBy();
        if (orderBy == null) {
            orderBy = SessionManager.getAttribute(this.requestContext.getRequest(), "CONTRACTS_ORDER_BY", "contract_name");
        }
        if ((order = this.getReportColumnOrder()) == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "CONTRACTS_ORDER", "asc");
        }
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        final AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        final AttributeManager attributeManager = new AttributeManager(this.requestContext);
        QueryCriteria queryCriteria = new QueryCriteria(contractSearch);
        if (ContractUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(ContractQueries.getOrderByColumn(orderBy), order);
        }
        queryCriteria.setCallback(new Callback(){

            @Override
            public void run(Object object) throws Exception {
                Contract contract = (Contract)object;
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnKeys) {
                    AccessUser contractOwner;
                    if (column.equals("contract_name")) {
                        columns.add(contract.getName());
                        continue;
                    }
                    if (column.equals("contract_type")) {
                        columns.add(contract.getTypeName());
                        continue;
                    }
                    if (column.equals("contract_stage")) {
                        columns.add(attributeManager.getAttrFieldNameCache(Attributes.CONTRACT_STAGE, contract.getStage()));
                        continue;
                    }
                    if (column.equals("contract_owner_username")) {
                        contractOwner = new CacheManager(ContractReport.this.requestContext).getUserCache(contract.getOwnerId());
                        columns.add(AdminUtils.getSystemUsername(ContractReport.this.requestContext, contract.getOwnerId(), contractOwner.getUsername()));
                        continue;
                    }
                    if (column.equals("contract_owner_display_name")) {
                        contractOwner = new CacheManager(ContractReport.this.requestContext).getUserCache(contract.getOwnerId());
                        columns.add(AdminUtils.getSystemUsername(ContractReport.this.requestContext, contract.getOwnerId(), contractOwner.getDisplayName()));
                        continue;
                    }
                    if (column.equals("contract_renewal_type")) {
                        columns.add(contract.getRenewalTypeName());
                        continue;
                    }
                    if (column.equals("contract_expiration_date")) {
                        columns.add(DatetimeUtils.toShortDate(contract.getExpireDate()));
                        continue;
                    }
                    if (column.equals("contract_effective_date")) {
                        columns.add(DatetimeUtils.toShortDate(contract.getEffectiveDate()));
                        continue;
                    }
                    if (!column.equals("contract_renewal_date")) continue;
                    columns.add(DatetimeUtils.toShortDate(contract.getRenewalDate()));
                }
                ContractReport.this.addCustomFieldValues(adminService, attrs, columns, contract);
                reportWriter.addRow(columns);
            }
        });
        contractService.fetchContracts(queryCriteria);
    }
}

