/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.ReportService;
import com.kwoksys.biz.reports.dao.ReportQueries;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HardwareLicenseReport
extends Report {
    private String reportCriteriaMapKey;

    public HardwareLicenseReport(RequestContext requestContext, String reportCriteriaMapKey) {
        this.requestContext = requestContext;
        this.reportCriteriaMapKey = reportCriteriaMapKey;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getHardwareLicensesReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.hardware_license_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "HardwareSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_HARDWARE_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        List<String> columnKeys = this.computeColumns(ConfigManager.app.getHardwareLicenseExportColumns());
        if (columnKeys.contains("hardware_id")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.hardware_id"));
        }
        if (columnKeys.contains("hardware_name")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.hardware_name"));
        }
        if (columnKeys.contains("software_name")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.software_name"));
        }
        if (columnKeys.contains("license_key")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.license_key"));
        }
        if (columnKeys.contains("license_note")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.license_note"));
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, this.reportCriteriaMapKey);
        String order = this.getReportColumnOrder();
        if (order == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "HARDWARE_ORDER", "asc");
        }
        QueryCriteria query = new QueryCriteria(hardwareSearch);
        query.addSortColumn(ReportQueries.getHardwareLicenseOrderByColumn("hardware_name"), "asc");
        query.addSortColumn(ReportQueries.getHardwareLicenseOrderByColumn("software_name"), "asc");
        query.addSortColumn(ReportQueries.getHardwareLicenseOrderByColumn("license_key"), "asc");
        ReportService reportService = ServiceProvider.getReportService(this.requestContext);
        for (Map<String, String> record : reportService.getHardwareLicenses(query)) {
            ArrayList<String> columns = new ArrayList<String>();
            if (columnKeys.contains("hardware_id")) {
                columns.add(record.get("hardware_id"));
            }
            if (columnKeys.contains("hardware_name")) {
                columns.add(record.get("hardware_name"));
            }
            if (columnKeys.contains("software_name")) {
                columns.add(record.get("software_name"));
            }
            if (columnKeys.contains("license_key")) {
                columns.add(record.get("license_key"));
            }
            if (columnKeys.contains("license_note")) {
                columns.add(record.get("license_note"));
            }
            reportWriter.addRow(columns);
        }
    }
}

