/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.ReportService;
import com.kwoksys.biz.reports.dao.ReportQueries;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HardwareMembersReport
extends Report {
    private String reportCriteriaMapKey;

    public HardwareMembersReport(RequestContext requestContext, String reportCriteriaMapKey) {
        this.requestContext = requestContext;
        this.reportCriteriaMapKey = reportCriteriaMapKey;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getHardwareMembersReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.hardware_member_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "HardwareSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_HARDWARE_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        String order;
        List<String> columnKeys = this.computeColumns(ConfigManager.app.getHardwareMembersExportColumns());
        if (columnKeys.contains("hardware_id")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.hardware_id"));
        }
        if (columnKeys.contains("hardware_name")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.hardware_name"));
        }
        if (columnKeys.contains("hardware_id")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.hardware_member_id"));
        }
        if (columnKeys.contains("hardware_name")) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column.hardware_member_name"));
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, this.reportCriteriaMapKey);
        String orderBy = this.getReportColumnOrderBy();
        if (orderBy == null) {
            orderBy = SessionManager.getAttribute(this.requestContext.getRequest(), "HARDWARE_ORDER_BY", "hardware_name");
        }
        if ((order = this.getReportColumnOrder()) == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "HARDWARE_ORDER", "asc");
        }
        QueryCriteria searchQuery = new QueryCriteria(hardwareSearch);
        QueryCriteria query = new QueryCriteria();
        if (HardwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(ReportQueries.getHardwareMemberOrderByColumn(orderBy), order);
        }
        ReportService reportService = ServiceProvider.getReportService(this.requestContext);
        for (Map<String, String> record : reportService.getHardwareMembers(searchQuery, query)) {
            ArrayList<String> columns = new ArrayList<String>();
            if (columnKeys.contains("hardware_id")) {
                columns.add(record.get("hardware_id"));
            }
            if (columnKeys.contains("hardware_name")) {
                columns.add(record.get("hardware_name"));
            }
            if (columnKeys.contains("hardware_id")) {
                columns.add(record.get("hardware_member_id"));
            }
            if (columnKeys.contains("hardware_name")) {
                columns.add(record.get("hardware_member_name"));
            }
            reportWriter.addRow(columns);
        }
    }
}

