/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HardwareReport
extends Report {
    private String reportCriteriaMapKey;

    public HardwareReport(RequestContext requestContext, String reportCriteriaMapKey) {
        this.requestContext = requestContext;
        this.reportCriteriaMapKey = reportCriteriaMapKey;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getHardwareReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.hardware_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "HardwareSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_HARDWARE_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        String order;
        List<String> columnKeys = this.computeColumns(ConfigManager.app.getHardwareExportColumns());
        for (String string : columnKeys) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        Collection<Attribute> attrs = this.computeCustFieldColumns(this.requestContext, ObjectTypes.HARDWARE);
        for (Attribute attr : attrs) {
            this.getColumnHeaders().add(attr.getName());
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, this.reportCriteriaMapKey);
        String orderBy = this.getReportColumnOrderBy();
        if (orderBy == null) {
            orderBy = SessionManager.getAttribute(this.requestContext.getRequest(), "HARDWARE_ORDER_BY", "hardware_name");
        }
        if ((order = this.getReportColumnOrder()) == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "HARDWARE_ORDER", "asc");
        }
        QueryCriteria query = new QueryCriteria(hardwareSearch);
        if (HardwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(HardwareQueries.getOrderByColumn(orderBy), order);
        }
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        for (Hardware hardware : hardwareService.getHardwareList(query)) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("hardware_id")) {
                    columns.add(String.valueOf(hardware.getId()));
                    continue;
                }
                if (column.equals("hardware_name")) {
                    columns.add(hardware.getName());
                    continue;
                }
                if (column.equals("hardware_description")) {
                    columns.add(hardware.getDescription());
                    continue;
                }
                if (column.equals("hardware_manufacturer_name")) {
                    columns.add(hardware.getManufacturerName());
                    continue;
                }
                if (column.equals("hardware_vendor_name")) {
                    columns.add(hardware.getVendorName());
                    continue;
                }
                if (column.equals("hardware_type")) {
                    columns.add(attributeManager.getAttrFieldNameCache(Attributes.HARDWARE_TYPE, hardware.getType()));
                    continue;
                }
                if (column.equals("hardware_status")) {
                    columns.add(attributeManager.getAttrFieldNameCache(Attributes.HARDWARE_STATUS, hardware.getStatus()));
                    continue;
                }
                if (column.equals("hardware_model_name")) {
                    columns.add(hardware.getModelName());
                    continue;
                }
                if (column.equals("hardware_model_number")) {
                    columns.add(hardware.getModelNumber());
                    continue;
                }
                if (column.equals("hardware_serial_number")) {
                    columns.add(hardware.getSerialNumber());
                    continue;
                }
                if (column.equals("hardware_purchase_price")) {
                    columns.add(CurrencyUtils.formatCurrency(hardware.getPurchasePriceRaw(), ConfigManager.system.getCurrencySymbol()));
                    continue;
                }
                if (column.equals("hardware_purchase_date")) {
                    columns.add(DatetimeUtils.toShortDate(hardware.getHardwarePurchaseDate()));
                    continue;
                }
                if (column.equals("hardware_warranty_expire_date")) {
                    columns.add(DatetimeUtils.toShortDate(hardware.getWarrantyExpireDate()));
                    continue;
                }
                if (column.equals("hardware_last_service_date")) {
                    columns.add(hardware.getLastServicedOn());
                    continue;
                }
                if (column.equals("hardware_location")) {
                    columns.add(attributeManager.getAttrFieldNameCache(Attributes.HARDWARE_LOCATION, hardware.getLocation()));
                    continue;
                }
                if (column.equals("hardware_owner_name")) {
                    AccessUser hardwareOwner = new CacheManager(this.requestContext).getUserCache(hardware.getOwnerId());
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, hardwareOwner));
                    continue;
                }
                if (column.equals("creator_name")) {
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, hardware.getCreator()));
                    continue;
                }
                if (column.equals("creation_date")) {
                    columns.add(hardware.getCreationDate());
                    continue;
                }
                if (column.equals("modifier_name")) {
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, hardware.getModifier()));
                    continue;
                }
                if (!column.equals("modification_date")) continue;
                columns.add(hardware.getModificationDate());
            }
            this.addCustomFieldValues(adminService, attrs, columns, hardware);
            reportWriter.addRow(columns);
        }
    }
}

