/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dao.IssueQueries;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IssueReport
extends Report {
    private String reportCriteriaMapKey;

    public IssueReport(RequestContext requestContext, String reportCriteriaMapKey) {
        this.requestContext = requestContext;
        this.reportCriteriaMapKey = reportCriteriaMapKey;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getIssuesReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.issue_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "IssueSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_ISSUE_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        String order;
        List<String> columnKeys = this.computeColumns(ConfigManager.app.getIssueExportColumns());
        for (String string : columnKeys) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        Collection<Attribute> attrs = this.computeCustFieldColumns(this.requestContext, ObjectTypes.ISSUE);
        for (Attribute attr : attrs) {
            this.getColumnHeaders().add(attr.getName());
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        IssueSearch issueSearch = new IssueSearch(this.requestContext, this.reportCriteriaMapKey);
        AccessUser user = this.requestContext.getUser();
        if (!user.hasPermission(1)) {
            issueSearch.put("issuePermittedUserId", user.getId());
        }
        QueryCriteria query = new QueryCriteria(issueSearch);
        String orderBy = this.getReportColumnOrderBy();
        if (orderBy == null) {
            orderBy = SessionManager.getAttribute(this.requestContext.getRequest(), "ISSUES_ORDER_BY", "creation_date");
        }
        if ((order = this.getReportColumnOrder()) == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "ISSUES_ORDER", "desc");
        }
        if (IssueUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(IssueQueries.getOrderByColumn(orderBy), order);
        }
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        List<Issue> issues = issueService.getIssues(query);
        for (Issue issue : issues) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("issue_id")) {
                    columns.add(String.valueOf(issue.getId()));
                    continue;
                }
                if (column.equals("assignee_name")) {
                    columns.add(IssueUtils.formatAssigneeName(this.requestContext, issue.getAssignee()));
                    continue;
                }
                if (column.equals("issue_name")) {
                    columns.add(issue.getSubject());
                    continue;
                }
                if (column.equals("issue_description")) {
                    columns.add(issue.getDescription());
                    continue;
                }
                if (column.equals("creator_name")) {
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, issue.getCreator()));
                    continue;
                }
                if (column.equals("creation_date")) {
                    columns.add(issue.getCreationDate());
                    continue;
                }
                if (column.equals("modifier_name")) {
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, issue.getModifier()));
                    continue;
                }
                if (column.equals("modification_date")) {
                    columns.add(issue.getModificationDate());
                    continue;
                }
                if (column.equals("issue_due_date")) {
                    columns.add(issue.getDueDateShort());
                    continue;
                }
                if (column.equals("issue_type")) {
                    columns.add(issue.getTypeName());
                    continue;
                }
                if (column.equals("issue_status")) {
                    columns.add(issue.getStatusName());
                    continue;
                }
                if (!column.equals("issue_priority")) continue;
                columns.add(issue.getPriorityName());
            }
            this.addCustomFieldValues(adminService, attrs, columns, issue);
            reportWriter.addRow(columns);
        }
    }
}

