/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.software.SoftwareSearch;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SoftwareReport
extends Report {
    private String reportCriteriaMapAttr;

    public SoftwareReport(RequestContext requestContext, String reportCriteriaMapAttr) {
        this.requestContext = requestContext;
        this.reportCriteriaMapAttr = reportCriteriaMapAttr;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getSoftwareReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.software_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "SoftwareSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_SOFTWARE_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        String order;
        List<String> columnKeys = this.computeColumns(ConfigManager.app.getSoftwareExportColumns());
        for (String string : columnKeys) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        Collection<Attribute> attrs = this.computeCustFieldColumns(this.requestContext, ObjectTypes.SOFTWARE);
        for (Attribute attr : attrs) {
            this.getColumnHeaders().add(attr.getName());
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        SoftwareSearch softwareSearch = new SoftwareSearch(this.requestContext, this.reportCriteriaMapAttr);
        String orderBy = this.getReportColumnOrderBy();
        if (orderBy == null) {
            orderBy = SessionManager.getAttribute(this.requestContext.getRequest(), "SOFTWARE_ORDER_BY", "software_name");
        }
        if ((order = this.getReportColumnOrder()) == null) {
            order = SessionManager.getAttribute(this.requestContext.getRequest(), "SOFTWARE_ORDER", "asc");
        }
        QueryCriteria query = new QueryCriteria(softwareSearch);
        if (SoftwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(SoftwareQueries.getOrderByColumn(orderBy), order);
        }
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        for (Software software : softwareService.getSoftwareList(query)) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("software_name")) {
                    columns.add(software.getName());
                    continue;
                }
                if (column.equals("software_version")) {
                    columns.add(software.getVersion());
                    continue;
                }
                if (column.equals("software_expire_date")) {
                    columns.add(DatetimeUtils.toShortDate(software.getExpireDate()));
                    continue;
                }
                if (column.equals("software_description")) {
                    columns.add(software.getDescription());
                    continue;
                }
                if (column.equals("software_owner_username")) {
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, software.getOwner().getId(), software.getOwner().getUsername()));
                    continue;
                }
                if (column.equals("software_owner_display_name")) {
                    columns.add(AdminUtils.getSystemUsername(this.requestContext, software.getOwner().getId(), software.getOwner().getDisplayName()));
                    continue;
                }
                if (column.equals("software_manufacturer")) {
                    columns.add(software.getManufacturerName());
                    continue;
                }
                if (column.equals("software_vendor")) {
                    columns.add(software.getVendorName());
                    continue;
                }
                if (column.equals("software_quoted_oem_price")) {
                    columns.add(software.getQuotedOemPrice());
                    continue;
                }
                if (column.equals("software_quoted_retail_price")) {
                    columns.add(software.getQuotedRetailPrice());
                    continue;
                }
                if (column.equals("license_purchased")) {
                    columns.add(String.valueOf(software.getLicensePurchased()));
                    continue;
                }
                if (column.equals("license_installed")) {
                    columns.add(String.valueOf(software.getLicenseInstalled()));
                    continue;
                }
                if (column.equals("license_available")) {
                    columns.add(String.valueOf(software.getLicenseAvailable()));
                    continue;
                }
                if (column.equals("software_type")) {
                    columns.add(attributeManager.getAttrFieldNameCache(Attributes.SOFTWARE_TYPE, software.getType()));
                    continue;
                }
                if (!column.equals("software_platform")) continue;
                columns.add(attributeManager.getAttrFieldNameCache(Attributes.SOFTWARE_OS, software.getOs()));
            }
            this.addCustomFieldValues(adminService, attrs, columns, software);
            reportWriter.addRow(columns);
        }
    }
}

