/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.types;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.ReportService;
import com.kwoksys.biz.reports.ReportUtils;
import com.kwoksys.biz.reports.dao.ReportQueries;
import com.kwoksys.biz.reports.dto.SoftwareUsage;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.biz.software.SoftwareSearch;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.util.StringUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SoftwareUsageReport
extends Report {
    private String reportCriteriaMapAttr;

    public SoftwareUsageReport(RequestContext requestContext, String reportCriteriaMapAttr) {
        this.requestContext = requestContext;
        this.reportCriteriaMapAttr = reportCriteriaMapAttr;
    }

    @Override
    public String getFilename() {
        String filename = ConfigManager.reports.getSoftwareUsageReportFilename();
        return StringUtils.isEmpty(filename) ? Localizer.getText(this.requestContext, "reports.workflow.type.software_usage_report") : filename;
    }

    @Override
    public String getReportFormName() {
        return "SoftwareSearchForm";
    }

    @Override
    public String getReportPath() {
        return AppPaths.REPORTS_SOFTWARE_USAGE_SEARCH;
    }

    @Override
    public void populateData(ReportWriter reportWriter) throws Exception {
        HttpSession session = this.requestContext.getSession();
        List<String> columnKeys = this.computeColumns(ReportUtils.getSoftwareUsageExportColumns());
        for (String string : columnKeys) {
            this.getColumnHeaders().add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        Collection<Attribute> attrs = this.computeCustFieldColumns(this.requestContext, ObjectTypes.SOFTWARE);
        for (Attribute attr : attrs) {
            this.getColumnHeaders().add(attr.getName());
        }
        reportWriter.addHeaderRow(this.getColumnHeaders());
        SoftwareSearch softwareSearch = new SoftwareSearch();
        if (session.getAttribute(this.reportCriteriaMapAttr) != null) {
            softwareSearch.setSearchCriteriaMap((Map)session.getAttribute(this.reportCriteriaMapAttr));
        }
        QueryCriteria query = new QueryCriteria(softwareSearch);
        query.addSortColumn(ReportQueries.getSoftwareUsageOrderByColumn("software_name"));
        query.addSortColumn(ReportQueries.getSoftwareUsageOrderByColumn("hardware_name"));
        ReportService reportService = ServiceProvider.getReportService(this.requestContext);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        for (SoftwareUsage software : reportService.getSoftwareUsage(query)) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("software_name")) {
                    columns.add(software.getName());
                    continue;
                }
                if (column.equals("software_description")) {
                    columns.add(software.getDescription());
                    continue;
                }
                if (column.equals("software_type")) {
                    columns.add(software.getTypeName());
                    continue;
                }
                if (column.equals("hardware_name")) {
                    columns.add(software.getHardwareName());
                    continue;
                }
                if (!column.equals("hardware_owner_name")) continue;
                columns.add(software.getHardwareOwnerName());
            }
            this.addCustomFieldValues(adminService, attrs, columns, software);
            reportWriter.addRow(columns);
        }
    }
}

