/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.reports.writers;

import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.util.HttpHelper;
import com.kwoksys.framework.util.StringUtils;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.LineSeparator;
import jakarta.servlet.ServletOutputStream;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;

public class PdfReportWriter
extends ReportWriter {
    private ResponseContext responseContext;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private Document document = new Document();
    private Font font = new Font();
    private Font fontHeader = new Font();

    @Override
    public void init(ResponseContext responseContext, Report report) throws Exception {
        this.responseContext = responseContext;
        HttpHelper.setDownloadResponseHeaders(responseContext.getResponse(), responseContext.getAttachementName());
        PdfWriter.getInstance((Document)this.document, (OutputStream)this.baos);
        this.document.open();
        this.fontHeader.setStyle(1);
        if (report.getTitle() != null && !report.getTitle().isEmpty()) {
            this.document.add((Element)new Paragraph(report.getTitle(), this.fontHeader));
            this.document.add((Element)new Paragraph(" "));
        }
    }

    @Override
    public void addHeaderRow(List<String> columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    @Override
    public void addRow(List<String> row) throws Exception {
        for (int i = 0; i < row.size(); ++i) {
            Paragraph para = new Paragraph();
            para.add((Object)new Phrase((String)this.columnHeaders.get(i), this.fontHeader));
            para.add((Object)new Phrase(": " + StringUtils.replaceNull(row.get(i)), this.font));
            this.document.add((Element)para);
        }
        this.document.add((Element)new Paragraph(" "));
        LineSeparator line = new LineSeparator(1.0f, 100.0f, Color.BLACK, 1, 0.0f);
        this.document.add((Element)line);
        this.document.add((Element)new Paragraph(" "));
    }

    @Override
    public String close() throws Exception {
        this.document.close();
        this.responseContext.getResponse().setContentLength(this.baos.size());
        ServletOutputStream out = this.responseContext.getResponse().getOutputStream();
        this.baos.writeTo((OutputStream)out);
        out.flush();
        return null;
    }
}

