/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.rss;

import com.kwoksys.biz.rss.dao.RssDao;
import com.kwoksys.biz.rss.dto.RssFeed;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.parsers.rss.RssModelHelper;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RssService {
    private static final Logger LOGGER = Logger.getLogger(RssService.class.getName());
    private RequestContext requestContext;

    public RssService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<RssFeed> getRssFeeds(QueryCriteria query) throws DatabaseException {
        RssDao rssDao = new RssDao(this.requestContext);
        return rssDao.getRssFeedList(query);
    }

    public RssFeed getRssFeed(Integer feedId) throws DatabaseException, ObjectNotFoundException {
        RssDao rssDao = new RssDao(this.requestContext);
        return rssDao.getRssFeed(feedId);
    }

    public ActionMessages addRssFeed(RssFeed rssFeed) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (rssFeed.getUrl().isEmpty()) {
            errors.add("feedUrl", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "rss.colName.url")));
        } else {
            try {
                RssModelHelper helper = new RssModelHelper();
                helper.urlToModel(rssFeed.getUrl());
                rssFeed.setName(helper.getRssModel().getTitle());
                rssFeed.setItemCount(helper.getRssModel().getCount());
                rssFeed.setCache(helper.getXmlString());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem adding RSS feed.", e);
                errors.add("invalidUrl", new ActionMessage("rss.feedAdd.error.invalidUrl", new Object[]{e.getLocalizedMessage()}));
            }
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        RssDao rssDao = new RssDao(this.requestContext);
        return rssDao.add(rssFeed);
    }

    public ActionMessages updateRssFeed(RssFeed rssFeed) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (rssFeed.getUrl().isEmpty()) {
            errors.add("feedUrl", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "rss.colName.url")));
        }
        if (rssFeed.getName().isEmpty()) {
            errors.add("feedName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "rss.colName.name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        RssDao rssDao = new RssDao(this.requestContext);
        return rssDao.update(rssFeed);
    }

    public ActionMessages updateRssFeedContent(RssFeed rssFeed) throws DatabaseException {
        RssDao rssDao = new RssDao(this.requestContext);
        return rssDao.updateContent(rssFeed);
    }

    public ActionMessages deleteRssFeed(Integer rssFeedId) throws DatabaseException {
        RssDao rssDao = new RssDao(this.requestContext);
        return rssDao.delete(rssFeedId);
    }
}

