/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.rss.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.rss.dao.RssQueries;
import com.kwoksys.biz.rss.dto.RssFeed;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class RssDao
extends BaseDao {
    public RssDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<RssFeed> getRssFeedList(QueryCriteria query) throws DatabaseException {
        final ArrayList<RssFeed> rssFeeds = new ArrayList<RssFeed>();
        QueryHelper queryHelper = new QueryHelper(RssQueries.selectRssFeedListQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                RssFeed rssFeed = new RssFeed();
                rssFeed.setId(rs.getInt("feed_id"));
                rssFeed.setName(StringUtils.replaceNull(rs.getString("feed_name")));
                rssFeed.setUrl(StringUtils.replaceNull(rs.getString("feed_url")));
                rssFeed.setCache(StringUtils.replaceNull(rs.getString("feed_cache")));
                rssFeed.setItemCount(rs.getInt("feed_item_count"));
                rssFeeds.add(rssFeed);
            }
        };
        this.executeQuery(queryHelper);
        return rssFeeds;
    }

    public RssFeed getRssFeed(Integer feedId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList rssFeeds = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(RssQueries.selectRssFeedDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                RssFeed rssFeed = new RssFeed();
                rssFeed.setId(rs.getInt("feed_id"));
                rssFeed.setName(StringUtils.replaceNull(rs.getString("feed_name")));
                rssFeed.setUrl(StringUtils.replaceNull(rs.getString("feed_url")));
                rssFeed.setCache(StringUtils.replaceNull(rs.getString("feed_cache")));
                rssFeed.setCacheDate(DatetimeUtils.getDate(rs, "feed_cache_date"));
                rssFeed.setItemCount(rs.getInt("feed_item_count"));
                rssFeeds.add(rssFeed);
            }
        };
        queryHelper.addInputInt(feedId);
        this.executeQuery(queryHelper);
        if (!rssFeeds.isEmpty()) {
            return (RssFeed)rssFeeds.get(0);
        }
        throw new ObjectNotFoundException("RSS Feed ID: " + feedId);
    }

    public ActionMessages add(RssFeed rssFeed) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(RssQueries.insertRssFeedQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(rssFeed.getUrl());
        queryHelper.addInputStringConvertNull(rssFeed.getName());
        queryHelper.addInputInt(rssFeed.getItemCount());
        queryHelper.addInputStringConvertNull(rssFeed.getCache());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            rssFeed.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages update(RssFeed rssFeed) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(RssQueries.updateRssFeedQuery());
        queryHelper.addInputInt(rssFeed.getId());
        queryHelper.addInputStringConvertNull(rssFeed.getUrl());
        queryHelper.addInputStringConvertNull(rssFeed.getName());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages updateContent(RssFeed rssFeed) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(RssQueries.updateRssFeedCacheQuery());
        queryHelper.addInputInt(rssFeed.getId());
        queryHelper.addInputInt(rssFeed.getItemCount());
        queryHelper.addInputStringConvertNull(rssFeed.getCache());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages delete(Integer feedId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(RssQueries.deleteRssFeedQuery());
        queryHelper.addInputInt(feedId);
        return this.executeProcedure(queryHelper);
    }
}

