/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.software;

import com.kwoksys.action.software.SoftwareSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;
import java.util.List;

public class SoftwareSearch
extends BaseSearch {
    public static final String SOFTWARE_ID_EQUALS = "softwareIdEquals";
    public static final String SOFTWARE_TYPES_CONTAIN = "softwareTypesContain";

    public SoftwareSearch(RequestContext requestContext, String sessionKey) {
        super(requestContext, sessionKey);
    }

    public SoftwareSearch() {
    }

    public void prepareMap(SoftwareSearchForm softwareSearchForm) {
        String cmd = this.requestContext.getParameterString("cmd");
        if (!cmd.isEmpty()) {
            this.reset();
            if (cmd.equals("filter")) {
                String manufacturerId = this.requestContext.getParameterString("manufacturerIdFilter");
                if (!manufacturerId.isEmpty()) {
                    softwareSearchForm.setManufacturerIdFilter(manufacturerId);
                    this.searchCriteriaMap.put("manufacturerIdEquals", manufacturerId);
                }
            } else {
                softwareSearchForm.setRequest(this.requestContext);
                if (cmd.equals("search")) {
                    List<Integer> typeList;
                    if (!softwareSearchForm.getManufacturerId().isEmpty()) {
                        this.searchCriteriaMap.put("manufacturerIdEquals", softwareSearchForm.getManufacturerId());
                    }
                    if (!softwareSearchForm.getSoftwareId().isEmpty()) {
                        this.searchCriteriaMap.put(SOFTWARE_ID_EQUALS, softwareSearchForm.getSoftwareId());
                    }
                    if (!(typeList = softwareSearchForm.getSoftwareTypes()).isEmpty()) {
                        this.searchCriteriaMap.put(SOFTWARE_TYPES_CONTAIN, typeList);
                    }
                    if (!softwareSearchForm.getAttrId().isEmpty() && !softwareSearchForm.getAttrValue().isEmpty()) {
                        this.searchCriteriaMap.put("attrId", softwareSearchForm.getAttrId());
                        this.searchCriteriaMap.put("attrValue", softwareSearchForm.getAttrValue());
                    }
                }
            }
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey("manufacturerIdEquals")) {
            query.appendWhereClause("s.manufacturer_company_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("manufacturerIdEquals")));
        }
        if (this.searchCriteriaMap.containsKey(SOFTWARE_ID_EQUALS)) {
            query.appendWhereClause("s.software_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(SOFTWARE_ID_EQUALS)));
        }
        if (this.searchCriteriaMap.containsKey(SOFTWARE_TYPES_CONTAIN)) {
            query.appendWhereClause("s.software_type in (" + SqlUtils.encodeIntegers((List)this.searchCriteriaMap.get(SOFTWARE_TYPES_CONTAIN)) + ")");
        }
        if (this.searchCriteriaMap.containsKey("attrId") && this.searchCriteriaMap.containsKey("attrValue")) {
            query.appendWhereClause("s.software_id in (select object_id from object_attribute_value where attribute_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("attrId")) + " and lower(attr_value) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("attrValue")) + "%'))");
        }
    }
}

