/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.software;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.software.dao.SoftwareDao;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.software.dto.SoftwareBookmark;
import com.kwoksys.biz.software.dto.SoftwareLicense;
import com.kwoksys.biz.system.BookmarkService;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Bookmark;
import com.kwoksys.biz.system.dto.linking.ContractSoftwareLink;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.biz.system.dto.linking.SoftwareContactLink;
import com.kwoksys.biz.system.dto.linking.SoftwareIssueLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.List;
import java.util.Map;

public class SoftwareService {
    private RequestContext requestContext;

    public SoftwareService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Software> getSoftwareList(QueryCriteria queryCriteria) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getSoftwareList(queryCriteria);
    }

    public List<Software> getLinkedSoftwareList(QueryCriteria queryCriteria, ObjectLink objectMap) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getLinkedSoftwareList(queryCriteria, objectMap);
    }

    public int getSoftwareCount(QueryCriteria queryCriteria) throws DatabaseException {
        return new SoftwareDao(this.requestContext).getCount(queryCriteria);
    }

    public Software getSoftware(Integer softwareId) throws DatabaseException, ObjectNotFoundException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getSoftware(softwareId);
    }

    public List<Map<String, String>> getCompanySoftwareList(QueryCriteria queryCriteria, Integer companyId) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getCompanySoftwareList(queryCriteria, companyId);
    }

    public List<Map<String, String>> getSoftwareCountGroupByCompany(QueryCriteria queryCriteria) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getSoftwareCountGroupByCompany(queryCriteria);
    }

    public ActionMessages addSoftware(Software software, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("softwareName").setTitleKey("common.column.software_name").setNullable(false).calculateLength(software.getName()).setColumnName("asset_software.software_name"));
        if (software.hasExpireDate() && !software.isValidExpireDate()) {
            errors.add("invalidExpireDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.software_expire_date")));
        }
        validator.validateAttrs(software, software.getType(), customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.add(software);
    }

    public ActionMessages updateSoftware(Software software, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("softwareName").setTitleKey("common.column.software_name").setNullable(false).calculateLength(software.getName()).setColumnName("asset_software.software_name"));
        if (software.hasExpireDate() && !software.isValidExpireDate()) {
            errors.add("invalidExpireDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.software_expire_date")));
        }
        validator.validateAttrs(software, software.getType(), customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.update(software);
    }

    public ActionMessages deleteSoftware(Software software) throws DatabaseException {
        List<File> deleteFileList = this.getSoftwareFiles(new QueryCriteria(), software.getId());
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        ActionMessages errors = softwareDao.delete(software);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (errors.isEmpty()) {
            fileService.bulkDelete(ConfigManager.file.getSoftwareFileRepositoryLocation(), deleteFileList);
        }
        return errors;
    }

    public List<Map<String, String>> getSoftwareLicenses(QueryCriteria query, Integer softwareId) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getLicenseList(query, softwareId);
    }

    public SoftwareLicense getSoftwareLicense(Integer softwareId, Integer licenseId) throws DatabaseException, ObjectNotFoundException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getSoftwareLicense(softwareId, licenseId);
    }

    public Map<String, String> getSoftwareLicenseCount(Integer softwareId) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getSoftwareLicenseCount(softwareId);
    }

    public List<Map<String, String>> getSoftwareLicenseHardwareList(QueryCriteria query, Integer softwareId) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.getSoftwareLicenseHardwareList(query, softwareId);
    }

    public ActionMessages addLicense(SoftwareLicense license, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (license.getKey().isEmpty()) {
            errors.add("licenseKey", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.license_key")));
        }
        if (!license.isCorrectLicenseEntitlementFormat()) {
            errors.add("licenseEntitlement", new ActionMessage("itMgmt.softwareDetail.error.emptyLicenseEntitlement"));
        }
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validateAttrs(license, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.addLicense(this.requestContext, license);
    }

    public ActionMessages updateLicense(SoftwareLicense license, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (license.getKey().isEmpty()) {
            errors.add("licenseKey", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.license_key")));
        }
        if (!license.isCorrectLicenseEntitlementFormat()) {
            errors.add("licenseEntitlement", new ActionMessage("itMgmt.softwareDetail.error.emptyLicenseEntitlement"));
        }
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validateAttrs(license, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.updateLicense(this.requestContext, license);
    }

    public ActionMessages deleteLicense(SoftwareLicense license) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (license.getId() == 0) {
            errors.add("emptySoftwareLicenseId", new ActionMessage("itMgmt.softwareDetail.error.emptySoftwareLicenseId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.deleteLicense(license);
    }

    public ActionMessages resetSoftwareLicenseCount(SoftwareLicense license) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.resetSoftwareLicenseCount(license);
    }

    public List<File> getSoftwareFiles(QueryCriteria query, Integer softwareId) throws DatabaseException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        return fileService.getFiles(query, ObjectTypes.SOFTWARE, softwareId);
    }

    public ActionMessages resetSoftwareFileCount(Integer softwareId) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.resetFileCount(softwareId);
    }

    public File getSoftwareFile(Integer softwareId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        File file = fileService.getFile(ObjectTypes.SOFTWARE, softwareId, fileId);
        file.setConfigRepositoryPath(ConfigManager.file.getSoftwareFileRepositoryLocation());
        file.setConfigUploadedFilePrefix(ConfigManager.file.getSoftwareUploadedFilePrefix());
        return file;
    }

    public List<Bookmark> getSoftwareBookmarks(QueryCriteria query, Integer softwareId) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.getBookmarks(query, ObjectTypes.SOFTWARE, softwareId);
    }

    public Bookmark getSoftwareBookmark(Integer softwareId, Integer bookmarkId) throws DatabaseException, ObjectNotFoundException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.getBookmark(ObjectTypes.SOFTWARE, softwareId, bookmarkId);
    }

    public ActionMessages addSoftwareBookmark(SoftwareBookmark bookmark) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.addBookmark(bookmark);
    }

    public ActionMessages updateSoftwareBookmark(Bookmark bookmark) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.updateBookmark(bookmark);
    }

    public ActionMessages deleteSoftwareBookmark(Bookmark bookmark) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.deleteBookmark(bookmark);
    }

    public ActionMessages resetSoftwareBookmarkCount(Integer softwareId) throws DatabaseException {
        SoftwareDao softwareDao = new SoftwareDao(this.requestContext);
        return softwareDao.resetBookmarkCount(softwareId);
    }

    public ActionMessages addSoftwareIssue(SoftwareIssueLink softwareIssue) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(softwareIssue.createObjectMap());
    }

    public ActionMessages deleteSoftwareIssue(SoftwareIssueLink softwareIssue) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(softwareIssue.createObjectMap());
    }

    public List<Contact> getSoftwareContacts(QueryCriteria query, Integer softwareId) throws DatabaseException {
        SoftwareContactLink contactLink = new SoftwareContactLink();
        contactLink.setSoftwareId(softwareId);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        return contactService.getLinkedContacts(query, contactLink.createObjectMap());
    }

    public ActionMessages addSoftwareContact(SoftwareContactLink softwareContact) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(softwareContact.createObjectMap());
    }

    public ActionMessages deleteSoftwareContact(SoftwareContactLink softwareContact) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(softwareContact.createObjectMap());
    }

    public void fetchSoftwareContracts(QueryCriteria queryCriteria, Integer softwareId) throws DatabaseException {
        ContractSoftwareLink contractMap = new ContractSoftwareLink();
        contractMap.setSoftwareId(softwareId);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        contractService.fetchLinkedContracts(queryCriteria, contractMap.createObjectMap());
    }
}

