/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.software;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SoftwareUtils {
    public static final String DETAILS_TAB = "detailsTab";
    public static final String BOOKMARKS_TAB = "bookmarksTab";
    public static final String ISSUES_TAB = "issuesTab";
    public static final String CONTACTS_TAB = "contactsTab";
    public static final String FILES_TAB = "filesTab";
    public static final String[] SOFTWARE_DEFAULT_COLUMNS = new String[]{"rownum", "software_name", "software_description", "software_version", "software_expire_date", "software_manufacturer", "software_vendor", "software_type", "software_platform", "license_purchased", "license_installed", "license_available"};

    public static List<String> getSortableColumns() {
        return Arrays.asList("software_name", "software_version", "software_expire_date", "software_manufacturer", "software_vendor", "software_type", "software_platform", "license_purchased", "license_installed", "license_available");
    }

    public static boolean isSortableColumn(String columnName) {
        return SoftwareUtils.getSortableColumns().contains(columnName);
    }

    public static List<String> getColumnHeaderList() {
        return ConfigManager.app.getSoftwareColumns();
    }

    public static String formatLicenseKey(String input) {
        if (input == null) {
            return "";
        }
        int carriageReturn = input.indexOf("\n");
        if (carriageReturn != -1) {
            return HtmlUtils.encode(input.substring(0, carriageReturn)) + "...";
        }
        int notesNumChar = ConfigManager.app.getSoftwareLicenseNotesNumChars();
        if (notesNumChar != 0 && input.length() > notesNumChar) {
            return HtmlUtils.encode(input.substring(0, notesNumChar) + "...");
        }
        return HtmlUtils.encode(input);
    }

    public static String formatLicenseKey(RequestContext requestContext, String input, int charCount, Integer id) {
        if (input == null) {
            return "";
        }
        if (charCount != 0 && input.length() > charCount) {
            Link link = new Link(requestContext);
            link.setEscapeTitle("&raquo;");
            link.setJavascript("Js.Display.toggle('licDiv_" + id + "');");
            return HtmlUtils.formatMultiLineDisplay(input.substring(0, charCount)) + "<span style='display:none;' id=\"licDiv_" + id + "\">" + HtmlUtils.formatMultiLineDisplay(input.substring(charCount)) + "</span> " + link.getString();
        }
        return HtmlUtils.formatMultiLineDisplay(input);
    }

    public static List<Link> getSoftwareTabs(RequestContext requestContext, Software software) throws Exception {
        AccessUser user = requestContext.getUser();
        ArrayList<Link> links = new ArrayList<Link>();
        if (user.hasPermission(AppPaths.SOFTWARE_DETAIL)) {
            links.add(new Link(requestContext).setName(DETAILS_TAB).setAppPath(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId()).setTitle(Localizer.getText(requestContext, "itMgmt.tab.softwareLicense", new Object[]{software.getCountLicense()})));
        }
        if (user.hasPermission(AppPaths.SOFTWARE_FILE)) {
            links.add(new Link(requestContext).setName(FILES_TAB).setAjaxPath(AppPaths.SOFTWARE_FILE + "?softwareId=" + software.getId()).setTitle(Localizer.getText(requestContext, "itMgmt.tab.softwareFile", new Object[]{software.getCountFile()})));
        }
        if (user.hasPermission(AppPaths.SOFTWARE_BOOKMARK)) {
            links.add(new Link(requestContext).setName(BOOKMARKS_TAB).setAppPath(AppPaths.SOFTWARE_BOOKMARK + "?softwareId=" + software.getId()).setTitle(Localizer.getText(requestContext, "itMgmt.tab.softwareBookmark", new Object[]{software.getCountBookmark()})));
        }
        if (user.hasPermission(AppPaths.SOFTWARE_ISSUE)) {
            links.add(new Link(requestContext).setName(ISSUES_TAB).setAppPath(AppPaths.SOFTWARE_ISSUE + "?softwareId=" + software.getId()).setTitleKey("itMgmt.tab.softwareIssue"));
        }
        if (user.hasPermission(AppPaths.SOFTWARE_CONTACTS)) {
            SystemService systemService = ServiceProvider.getSystemService(requestContext);
            List<Integer> linkedTypes = Arrays.asList(ObjectTypes.CONTACT);
            int relationshipCount = systemService.getLinkedObjectMapCount(linkedTypes, software.getId(), ObjectTypes.SOFTWARE);
            links.add(new Link(requestContext).setName(CONTACTS_TAB).setAppPath(AppPaths.SOFTWARE_CONTACTS + "?softwareId=" + software.getId()).setTitle(Localizer.getText(requestContext, "common.linking.tab.linkedContacts", new Object[]{relationshipCount})));
        }
        return links;
    }

    public static List<DataRow> formatSoftwareList(RequestContext requestContext, List<Software> softwareDataset, Counter counter) throws Exception {
        ArrayList<DataRow> softwareList = new ArrayList<DataRow>();
        if (softwareDataset == null) {
            return softwareList;
        }
        AccessUser user = requestContext.getUser();
        boolean hasSoftwareAccess = user.hasPermission(AppPaths.SOFTWARE_DETAIL);
        boolean hasCompanyAccess = user.hasPermission(AppPaths.CONTACTS_COMPANY_DETAIL);
        AttributeManager attributeManager = new AttributeManager(requestContext);
        for (Software software : softwareDataset) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : SoftwareUtils.getColumnHeaderList()) {
                if (column.equals("rownum")) {
                    columns.add(counter.incr() + ".");
                    continue;
                }
                if (column.equals("software_name")) {
                    Link softwareLink = new Link(requestContext);
                    softwareLink.setTitle(software.getName());
                    if (hasSoftwareAccess) {
                        softwareLink.setAjaxPath(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId());
                    }
                    columns.add(softwareLink.getString());
                    continue;
                }
                if (column.equals("software_description")) {
                    columns.add(HtmlUtils.formatMultiLineDisplay(software.getDescription()));
                    continue;
                }
                if (column.equals("software_version")) {
                    columns.add(HtmlUtils.encode(software.getVersion()));
                    continue;
                }
                if (column.equals("software_expire_date")) {
                    columns.add(DatetimeUtils.toShortDate(software.getExpireDate()));
                    continue;
                }
                if (column.equals("software_type")) {
                    columns.add(HtmlUtils.encode(software.getTypeName()));
                    continue;
                }
                if (column.equals("software_platform")) {
                    AttributeField attrField = attributeManager.getAttrFieldMapCache(Attributes.SOFTWARE_OS).get(software.getOs());
                    columns.add(Links.getAttrFieldIcon(requestContext, attrField).getString());
                    continue;
                }
                if (column.equals("software_manufacturer")) {
                    columns.add(Links.getCompanyDetailsLink(requestContext, hasCompanyAccess, software.getManufacturerName(), software.getManufacturerId()).getString());
                    continue;
                }
                if (column.equals("software_vendor")) {
                    columns.add(Links.getCompanyDetailsLink(requestContext, hasCompanyAccess, software.getVendorName(), software.getVendorId()).getString());
                    continue;
                }
                if (column.equals("license_available")) {
                    if (!Software.isEnoughLicenses(software.getLicenseAvailable())) {
                        Object[] args = new Object[]{software.getLicenseAvailable()};
                        columns.add(Localizer.getText(requestContext, "itMgmt.softwareList.licenseOut", args));
                        continue;
                    }
                    columns.add(String.valueOf(software.getLicenseAvailable()));
                    continue;
                }
                if (column.equals("license_purchased")) {
                    columns.add(String.valueOf(software.getLicensePurchased()));
                    continue;
                }
                if (!column.equals("license_installed")) continue;
                columns.add(String.valueOf(software.getLicenseInstalled()));
            }
            DataRow dataRow = new DataRow();
            dataRow.setRowId(String.valueOf(software.getId()));
            dataRow.setColumns(columns);
            softwareList.add(dataRow);
        }
        return softwareList;
    }

    public static void addSoftwareHeaderCommands(RequestContext requestContext, HeaderTemplate headerTemplate, Integer softwareId) throws Exception {
        Link link;
        AccessUser accessUser = requestContext.getUser();
        if (accessUser.hasPermission(AppPaths.SOFTWARE_EDIT)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_EDIT + "?softwareId=" + softwareId);
            link.setTitleKey("itMgmt.cmd.softwareEdit");
            headerTemplate.addHeaderCmds(link);
        }
        if (accessUser.hasPermission(AppPaths.SOFTWARE_DELETE)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_DELETE + "?softwareId=" + softwareId);
            link.setTitleKey("itMgmt.cmd.softwareLicenseDelete");
            headerTemplate.addHeaderCmds(link);
        }
        if (accessUser.hasPermission(AppPaths.SOFTWARE_LIST)) {
            link = new Link(requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_LIST);
            link.setTitleKey("itMgmt.cmd.softwareList");
            headerTemplate.addHeaderCmds(link);
        }
    }
}

