/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.software.dao;

import com.kwoksys.framework.connections.database.QueryCriteria;

public class SoftwareQueries {
    public static String getOrderByColumn(String column) {
        if (column.equals("software_name")) {
            return "lower(software_name)";
        }
        if (column.equals("software_version")) {
            return "lower(software_version)";
        }
        if (column.equals("software_manufacturer")) {
            return "lower(mftr.company_name)";
        }
        if (column.equals("license_key")) {
            return "lower(license_key)";
        }
        if (column.equals("hardware_name")) {
            return "lower(hardware_name)";
        }
        return column;
    }

    public static String selectSoftwareLicenseCountQuery() {
        return "select license_id, count(license_id) as license_id_count from asset_map where software_id =?  group by license_id";
    }

    public static String selectSoftwareListQuery(QueryCriteria query) {
        return "select s.software_id, s.software_name, s.software_version, s.software_expire_date, s.software_description, s.quoted_retail_price, s.quoted_oem_price, s.software_owner_id, s.software_owner_username, s.software_owner_display_name, s.software_type as software_type_id, st.attribute_field_name as software_type, s.operating_system as software_platform_id, sp.attribute_field_name as software_platform, s.manufacturer_company_id, mftr.company_name as software_manufacturer, s.vendor_company_id, vndr.company_name as software_vendor, coalesce(lp.purchased,0) as license_purchased, coalesce(li.installed,0) as license_installed, (coalesce(lp.purchased,0)-coalesce(li.installed,0)) as license_available from asset_software_view s left outer join company mftr on s.manufacturer_company_id = mftr.company_id left outer join company vndr on s.vendor_company_id = vndr.company_id left outer join (select software_id, sum(license_entitlement) as purchased from asset_software_licenses group by software_id) lp on s.software_id = lp.software_id left outer join (select software_id, sum(license_entitlement) as installed from asset_map group by software_id) li on s.software_id = li.software_id left outer join attribute_field_view st on st.attribute_field_id = s.software_type left outer join attribute_field_view sp on sp.attribute_field_id = s.operating_system  " + query.createWhereClause();
    }

    public static String selectLinkedSoftwareListQuery(QueryCriteria query) {
        return SoftwareQueries.selectSoftwareListQuery(new QueryCriteria()) + "where s.software_id in (select om.linked_object_id from object_map om where om.object_id=? and om.object_type_id=? and om.linked_object_type_id=?) " + query.createWhereClause();
    }

    public static String selectObjectSoftwareListQuery(QueryCriteria query) {
        return SoftwareQueries.selectSoftwareListQuery(new QueryCriteria()) + "where s.software_id in (select om.object_id from object_map om where om.linked_object_id=? and om.linked_object_type_id=? and om.object_type_id=?) " + query.createAndClause();
    }

    public static String getSoftwareCountQuery(QueryCriteria query) {
        return "select count(s.software_id) as row_count from asset_software s " + query.createWhereCountClause();
    }

    public static String selectSoftwareDetailQuery() {
        return "select s.software_id, s.software_name, s.software_description, s.software_owner_id, s.software_owner_username, s.software_owner_display_name, s.software_type, s.operating_system as software_platform, s.quoted_retail_price, s.quoted_oem_price, s.software_version, s.software_expire_date, s.manufacturer_company_id, mftr.company_name as software_manufacturer, s.vendor_company_id, vndr.company_name as software_vendor, coalesce(lp.purchased,0) as license_purchased, coalesce(li.installed,0) as license_installed, (coalesce(lp.purchased,0)-coalesce(li.installed,0)) as license_available, s.license_count, s.file_count, s.bookmark_count, s.creator, s.creation_date, s.creator_username, s.creator_display_name, s.modifier, s.modification_date, s.modifier_username, s.modifier_display_name from (select sum(license_entitlement) as installed from asset_map where software_id = ?) li, (select sum(license_entitlement) as purchased from asset_software_licenses where software_id = ?) lp, asset_software_view s left outer join company mftr on s.manufacturer_company_id = mftr.company_id left outer join company vndr on s.vendor_company_id = vndr.company_id where s.software_id = ?";
    }

    public static String selectSoftwareLicenseListQuery(QueryCriteria query) {
        return "select asl.software_id, asl.license_id, asl.license_key, asl.license_note, asl.license_entitlement, ahm.hardware_id, ahm.hardware_name, ahm.hardware_owner from asset_software_licenses asl left outer join (select am.software_id, am.license_id, ah.hardware_id, ah.hardware_name, ah.hardware_owner from asset_map am, asset_hardware ah where am.hardware_id = ah.hardware_id and am.software_id =?) ahm on asl.license_id = ahm.license_id where asl.software_id =? " + query.createAndClause();
    }

    public static String selectSoftwareLicense() {
        return "select asl.license_id, asl.license_key, asl.license_note, asl.license_entitlement from asset_software_licenses asl where asl.software_id =? and asl.license_id =?";
    }

    public static String selectSoftwareLicenseHardwareListQuery(QueryCriteria query) {
        return "select ah.hardware_id, ah.hardware_name from asset_map am, asset_hardware ah where am.hardware_id = ah.hardware_id and am.software_id =? and am.license_id not in (select distinct(license_id) from asset_software_licenses where software_id =?)" + query.createAndClause();
    }

    public static String selectSoftwareCountGroupByCompanyQuery(QueryCriteria query) {
        return "select s.manufacturer_company_id, mftr.company_name as software_manufacturer, count(s.software_id) as software_count from asset_software s left outer join company mftr on s.manufacturer_company_id = mftr.company_id group by s.manufacturer_company_id, mftr.company_name " + query.createClause();
    }

    public static String selectCompanySoftwareQuery(QueryCriteria query) {
        return "select s.software_id, s.software_name from asset_software s where s.manufacturer_company_id = ? " + query.createAndClause();
    }

    public static String insertSoftwareQuery() {
        return "{call sp_software_add(?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    }

    public static String updateSoftwareQuery() {
        return "{call sp_software_update(?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    }

    public static String deleteSoftwareQuery() {
        return "{call sp_software_delete(?,?)}";
    }

    public static String insertSoftwareLicenseQuery() {
        return "{call sp_software_license_add(?,?,?,?,?,?)}";
    }

    public static String updateSoftwareLicenseQuery() {
        return "{call sp_software_license_update(?,?,?,?,?,?)}";
    }

    public static String deleteSoftwareLicenseQuery() {
        return "{call sp_software_license_delete(?,?,?)}";
    }

    public static String updateSoftwareLicenseCountQuery() {
        return "{call sp_software_count_license_update(?)}";
    }

    public static String updateSoftwareBookmarkCountQuery() {
        return "{call sp_software_count_bookmark_update(?,?)}";
    }

    public static String updateSoftwareFileCountQuery() {
        return "{call sp_software_count_file_update(?,?)}";
    }
}

