/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.software.dto;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.Date;

public class Software
extends BaseObject {
    public static final String NAME = "software_name";
    public static final String DESCRIPTION = "software_description";
    public static final String OWNER_USERNAME = "software_owner_username";
    public static final String OWNER_DISPLAY_NAME = "software_owner_display_name";
    public static final String VERSION = "software_version";
    public static final String CONTRACT_PROVIDER_ID = "contract_provider_id";
    public static final String MANUFACTURER = "software_manufacturer";
    public static final String VENDOR = "software_vendor";
    public static final String TYPE = "software_type";
    public static final String OS = "software_platform";
    public static final String QUOTED_RETAIL_PRICE = "software_quoted_retail_price";
    public static final String QUOTED_OEM_PRICE = "software_quoted_oem_price";
    public static final String EXPIRE_DATE = "software_expire_date";
    public static final String LICENSE_PUCHASED = "license_purchased";
    public static final String LICENSE_INSTALLED = "license_installed";
    public static final String LICENSE_AVAILABLE = "license_available";
    private String name;
    private String description;
    private AccessUser owner;
    private Integer ownerId;
    private Integer type = 0;
    private String typeName;
    private String version;
    private Integer os = 0;
    private String osName;
    private String quotedRetailPrice;
    private String quotedOemPrice;
    private Integer manufacturerId = 0;
    private String manufacturerName;
    private Integer vendorId = 0;
    private String vendorName;
    private Date expireDate;
    private String expireDateY = "";
    private String expireDateM = "";
    private String expireDateD = "";
    private int countLicense;
    private int countFile;
    private int countBookmark;
    private int licensePurchased = 0;
    private int licenseInstalled = 0;
    private int licenseAvailable = 0;
    private Integer fileId = 0;

    public Software() {
        super(ObjectTypes.SOFTWARE);
    }

    public static boolean isEnoughLicenses(Object numLicenses) {
        return Integer.parseInt(numLicenses.toString()) >= 0;
    }

    @Override
    public boolean isAttrEmpty(String attrName) {
        if (attrName.equals(OS)) {
            return this.os == 0;
        }
        if (attrName.equals(TYPE)) {
            return this.type == 0;
        }
        return false;
    }

    public boolean isValidExpireDate() {
        return DatetimeUtils.isValidDate(this.expireDateY, this.expireDateM, this.expireDateD);
    }

    public boolean hasExpireDate() {
        return !this.expireDateY.isEmpty() || !this.expireDateM.isEmpty() || !this.expireDateD.isEmpty();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setOs(Integer os) {
        this.os = os;
    }

    public void setQuotedRetailPrice(String quotedRetailPrice) {
        this.quotedRetailPrice = quotedRetailPrice;
    }

    public void setQuotedOemPrice(String quotedOemPrice) {
        this.quotedOemPrice = quotedOemPrice;
    }

    public void setManufacturerId(Integer manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public void setVendorId(Integer vendorId) {
        this.vendorId = vendorId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getOs() {
        return this.os;
    }

    public String getQuotedRetailPrice() {
        return this.quotedRetailPrice;
    }

    public String getQuotedOemPrice() {
        return this.quotedOemPrice;
    }

    public Integer getManufacturerId() {
        return this.manufacturerId;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public int getLicensePurchased() {
        return this.licensePurchased;
    }

    public int getLicenseInstalled() {
        return this.licenseInstalled;
    }

    public int getLicenseAvailable() {
        return this.licenseAvailable;
    }

    public Integer getVendorId() {
        return this.vendorId;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public int getCountLicense() {
        return this.countLicense;
    }

    public int getCountFile() {
        return this.countFile;
    }

    public int getCountBookmark() {
        return this.countBookmark;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setCountLicense(int countLicense) {
        this.countLicense = countLicense;
    }

    public void setCountFile(int countFile) {
        this.countFile = countFile;
    }

    public void setCountBookmark(int countBookmark) {
        this.countBookmark = countBookmark;
    }

    public void setLicensePurchased(int licensePurchased) {
        this.licensePurchased = licensePurchased;
    }

    public void setLicenseInstalled(int licenseInstalled) {
        this.licenseInstalled = licenseInstalled;
    }

    public void setLicenseAvailable(int licenseAvailable) {
        this.licenseAvailable = licenseAvailable;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public AccessUser getOwner() {
        return this.owner;
    }

    public void setOwner(AccessUser owner) {
        this.owner = owner;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public String getExpireDateY() {
        return this.expireDateY;
    }

    public void setExpireDateY(String expireDateY) {
        this.expireDateY = expireDateY;
    }

    public String getExpireDateM() {
        return this.expireDateM;
    }

    public void setExpireDateM(String expireDateM) {
        this.expireDateM = expireDateM;
    }

    public String getExpireDateD() {
        return this.expireDateD;
    }

    public void setExpireDateD(String expireDateD) {
        this.expireDateD = expireDateD;
    }
}

