/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system;

import com.kwoksys.biz.system.dao.BookmarkDao;
import com.kwoksys.biz.system.dto.Bookmark;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.List;

public class BookmarkService {
    private RequestContext requestContext;

    public BookmarkService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Bookmark> getBookmarks(QueryCriteria query, Integer objectTypeId, Integer objectId) throws DatabaseException {
        BookmarkDao bookmarkDao = new BookmarkDao(this.requestContext);
        return bookmarkDao.getBookmarks(query, objectTypeId, objectId);
    }

    public Bookmark getBookmark(Integer objectTypeId, Integer objectId, Integer bookmarkId) throws DatabaseException, ObjectNotFoundException {
        BookmarkDao bookmarkDao = new BookmarkDao(this.requestContext);
        return bookmarkDao.getBookmark(objectTypeId, objectId, bookmarkId);
    }

    public ActionMessages addBookmark(Bookmark bookmark) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (bookmark.getName().isEmpty()) {
            errors.add("bookmarkName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.bookmark_name")));
        }
        if (bookmark.getPath().isEmpty()) {
            errors.add("bookmarkPath", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.bookmark_path")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        BookmarkDao bookmarkDao = new BookmarkDao(this.requestContext);
        return bookmarkDao.add(bookmark);
    }

    public ActionMessages updateBookmark(Bookmark bookmark) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (bookmark.getName().isEmpty()) {
            errors.add("bookmarkName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.bookmark_name")));
        }
        if (bookmark.getPath().isEmpty()) {
            errors.add("bookmarkPath", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.bookmark_path")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        BookmarkDao bookmarkDao = new BookmarkDao(this.requestContext);
        return bookmarkDao.update(bookmark);
    }

    public ActionMessages deleteBookmark(Bookmark bookmark) throws DatabaseException {
        BookmarkDao bookmarkDao = new BookmarkDao(this.requestContext);
        return bookmarkDao.delete(bookmark);
    }
}

