/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system;

import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.Date;

public class SystemUtils {
    public static String formatExpirationDateHtml(RequestContext requestContext, Date currentDate, Date expirationDate, int expirationCountdown) {
        String expireDateString = "";
        long daysLimit = (long)expirationCountdown * 86400000L;
        if (expirationDate != null) {
            long diff = expirationDate.getTime() - (currentDate.getTime() + (long)DatetimeUtils.getTimeOffsetMs(currentDate));
            expireDateString = DatetimeUtils.toShortDate(expirationDate);
            if (diff <= daysLimit) {
                expireDateString = diff > 0L && diff < 86400000L ? expireDateString + "<span class=\"expiredDate\"> (" + Localizer.getText(requestContext, "contracts.expiration.counter.lessThanOne") + ")</span>" : (diff > 0L ? expireDateString + "<span class=\"expiredDate\"> (" + Localizer.getText(requestContext, "contracts.expiration.counter.oneOrMore", new Object[]{diff / 86400000L}) + ")</span>" : expireDateString + "<span class=\"red\"> (" + Localizer.getText(requestContext, "itMgmt.contractList.contract_expiration_date.expired") + ")</span>");
            }
        }
        return expireDateString;
    }

    public static String formatExpirationDateText(RequestContext requestContext, Date currentDate, Date expirationDate, int expirationCountdown) {
        String expireDateString = "";
        long daysLimit = (long)expirationCountdown * 86400000L;
        if (expirationDate != null) {
            long diff = expirationDate.getTime() - (currentDate.getTime() + (long)DatetimeUtils.getTimeOffsetMs(currentDate));
            expireDateString = DatetimeUtils.toShortDate(expirationDate);
            if (diff <= daysLimit) {
                expireDateString = diff > 0L && diff < 86400000L ? expireDateString + " (" + Localizer.getText(requestContext, "contracts.expiration.counter.lessThanOne") + ")" : (diff > 0L ? expireDateString + " (" + Localizer.getText(requestContext, "contracts.expiration.counter.oneOrMore", new Object[]{diff / 86400000L}) + ")" : expireDateString + " (" + Localizer.getText(requestContext, "itMgmt.contractList.contract_expiration_date.expired") + ")");
            }
        }
        return expireDateString;
    }
}

