/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeValue;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.base.BaseObjectForm;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AttributeManager {
    private List<Integer> selectedAttrFieldIds = new ArrayList<Integer>();
    private boolean isOptional = false;
    private boolean hideDisabledAttr = false;
    private RequestContext requestContext;

    public AttributeManager(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public static List<LabelValueBean> getAttrDataTypeOptions(RequestContext requestContext) {
        ArrayList<LabelValueBean> attrTypeOptions = new ArrayList<LabelValueBean>();
        for (Integer option : Attribute.ATTR_TYPE_OPTION_LIST) {
            attrTypeOptions.add(new LabelValueBean(Localizer.getText(requestContext, "admin.attribute.attribute_type." + option), String.valueOf(option)));
        }
        return attrTypeOptions;
    }

    public Map<Integer, AttributeField> getAttrFieldMapCache(Integer attributeId) throws DatabaseException {
        return new CacheManager(this.requestContext).getAttributeFieldsCache(attributeId);
    }

    public Map<String, AttributeField> getAttrNameMapCache(Integer attributeId) throws DatabaseException {
        HashMap<String, AttributeField> map = new HashMap<String, AttributeField>();
        for (AttributeField attrField : this.getAttrFieldMapCache(attributeId).values()) {
            map.put(attrField.getName().toLowerCase(), attrField);
        }
        return map;
    }

    public List<LabelValueBean> getAttrFieldOptionsCache(Integer attributeId) throws DatabaseException {
        ArrayList<LabelValueBean> options = new ArrayList<LabelValueBean>();
        if (this.isOptional) {
            options.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        }
        for (AttributeField attrField : this.getAttrFieldMapCache(attributeId).values()) {
            if (this.hideDisabledAttr && attrField.isDisabled() && !this.selectedAttrFieldIds.contains(attrField.getId())) continue;
            options.add(new LabelValueBean(AttributeManager.getAttrFieldName(this.requestContext, attrField), String.valueOf(attrField.getId())));
        }
        return options;
    }

    public List<LabelValueBean> getActiveAttrFieldOptionsCache(Integer attributeId) throws DatabaseException {
        this.hideDisabledAttr = true;
        return this.getAttrFieldOptionsCache(attributeId);
    }

    public AttributeManager setSelectedAttrFieldIds(List<Integer> selectedAttrFieldIds) {
        this.selectedAttrFieldIds = selectedAttrFieldIds;
        return this;
    }

    public AttributeManager setSelectedAttrFieldId(Integer selectedAttrFieldId) {
        this.selectedAttrFieldIds = Arrays.asList(selectedAttrFieldId);
        return this;
    }

    public AttributeManager setOptional(boolean optional) {
        this.isOptional = optional;
        return this;
    }

    public String getAttrFieldNameCache(Integer attributeId, Integer attrFieldId) throws DatabaseException {
        AttributeField attrField = this.getAttrFieldMapCache(attributeId).get(attrFieldId);
        if (attrField == null) {
            return "";
        }
        return AttributeManager.getAttrFieldName(this.requestContext, attrField);
    }

    public static String getAttrFieldName(RequestContext requestContext, AttributeField attrField) {
        if (attrField.getId() < 0) {
            return Localizer.getText(requestContext, "system.attribute_field." + attrField.getName());
        }
        return attrField.getName();
    }

    public Map<Integer, Attribute> getSystemAttributes(BaseObject baseObject) {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("objectTypeId", baseObject.getObjectTypeId());
        attributeSearch.put("isCustomAttr", false);
        QueryCriteria query = new QueryCriteria(attributeSearch);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        LinkedHashMap<Integer, Attribute> map = new LinkedHashMap<Integer, Attribute>();
        try {
            Collection<Attribute> attrs = adminService.getAttributes(query).values();
            for (Attribute attr : attrs) {
                map.put(attr.getId(), attr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static List<Integer> getCustomFieldObjectTypes() {
        return Arrays.asList(ObjectTypes.HARDWARE, ObjectTypes.HARDWARE_COMPONENT, ObjectTypes.SOFTWARE, ObjectTypes.SOFTWARE_LICENSE, ObjectTypes.COMPANY, ObjectTypes.CONTRACT, ObjectTypes.ISSUE, ObjectTypes.USER);
    }

    public Map<Integer, Attribute> getCustomFieldMap(Integer objectTypeId) throws DatabaseException {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("objectTypeId", objectTypeId);
        attributeSearch.put("isCustomAttr", true);
        QueryCriteria query = new QueryCriteria(attributeSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn("attribute_name"));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        return adminService.getAttributes(query);
    }

    public List<LabelValueBean> getCustomFieldOptions(Integer objectTypeId) throws DatabaseException {
        ArrayList<LabelValueBean> fieldOptions = new ArrayList<LabelValueBean>();
        for (Attribute attr : this.getCustomFieldMap(objectTypeId).values()) {
            fieldOptions.add(new LabelValueBean(attr.getName(), String.valueOf(attr.getId())));
        }
        return fieldOptions;
    }

    public Map<Integer, Attribute> populateCustomFieldValues(BaseObjectForm form, BaseObject baseObject) throws DatabaseException {
        Map<Integer, Attribute> customAttributes = this.getCustomFieldMap(baseObject.getObjectTypeId());
        for (Attribute attr : this.getCustomFieldMap(baseObject.getObjectTypeId()).values()) {
            AttributeValue value = new AttributeValue();
            value.setAttributeId(attr.getId());
            value.setAttributeValue(this.requestContext.getParameterString("attrId" + attr.getId()));
            baseObject.getCustomValues().put(attr.getId(), value);
        }
        form.setCustomValues(baseObject.getCustomValues());
        return customAttributes;
    }

    public static void populateCustomFieldValues(Map<String, String> importCustomFields, BaseObject baseObject, Map<Integer, Attribute> customAttributes) {
        for (Attribute attr : customAttributes.values()) {
            String attrValue = importCustomFields.get(attr.getName());
            if (attrValue == null) continue;
            AttributeValue value = new AttributeValue();
            value.setAttributeId(attr.getId());
            value.setAttributeValue(attrValue);
            baseObject.getCustomValues().put(attr.getId(), value);
        }
    }
}

