/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;

public class AdminConfigManager
extends BaseConfigManager {
    private static final AdminConfigManager instance = new AdminConfigManager();
    private static final int ACCOUNT_LOCKOUT_VALUE = -1;
    private String[] numberOfRowsToShowOptions;
    private String[] usernameDisplayOptions;
    private boolean allowBlankUserPassword;
    private boolean securityPasswordComplexityEnabled;
    private int accountLockoutThreshold;
    private int accountLockoutDurationMinutes;
    private long accountLockoutDurationMs;
    private boolean isMultiAppsInstance;
    private boolean isValidateAcctLockout;

    private AdminConfigManager() {
    }

    static AdminConfigManager getInstance() {
        return instance;
    }

    @Override
    void init(ConfigManager configManager) {
        this.allowBlankUserPassword = configManager.getString("admin.allowBlankUserPassword").equals("1");
        this.isMultiAppsInstance = configManager.getBoolean("System.MultiAppsInstance");
        this.usernameDisplayOptions = new String[]{"username", "user_display_name"};
        this.numberOfRowsToShowOptions = configManager.getStringArray("module.numberOfRowsToShow.options");
        this.securityPasswordComplexityEnabled = configManager.getBoolean("System.Security.UserPasswordComplexityEnabled");
        this.accountLockoutThreshold = configManager.getInt("System.Security.AccountLockoutThreshold");
        this.accountLockoutDurationMinutes = configManager.getInt("System.Security.AccountLockoutDurationMinutes");
        this.accountLockoutDurationMs = this.accountLockoutDurationMinutes * 60 * 1000;
        this.isValidateAcctLockout = this.accountLockoutThreshold != 0 && this.accountLockoutDurationMs != 0L;
    }

    public boolean isAllowBlankUserPassword() {
        return this.allowBlankUserPassword;
    }

    public boolean isMultiAppsInstance() {
        return this.isMultiAppsInstance;
    }

    public String[] getNumberOfRowsToShowOptions() {
        return this.numberOfRowsToShowOptions;
    }

    public String[] getUsernameDisplayOptions() {
        return this.usernameDisplayOptions;
    }

    public boolean isSecurityPasswordComplexityEnabled() {
        return this.securityPasswordComplexityEnabled;
    }

    public int getAccountLockoutThreshold() {
        return this.accountLockoutThreshold;
    }

    public int getAccountLockoutDurationMinutes() {
        return this.accountLockoutDurationMinutes;
    }

    public long getAccountLockoutDurationMs() {
        return this.accountLockoutDurationMs;
    }

    public boolean isValidateAcctLockout() {
        return this.isValidateAcctLockout;
    }

    public int getAccountLockoutValue() {
        return -1;
    }
}

