/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import java.util.Arrays;
import java.util.List;

public class AppConfigManager
extends BaseConfigManager {
    private static AppConfigManager instance = new AppConfigManager();
    public static final int ISSUE_DUE_DATE_DEFAULT = 0;
    private boolean loadCustomFields;
    private String[] blogsNumberOfPostCharactersOptions;
    private String[] blogsNumberOfPostsOptions;
    private int blogsNumPosts;
    private int blogsNumberOfPostCharacters;
    private int companyRows;
    private int contactRows;
    private String[] contactColumns;
    private List<String> contactsCompanyColumnList;
    private List<String> contactsCompanyExportColumns;
    private List<String> contactsExportColumns;
    private String[] contractsColumns;
    private List<String> contractsExportColumns;
    private int contractsRowsToShow;
    private int contractsExpireCountdown;
    private int issueRows;
    private List<String> issuesColumns;
    private List<String> issueExportColumns;
    private boolean issuesGuestSubmitModuleEnabled;
    private boolean issuesGuestSubmitFooterEnabled;
    private static final String issuesExportFilename = "issue-list.csv";
    private boolean issuesMultipleDeleteEnabled;
    private boolean issuesDefaultDisplayHtmlEmail;
    private int issueDueDateDiff;
    private int hardwareRowsToShow;
    private List<String> hardwareColumns;
    private List<String> hardwareExportColumns;
    private List<String> hardwareMembersExportColumns;
    private List<String> hardwareLicenseExportColumns;
    private List<String> hardwareImportExportColumns;
    private int hardwareWarrantyExpireCountdown;
    private boolean checkUniqueHardwareName;
    private boolean checkUniqueSerialNumber;
    private boolean hardwareBulkDeleteEnabled;
    private static final int kbArticleNumberOfSearchResults = 10;
    private String[] kbArticleColumns;
    private int kbArticleCharLimit;
    private boolean kbArticleMediaWikiSyntaxEnabled;
    private int rssCacheTimeInMinutes = 1200000;
    private String rssProxyServerAddress;
    private String rssProxyServerPort;
    private final int portalNumberOfSitesToShow = 10;
    private String[] portalColumns;
    private List<String> softwareColumns;
    private List<String> softwareExportColumns;
    private int softwareRowsToShow;
    private int softwareLicenseNotesNumChars;
    private List<String> softwareLicenseColumns;
    private int userRows;
    private int calendarMinYear;
    private int calendarMaxYearPlus;
    private int numPastYears;
    private int numFutureYears;
    private int dataImportRowLimit;
    private String[] expireCountdownOptions;

    private AppConfigManager() {
    }

    static AppConfigManager getInstance() {
        return instance;
    }

    @Override
    void init(ConfigManager configManager) {
        this.expireCountdownOptions = configManager.getStringArray("expirationCountdown.options");
        this.loadCustomFields = configManager.getBoolean("CustomFields.Expand");
        this.dataImportRowLimit = 200;
        this.blogsNumberOfPostCharactersOptions = configManager.getStringArray("portal.numberOfBlogPostCharactersOptions");
        this.blogsNumberOfPostsOptions = configManager.getStringArray("portal.numberOfBlogPostsOptions");
        this.blogsNumPosts = configManager.getInt("blogs.numberOfPostsToShow");
        this.blogsNumberOfPostCharacters = configManager.getInt("blogs.numberOfPostCharsToShow");
        this.contactColumns = configManager.getStringArray("contacts.columnList");
        this.contactsCompanyColumnList = configManager.getStringList("contacts.companyColumnList");
        this.contactsCompanyExportColumns = Arrays.asList("company_name", "company_description");
        this.contactsExportColumns = Arrays.asList("company_name", "contact_first_name", "contact_last_name", "contact_title", "contact_email_primary", "contact_phone_work");
        this.companyRows = configManager.getInt("companies.numberOfRowsToShow");
        this.contactRows = configManager.getInt("contacts.numberOfRowsToShow");
        this.issueRows = configManager.getInt("issues.numberOfRowsToShow");
        this.issuesColumns = configManager.getStringList("issues.columnList");
        this.issueExportColumns = Arrays.asList("issue_id", "issue_name", "issue_description", "issue_type", "issue_status", "issue_priority", "assignee_name", "creator_name", "creation_date", "modifier_name", "modification_date", "issue_due_date");
        this.issuesGuestSubmitModuleEnabled = configManager.getBoolean("Issues.ReportIssueModuleEnabled");
        this.issuesGuestSubmitFooterEnabled = configManager.getBoolean("Issues.ReportIssueFooterEnabled");
        this.issuesMultipleDeleteEnabled = configManager.getBoolean("Issues.multipleDeleteEnabled");
        this.issueDueDateDiff = configManager.getInt("Issues.DueDateDiff");
        this.issuesDefaultDisplayHtmlEmail = configManager.getBoolean("_SpareConfigKey4");
        this.hardwareRowsToShow = configManager.getInt("hardware.numberOfRowsToShow");
        this.hardwareColumns = Arrays.asList(configManager.getStringArray("hardware.columnList"));
        this.hardwareExportColumns = Arrays.asList("hardware_id", "hardware_name", "hardware_description", "hardware_manufacturer_name", "hardware_vendor_name", "hardware_type", "hardware_status", "hardware_model_name", "hardware_model_number", "hardware_serial_number", "hardware_purchase_price", "hardware_purchase_date", "hardware_warranty_expire_date", "hardware_last_service_date", "hardware_location", "hardware_owner_name", "creator_name", "creation_date", "modifier_name", "modification_date");
        this.hardwareImportExportColumns = Arrays.asList("hardware_id", "hardware_name", "hardware_description");
        this.hardwareMembersExportColumns = Arrays.asList("hardware_id", "hardware_name", "hardware_member_id", "hardware_member_name");
        this.hardwareLicenseExportColumns = Arrays.asList("hardware_id", "hardware_name", "software_name", "license_key", "license_note");
        this.hardwareWarrantyExpireCountdown = configManager.getInt("hardware.warrantyExpireCountdown");
        this.checkUniqueHardwareName = configManager.getBoolean("Hardware.CheckUniqueHardwareName");
        this.checkUniqueSerialNumber = configManager.getBoolean("Hardware.CheckUniqueSerialNumber");
        this.hardwareBulkDeleteEnabled = configManager.getBoolean("Hardware.BulkDeleteEnabled");
        this.kbArticleColumns = configManager.getStringArray("kb.article.columns");
        this.kbArticleCharLimit = configManager.getInt("kb.article.charLimit");
        this.kbArticleMediaWikiSyntaxEnabled = configManager.getBoolean("KB.Article.MediaWikiSyntaxEnabled");
        this.portalColumns = configManager.getStringArray("portal.columnList");
        this.softwareColumns = configManager.getStringList("software.columnList");
        this.softwareExportColumns = Arrays.asList("software_name", "software_version", "software_description", "software_expire_date", "software_owner_username", "software_owner_display_name", "software_manufacturer", "software_vendor", "software_platform", "software_type", "software_quoted_retail_price", "software_quoted_oem_price", "license_purchased", "license_installed", "license_available");
        this.softwareRowsToShow = configManager.getInt("software.numberOfRowsToShow");
        this.softwareLicenseNotesNumChars = configManager.getInt("software.numberLicenseNotesChars");
        this.softwareLicenseColumns = configManager.getStringList("Software.Licenses.Columns");
        this.contractsRowsToShow = configManager.getInt("contracts.numberOfRowsToShow");
        this.contractsExportColumns = Arrays.asList("contract_name", "contract_type", "contract_stage", "contract_owner_username", "contract_owner_display_name", "contract_expiration_date", "contract_effective_date", "contract_renewal_type", "contract_renewal_date");
        this.contractsExpireCountdown = configManager.getInt("contracts.expirationCountdown");
        this.contractsColumns = configManager.getStringArray("contracts.columnList");
        this.userRows = configManager.getInt("users.numberOfRowsToShow");
        this.numPastYears = configManager.getInt("datetime.numberOfPastYears");
        this.numFutureYears = configManager.getInt("datetime.numberOfUpcomingYears");
        this.calendarMinYear = configManager.getInt("calendar.minYear");
        this.calendarMaxYearPlus = configManager.getInt("calendar.maxYearPlus");
        this.rssProxyServerAddress = configManager.getString("Rss.ProxyServerAddress");
        this.rssProxyServerPort = configManager.getString("Rss.ProxyServerPort");
    }

    public int getNumPastYears() {
        return this.numPastYears;
    }

    public int getHardwareRowsToShow() {
        return this.hardwareRowsToShow;
    }

    public int getCompanyRows() {
        return this.companyRows;
    }

    public int getCalendarMinYear() {
        return this.calendarMinYear;
    }

    public int getUserRows() {
        return this.userRows;
    }

    public int getCalendarMaxYearPlus() {
        return this.calendarMaxYearPlus;
    }

    public String[] getBlogsNumberOfPostsOptions() {
        return this.blogsNumberOfPostsOptions;
    }

    public String[] getBlogsNumberOfPostCharactersOptions() {
        return this.blogsNumberOfPostCharactersOptions;
    }

    public int getRssCacheTimeInMinutes() {
        return this.rssCacheTimeInMinutes;
    }

    public List<String> getHardwareColumns() {
        return this.hardwareColumns;
    }

    public List<String> getSoftwareColumns() {
        return this.softwareColumns;
    }

    public List<String> getIssuesColumns() {
        return this.issuesColumns;
    }

    public List<String> getContactsCompanyColumnList() {
        return this.contactsCompanyColumnList;
    }

    public String[] getContactColumns() {
        return this.contactColumns;
    }

    public String[] getPortalColumns() {
        return this.portalColumns;
    }

    public List<String> getHardwareExportColumns() {
        return this.hardwareExportColumns;
    }

    public String getIssuesExportFilename() {
        return issuesExportFilename;
    }

    public String[] getExpireCountdownOptions() {
        return this.expireCountdownOptions;
    }

    public int getPortalNumberOfSitesToShow() {
        return 10;
    }

    public int getHardwareWarrantyExpireCountdown() {
        return this.hardwareWarrantyExpireCountdown;
    }

    public int getKbArticleNumberOfSearchResults() {
        return 10;
    }

    public int getSoftwareRowsToShow() {
        return this.softwareRowsToShow;
    }

    public int getContractsRowsToShow() {
        return this.contractsRowsToShow;
    }

    public String[] getContractsColumns() {
        return this.contractsColumns;
    }

    public int getContractsExpireCountdown() {
        return this.contractsExpireCountdown;
    }

    public List<String> getIssueExportColumns() {
        return this.issueExportColumns;
    }

    public List<String> getSoftwareExportColumns() {
        return this.softwareExportColumns;
    }

    public List<String> getContractsExportColumns() {
        return this.contractsExportColumns;
    }

    public boolean isIssuesGuestSubmitFooterEnabled() {
        return this.issuesGuestSubmitFooterEnabled;
    }

    public List<String> getContactsExportColumns() {
        return this.contactsExportColumns;
    }

    public int getNumFutureYears() {
        return this.numFutureYears;
    }

    public int getBlogsNumPosts() {
        return this.blogsNumPosts;
    }

    public int getIssueRows() {
        return this.issueRows;
    }

    public String[] getKbArticleColumns() {
        return this.kbArticleColumns;
    }

    public int getBlogsNumberOfPostCharacters() {
        return this.blogsNumberOfPostCharacters;
    }

    public int getKbArticleCharLimit() {
        return this.kbArticleCharLimit;
    }

    public int getContactRows() {
        return this.contactRows;
    }

    public int getSoftwareLicenseNotesNumChars() {
        return this.softwareLicenseNotesNumChars;
    }

    public boolean isCheckUniqueHardwareName() {
        return this.checkUniqueHardwareName;
    }

    public boolean isIssuesGuestSubmitModuleEnabled() {
        return this.issuesGuestSubmitModuleEnabled;
    }

    public boolean isLoadCustomFields() {
        return this.loadCustomFields;
    }

    public List<String> getHardwareMembersExportColumns() {
        return this.hardwareMembersExportColumns;
    }

    public List<String> getHardwareLicenseExportColumns() {
        return this.hardwareLicenseExportColumns;
    }

    public List<String> getHardwareImportExportColumns() {
        return this.hardwareImportExportColumns;
    }

    public boolean isIssuesMultipleDeleteEnabled() {
        return this.issuesMultipleDeleteEnabled;
    }

    public boolean isIssuesDefaultDisplayHtmlEmail() {
        return this.issuesDefaultDisplayHtmlEmail;
    }

    public int getDataImportRowLimit() {
        return this.dataImportRowLimit;
    }

    public List<String> getContactsCompanyExportColumns() {
        return this.contactsCompanyExportColumns;
    }

    public boolean isCheckUniqueSerialNumber() {
        return this.checkUniqueSerialNumber;
    }

    public int getIssueDueDateDiff() {
        return this.issueDueDateDiff;
    }

    public boolean isKbArticleMediaWikiSyntaxEnabled() {
        return this.kbArticleMediaWikiSyntaxEnabled;
    }

    public boolean isHardwareBulkDeleteEnabled() {
        return this.hardwareBulkDeleteEnabled;
    }

    public List<String> getSoftwareLicenseColumns() {
        return this.softwareLicenseColumns;
    }

    public String getRssProxyServerAddress() {
        return this.rssProxyServerAddress;
    }

    public String getRssProxyServerPort() {
        return this.rssProxyServerPort;
    }
}

