/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import java.util.Arrays;
import java.util.List;

public class AuthConfigManager
extends BaseConfigManager {
    private static final AuthConfigManager instance = new AuthConfigManager();
    public static final String LDAPS_URL_SCHEMA = "ldaps://";
    public static final String LDAP_URL_SCHEMA = "ldap://";
    private String authMethod;
    private String[] authMethodOptions;
    private String authLdapSecurityPrincipal;
    private String ldapUrlScheme;
    private String[] ldapUrlSchemeOptions;
    private String authLdapUrl;
    private String authDomain;
    private List<String> authDomainOptions;
    private int sessionTimeoutHours;
    private int sessionTimeoutSeconds;
    private String[] sessionTimeoutSecondsOptions;
    private String authType;
    private String[] authTypeOptions;
    private boolean isBasicAuth;
    private int securityMinPasswordLength;

    private AuthConfigManager() {
    }

    static AuthConfigManager getInstance() {
        return instance;
    }

    @Override
    void init(ConfigManager configManager) {
        this.authMethod = configManager.getString("auth.authenticationMethod");
        this.authMethodOptions = configManager.getString("auth.authenticationMethod.options").split(",");
        this.authLdapSecurityPrincipal = configManager.getString("auth.ldap.securityPrincipal");
        this.ldapUrlScheme = configManager.getString("auth.ldap.url.scheme");
        this.ldapUrlSchemeOptions = new String[]{LDAP_URL_SCHEMA, LDAPS_URL_SCHEMA};
        this.authLdapUrl = configManager.getString("auth.ldapUrl");
        this.authDomain = configManager.getString("auth.domain");
        this.authDomainOptions = Arrays.asList(this.authDomain.split(","));
        this.sessionTimeoutSeconds = configManager.getInt("auth.sessionTimeoutSeconds");
        this.sessionTimeoutHours = configManager.getInt("auth.sessionTimeoutSeconds") / 3600;
        this.sessionTimeoutSecondsOptions = configManager.getString("auth.sessionTimeoutSeconds.options").split(",");
        this.securityMinPasswordLength = configManager.getInt("System.Security.UserPasswordLength");
        this.authType = configManager.getString("auth.type");
        this.isBasicAuth = configManager.getString("auth.type").equals("basic");
        this.authTypeOptions = configManager.getStringArray("auth.type.options");
    }

    public boolean isDbAuthEnabled() {
        return this.authMethod.equals("app") || this.authMethod.equals("mixed");
    }

    public boolean isLdapAuthEnabled() {
        return this.authMethod.equals("ldap") || this.authMethod.equals("mixed");
    }

    public int getSessionTimeoutHours() {
        return this.sessionTimeoutHours;
    }

    public int getSessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public String[] getSessionTimeoutSecondsOptions() {
        return this.sessionTimeoutSecondsOptions;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String[] getAuthMethodOptions() {
        return this.authMethodOptions;
    }

    public String getAuthLdapUrl() {
        return this.authLdapUrl;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public List<String> getAuthDomainOptions() {
        return this.authDomainOptions;
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean isBasicAuth() {
        return this.isBasicAuth;
    }

    public String getAuthLdapSecurityPrincipal() {
        return this.authLdapSecurityPrincipal;
    }

    public int getSecurityMinPasswordLength() {
        return this.securityMinPasswordLength;
    }

    public String[] getAuthTypeOptions() {
        return this.authTypeOptions;
    }

    public String getLdapUrlScheme() {
        return this.ldapUrlScheme;
    }

    public String[] getLdapUrlSchemeOptions() {
        return this.ldapUrlSchemeOptions;
    }
}

