/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.AdminConfigManager;
import com.kwoksys.biz.system.core.configs.AppConfigManager;
import com.kwoksys.biz.system.core.configs.AuthConfigManager;
import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.EmailConfigManager;
import com.kwoksys.biz.system.core.configs.FileConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.core.configs.ReportConfigManager;
import com.kwoksys.biz.system.core.configs.SystemConfigManager;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.util.NumberUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigManager.class.getName());
    private static final ConfigManager INSTANCE = new ConfigManager();
    public static AdminConfigManager admin = AdminConfigManager.getInstance();
    public static AuthConfigManager auth = AuthConfigManager.getInstance();
    public static EmailConfigManager email = EmailConfigManager.getInstance();
    public static FileConfigManager file = FileConfigManager.getInstance();
    public static AppConfigManager app = AppConfigManager.getInstance();
    public static ReportConfigManager reports = ReportConfigManager.getInstance();
    public static SystemConfigManager system = SystemConfigManager.getInstance();
    public static List<BaseConfigManager> list = Arrays.asList(admin, auth, email, file, reports, app, system);
    private static String schemaVersion;
    private static boolean devMode;
    private Map<String, String> configMap;

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public void init() throws Exception {
        LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Initializing " + ConfigManager.class.getSimpleName() + "...");
        this.configMap = new CacheManager().cacheSystemConfigs();
        try {
            schemaVersion = this.configMap.get("schema.version");
            for (BaseConfigManager configMgr : list) {
                configMgr.init(this);
            }
            LogConfigManager.init(this.configMap);
        }
        catch (Exception e) {
            throw new Exception("Problem setting system config values", e);
        }
    }

    public static String getSchemaVersion() {
        return schemaVersion;
    }

    protected boolean getBoolean(String configKey) {
        return Boolean.valueOf(this.configMap.get(configKey));
    }

    protected String getString(String configKey) {
        return this.configMap.get(configKey);
    }

    protected int getInt(String configKey) {
        return NumberUtils.replaceNull(this.configMap.get(configKey));
    }

    protected Integer getInteger(String configKey) {
        return this.configMap.get(configKey).isEmpty() ? null : Integer.valueOf(this.configMap.get(configKey));
    }

    protected long getLong(String configKey) {
        return Long.valueOf(this.configMap.get(configKey));
    }

    protected String[] getStringArray(String configKey) {
        return this.configMap.get(configKey).split(",");
    }

    protected List<String> getStringList(String configKey) {
        return Arrays.asList(this.configMap.get(configKey).split(","));
    }

    public static boolean isDevMode() {
        return devMode;
    }

    static {
        devMode = false;
    }
}

