/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class EmailConfigManager
extends BaseConfigManager {
    private static final EmailConfigManager INSTANCE = new EmailConfigManager();
    private boolean issueNotificationFromUiEnabled;
    private boolean issueNotificationFromEmailEnabled;
    private boolean contractExpireNotificationEnabled;
    private String allowedDomains;
    private List<String> allowedDomainLowercaseOptions;
    private String smtpFrom;
    private String smtpTo;
    private String smtpHost;
    private String smtpPort;
    private String smtpUsername;
    private String smtpPassword;
    private boolean smtpStartTls;
    private String incomingEmailProtocol;
    private String popPassword;
    private String popHost;
    private String popPort;
    private String popUsername;
    private boolean popSslEnabled;
    private String popSenderIgnoreList;
    private int popRepeatInterval;
    private int popMessagesLimit;
    private long contractNotificationInterval;
    private int contractNotificationBatchSize;
    private String contractExpireNotificationEmailTemplate;
    private String[] contractExpirationThresholds;
    private String issueReportEmailTemplate;
    private String issueAddEmailTemplate;
    private String issueUpdateEmailTemplate;
    private String inboundEmailOauthEndpoint;
    private String inboundEmailOauthParams;

    private EmailConfigManager() {
    }

    static EmailConfigManager getInstance() {
        return INSTANCE;
    }

    @Override
    void init(ConfigManager configManager) {
        this.issueNotificationFromUiEnabled = configManager.getBoolean("Email.IssueNotificationFromUiEnabled");
        this.issueNotificationFromEmailEnabled = configManager.getBoolean("Email.IssueNotificationFromEmailEnabled");
        this.contractExpireNotificationEnabled = configManager.getBoolean("Email.ContractExpirationNotificationEnabled");
        this.allowedDomains = configManager.getString("email.allowedDomains");
        this.allowedDomainLowercaseOptions = new ArrayList<String>();
        for (String name : this.allowedDomains.split(",")) {
            if (name.trim().isEmpty()) continue;
            this.allowedDomainLowercaseOptions.add(name.trim().toLowerCase());
        }
        this.issueReportEmailTemplate = configManager.getString("Issues.IssueReportEmailTemplate");
        this.issueAddEmailTemplate = configManager.getString("Issues.IssueAddEmailTemplate");
        this.issueUpdateEmailTemplate = configManager.getString("Issues.IssueUpdateEmailTemplate");
        this.smtpFrom = configManager.getString("mail.smtp.from");
        this.smtpTo = configManager.getString("mail.smtp.to");
        this.smtpHost = configManager.getString("mail.smtp.host");
        this.smtpPort = configManager.getString("mail.smtp.port");
        this.smtpUsername = configManager.getString("mail.smtp.username");
        this.smtpPassword = StringUtils.decodeBase64Codec(configManager.getString("mail.smtp.password"));
        this.smtpStartTls = configManager.getBoolean("mail.smtp.starttls");
        this.incomingEmailProtocol = configManager.getString("_SpareConfigKey3");
        if (this.incomingEmailProtocol.isEmpty()) {
            this.incomingEmailProtocol = "pop3";
        }
        this.inboundEmailOauthEndpoint = configManager.getString("_SpareConfigKey5");
        this.inboundEmailOauthParams = configManager.getString("_SpareConfigKey6");
        this.popHost = configManager.getString("mail.pop.host");
        this.popPort = configManager.getString("mail.pop.port");
        this.popUsername = configManager.getString("mail.pop.username");
        this.popPassword = configManager.getString("mail.pop.password");
        this.popSslEnabled = configManager.getBoolean("mail.pop.ssl.enable");
        this.popSenderIgnoreList = configManager.getString("mail.pop.senderIgnoreList");
        this.popRepeatInterval = configManager.getInt("mail.pop.repeatInterval");
        this.popMessagesLimit = configManager.getInt("mail.pop.messages.limit");
        this.contractNotificationInterval = 3600000L;
        this.contractNotificationBatchSize = 20;
        this.contractExpireNotificationEmailTemplate = configManager.getString("Email.ContractExpireNotificationTemplate");
        this.contractExpirationThresholds = "-1,0,7,30,60,90".split(",");
    }

    public String getSmtpFrom() {
        return this.smtpFrom;
    }

    public String getSmtpTo() {
        return this.smtpTo;
    }

    public boolean isIssueNotificationFromUiEnabled() {
        return this.issueNotificationFromUiEnabled;
    }

    public boolean isContractExpireNotificationEnabled() {
        return this.contractExpireNotificationEnabled;
    }

    public List<String> getAllowedDomainLowercaseOptions() {
        return this.allowedDomainLowercaseOptions;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public String getPopPassword() {
        return this.popPassword;
    }

    public String getIncomingEmailProtocol() {
        return this.incomingEmailProtocol;
    }

    public String getAllowedDomains() {
        return this.allowedDomains;
    }

    public boolean isPopSslEnabled() {
        return this.popSslEnabled;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public String getPopHost() {
        return this.popHost;
    }

    public String getPopPort() {
        return this.popPort;
    }

    public boolean getSmtpStartTls() {
        return this.smtpStartTls;
    }

    public String getPopUsername() {
        return this.popUsername;
    }

    public String getPopSenderIgnoreList() {
        return this.popSenderIgnoreList;
    }

    public int getPopRepeatInterval() {
        return this.popRepeatInterval;
    }

    public int getPopMessagesLimit() {
        return this.popMessagesLimit;
    }

    public String getIssueReportEmailTemplate() {
        return this.issueReportEmailTemplate;
    }

    public String getIssueAddEmailTemplate() {
        return this.issueAddEmailTemplate;
    }

    public String getIssueUpdateEmailTemplate() {
        return this.issueUpdateEmailTemplate;
    }

    public long getContractNotificationInterval() {
        return this.contractNotificationInterval;
    }

    public int getContractNotificationBatchSize() {
        return this.contractNotificationBatchSize;
    }

    public String[] getContractExpirationThresholds() {
        return this.contractExpirationThresholds;
    }

    public String getContractExpireNotificationEmailTemplate() {
        return this.contractExpireNotificationEmailTemplate;
    }

    public boolean isIssueNotificationFromEmailEnabled() {
        return this.issueNotificationFromEmailEnabled;
    }

    public String getInboundEmailOauthEndpoint() {
        return this.inboundEmailOauthEndpoint;
    }

    public void setInboundEmailOauthEndpoint(String inboundEmailOauthEndpoint) {
        this.inboundEmailOauthEndpoint = inboundEmailOauthEndpoint;
    }

    public String getInboundEmailOauthParams() {
        return this.inboundEmailOauthParams;
    }

    public void setInboundEmailOauthParams(String inboundEmailOauthParams) {
        this.inboundEmailOauthParams = inboundEmailOauthParams;
    }
}

