/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;

public class FileConfigManager
extends BaseConfigManager {
    private static FileConfigManager instance = new FileConfigManager();
    private static final String DELETE_FILE_PREFIX = "DEL-";
    private static final String POSTGRES_BACKUP_EXTENSION = ".backup";
    private long maxFileUploadSize;
    private int kilobyteUnits;
    private Integer[] kilobyteUnitsList = new Integer[]{1000, 1024};
    private String companyFileRepositoryLocation;
    private String companyUploadedFilePrefix;
    private String hardwareFileRepositoryLocation;
    private String hardwareUploadedFilePrefix;
    private String softwareFileRepositoryLocation;
    private String softwareUploadedFilePrefix;
    private String issueFileRepositoryLocation;
    private String issueUploadedFilePrefix;
    private String contractFileRepositoryLocation;
    private String contractUploadedFilePrefix;
    private String kbFileRepositoryLocation;
    private String kbUploadedFilePrefix;
    private String dbPostgresProgramPath;
    private String dbBackupRepositoryPath;

    private FileConfigManager() {
    }

    static FileConfigManager getInstance() {
        return instance;
    }

    @Override
    void init(ConfigManager configManager) {
        this.kilobyteUnits = configManager.getInt("Files.KilobyteUnits");
        this.maxFileUploadSize = configManager.getLong("Files.MaxUploadByteSize");
        this.companyFileRepositoryLocation = configManager.getString("file.company.repositoryPath");
        this.companyUploadedFilePrefix = configManager.getString("file.company.uploadFilePrefix");
        this.hardwareFileRepositoryLocation = configManager.getString("file.hardware.repositoryPath");
        this.hardwareUploadedFilePrefix = configManager.getString("file.hardware.uploadFilePrefix");
        this.softwareFileRepositoryLocation = configManager.getString("file.software.repositoryPath");
        this.softwareUploadedFilePrefix = configManager.getString("file.software.uploadFilePrefix");
        this.issueFileRepositoryLocation = configManager.getString("file.issue.repositoryPath");
        this.issueUploadedFilePrefix = configManager.getString("file.issue.uploadFilePrefix");
        this.contractFileRepositoryLocation = configManager.getString("file.contract.repositoryPath");
        this.contractUploadedFilePrefix = configManager.getString("file.contract.uploadFilePrefix");
        this.kbFileRepositoryLocation = configManager.getString("file.kb.repositoryPath");
        this.kbUploadedFilePrefix = configManager.getString("file.kb.uploadFilePrefix");
        this.dbPostgresProgramPath = configManager.getString("db.postgresProgramPath");
        this.dbBackupRepositoryPath = configManager.getString("file.db.backup.repositoryPath");
    }

    public String getDeleteFilePrefix() {
        return DELETE_FILE_PREFIX;
    }

    public String getCompanyFileRepositoryLocation() {
        return this.companyFileRepositoryLocation;
    }

    public String getCompanyUploadedFilePrefix() {
        return this.companyUploadedFilePrefix;
    }

    public String getSoftwareFileRepositoryLocation() {
        return this.softwareFileRepositoryLocation;
    }

    public String getSoftwareUploadedFilePrefix() {
        return this.softwareUploadedFilePrefix;
    }

    public String getHardwareUploadedFilePrefix() {
        return this.hardwareUploadedFilePrefix;
    }

    public String getHardwareFileRepositoryLocation() {
        return this.hardwareFileRepositoryLocation;
    }

    public String getIssueUploadedFilePrefix() {
        return this.issueUploadedFilePrefix;
    }

    public String getIssueFileRepositoryLocation() {
        return this.issueFileRepositoryLocation;
    }

    public String getContractFileRepositoryLocation() {
        return this.contractFileRepositoryLocation;
    }

    public String getContractUploadedFilePrefix() {
        return this.contractUploadedFilePrefix;
    }

    public String getKbUploadedFilePrefix() {
        return this.kbUploadedFilePrefix;
    }

    public long getMaxFileUploadSize() {
        return this.maxFileUploadSize;
    }

    public int getKilobyteUnits() {
        return this.kilobyteUnits;
    }

    public Integer[] getKilobyteUnitsList() {
        return this.kilobyteUnitsList;
    }

    public String getKbFileRepositoryLocation() {
        return this.kbFileRepositoryLocation;
    }

    public String getDbPostgresProgramPath() {
        return this.dbPostgresProgramPath;
    }

    public String getDbBackupRepositoryPath() {
        return this.dbBackupRepositoryPath;
    }

    public String getPostgresBackupExtension() {
        return POSTGRES_BACKUP_EXTENSION;
    }
}

