/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.AppPaths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class LogConfigManager {
    private static Map<String, String> map = new HashMap<String, String>();
    public static final String PAGE_REQUEST_PREFIX = "[Page Request" + AppPaths.ROOT + "]";
    public static final String DATABASE_ACCESS_PREFIX = "[Database Access" + AppPaths.ROOT + "]";
    public static final String AUTHENTICATION_PREFIX = "[Authentication" + AppPaths.ROOT + "]";
    public static final String SCHEDULER_PREFIX = "[Scheduler" + AppPaths.ROOT + "]";
    public static final String CONFIG_PREFIX = "[Config" + AppPaths.ROOT + "]";
    public static final String EMAIL_PREFIX = "[Email" + AppPaths.ROOT + "]";
    public static final String SHUTDOWN_PREFIX = "[Shutdown" + AppPaths.ROOT + "]";
    public static final String TEMPLATE_PREFIX = "[Template" + AppPaths.ROOT + "]";
    public static final String CACHE_PREFIX = "[Cache" + AppPaths.ROOT + "]";
    public static final String TEST_PREFIX = "[Test]";
    public static final String LOG_LEVEL_INFO = "INFO";
    public static final String LOG_LEVEL_OFF = "OFF";

    public static void init(Map<String, String> configMap) {
        map.put(DATABASE_ACCESS_PREFIX, configMap.get("logging.database.level"));
        map.put(AUTHENTICATION_PREFIX, configMap.get("logging.ldap.level"));
        map.put(SCHEDULER_PREFIX, configMap.get("Logging.Level.Scheduler"));
        map.put(TEMPLATE_PREFIX, configMap.get("Logging.Level.Template"));
    }

    public static Level getLogLevel(String prefix) {
        String level = map.get(prefix);
        if (LOG_LEVEL_OFF.equals(level)) {
            return LogLevel.OFF;
        }
        return Level.INFO;
    }

    private static class LogLevel
    extends Level {
        public static final LogLevel OFF = new LogLevel("OFF", 0);

        protected LogLevel(String name, int value) {
            super(name, value);
        }
    }
}

