/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.configs;

import com.kwoksys.biz.system.core.configs.BaseConfigManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class SystemConfigManager
extends BaseConfigManager {
    private static SystemConfigManager instance = new SystemConfigManager();
    private static final String EXTENSION = ".htm";
    private static final String CHARACTER_ENCODING = "UTF-8";
    private String appUrl;
    private String cacheKey;
    private Long cacheTime;
    private String licenseKey;
    private String trailingSlash;
    private String currencySymbol;
    private String customHomeDescription;
    private String[] localeOptions;
    private TimeZone timezoneBase;
    private String timezoneBaseString;
    private TimeZone timezoneLocal;
    private String timezoneLocalString;
    private String[] timezoneLocalOptions;
    private String timeFormat;
    private String[] timeFormatOptions;
    private String usernameDisplay;
    private String dateFormat;
    private String datetimeBase;
    private List<String> moduleTabs;
    private String theme;
    private String[] themeOptions;
    private int[] fontOptions;
    private String[] dateFormatOptions;
    private String localeString;
    private Locale locale;
    private String companyName;
    private String companyPath;
    private String companyLogoPath;
    private String companyFooterNotes;
    private String sytlesheet;
    private String detailsTableStyle;
    public static final int DB_MAX_CONNECTION_UNLIITED = -1;
    private int dbMaxConnection = -1;

    private SystemConfigManager() {
    }

    static SystemConfigManager getInstance() {
        return instance;
    }

    @Override
    void init(ConfigManager configManager) {
        this.appUrl = configManager.getString("url.application");
        this.cacheKey = configManager.getString("system.cacheKey");
        this.currencySymbol = configManager.getString("currency.options");
        this.companyName = configManager.getString("companyName");
        this.companyPath = configManager.getString("companyPath");
        this.companyLogoPath = configManager.getString("companyLogoPath");
        this.companyFooterNotes = configManager.getString("company.footerNotes");
        this.customHomeDescription = configManager.getString("home.customDescription");
        this.datetimeBase = configManager.getString("datetime.base");
        this.dateFormat = configManager.getString("datetime.shortDateFormat");
        this.dateFormatOptions = configManager.getStringArray("datetime.shortDateFormat.options");
        this.licenseKey = configManager.getString("system.licenseKey");
        this.localeString = configManager.getString("locale");
        String[] strings = this.localeString.split("_");
        this.locale = new Locale(strings[0], strings[1]);
        this.localeOptions = configManager.getStringArray("locale.options");
        this.moduleTabs = configManager.getStringList("template.moduleTabs");
        this.theme = configManager.getString("theme.default");
        this.themeOptions = new String[]{"blue", "green", "red", "orange", "purple", "gray"};
        this.fontOptions = new int[]{12, 13, 14};
        this.timezoneBaseString = configManager.getString("timezone.base");
        this.timezoneBase = TimeZone.getTimeZone(this.timezoneBaseString);
        this.timezoneLocalString = configManager.getString("timezone.local");
        this.timezoneLocal = TimeZone.getTimeZone(this.timezoneLocalString);
        this.timezoneLocalOptions = configManager.getStringArray("timezone.local.options");
        this.trailingSlash = System.getProperty("file.separator");
        this.sytlesheet = configManager.getString("ui.stylesheet");
        this.detailsTableStyle = "standard details";
        this.timeFormat = configManager.getString("datetime.timeFormat");
        this.timeFormatOptions = configManager.getStringArray("datetime.timeFormat.options");
        this.usernameDisplay = configManager.getString("Users.NameDisplay");
        this.dbMaxConnection = configManager.getInt("System.DB.MaxConnection");
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getLocaleString() {
        return this.localeString;
    }

    public String getTrailingSlash() {
        return this.trailingSlash;
    }

    public String[] getTimeFormatOptions() {
        return this.timeFormatOptions;
    }

    public String[] getDateFormatOptions() {
        return this.dateFormatOptions;
    }

    public String[] getLocaleOptions() {
        return this.localeOptions;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public String[] getTimezoneLocalOptions() {
        return this.timezoneLocalOptions;
    }

    public String getDatetimeBase() {
        return this.datetimeBase;
    }

    public List<String> getModuleTabs() {
        return this.moduleTabs;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCharacterEncoding() {
        return CHARACTER_ENCODING;
    }

    public String[] getThemeOptions() {
        return this.themeOptions;
    }

    public String getCustomHomeDescription() {
        return this.customHomeDescription;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getTimezoneBaseString() {
        return this.timezoneBaseString;
    }

    public TimeZone getTimezoneBase() {
        return this.timezoneBase;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getCompanyLogoPath() {
        return this.companyLogoPath;
    }

    public String getCompanyPath() {
        return this.companyPath;
    }

    public String getCompanyFooterNotes() {
        return this.companyFooterNotes;
    }

    public String getSytlesheet() {
        return this.sytlesheet;
    }

    public TimeZone getTimezoneLocal() {
        return this.timezoneLocal;
    }

    public String getTimezoneLocalString() {
        return this.timezoneLocalString;
    }

    public String getUsernameDisplay() {
        return this.usernameDisplay;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Long getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(Long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public int[] getFontOptions() {
        return this.fontOptions;
    }

    public int getDbMaxConnection() {
        return this.dbMaxConnection;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public String getDetailsTableStyle() {
        return this.detailsTableStyle;
    }
}

