/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.scheduler;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractSearch;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.Callback;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContractExpirationNotificationTask {
    private static final Logger LOGGER = Logger.getLogger(ContractExpirationNotificationTask.class.getName());

    public void execute() {
        try {
            LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX), LogConfigManager.SCHEDULER_PREFIX + " Checking contract for expiration notification emails...");
            RequestContext requestContext = new RequestContext();
            SystemService systemService = ServiceProvider.getSystemService(requestContext);
            requestContext.setSysdate(systemService.getSystemInfo().getSysdate());
            final ContractService contractService = ServiceProvider.getContractService(requestContext);
            String[] thresholds = ConfigManager.email.getContractExpirationThresholds();
            Counter thresholdCounter = new Counter();
            int notificationLimit = ConfigManager.email.getContractNotificationBatchSize();
            final Counter notificationCounter = new Counter();
            while (thresholdCounter.getCurrent() < thresholds.length - 1 && notificationCounter.getCurrent() < notificationLimit) {
                String currentThreshold = thresholds[thresholdCounter.getCurrent()];
                final String nextThreshold = thresholds[thresholdCounter.incr()];
                ContractSearch contractSearch = new ContractSearch();
                if (currentThreshold.equals("-1")) {
                    contractSearch.put("expiredContracts", true);
                } else {
                    contractSearch.put("contractExpireAfter", currentThreshold);
                    contractSearch.put("contractExpireBefore", nextThreshold);
                }
                contractSearch.put("expirationNotified", nextThreshold);
                QueryCriteria queryCriteria = new QueryCriteria(contractSearch);
                queryCriteria.setLimit(notificationLimit, 0);
                queryCriteria.setCallback(new Callback(){

                    @Override
                    public void run(Object object) throws Exception {
                        Contract contract = (Contract)object;
                        notificationCounter.incr();
                        contractService.sendContractExpirationReminder(contract, Integer.parseInt(nextThreshold));
                    }
                });
                contractService.fetchContracts(queryCriteria);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, LogConfigManager.SCHEDULER_PREFIX + " Problem sending contract expiration notification emails ", e);
        }
    }
}

